import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"es" : {
			"Affirm" : "Confirmar",
			"Search..." : "Buscar...",
			"Loading..." : "Cargando...",
			"Cancel" : "Cancelar",
			"OK" : "Aceptar",
			"Tasks" : "Tareas",
			"My tasks" : "Mis tareas",
			"results" : "resultados",
			"one result" : "un resultado",
			"no results" : "no hay resultados",
			"Back" : "Anterior",
			"Next" : "Siguiente",
			"Drag and drop a file here or click" : "Arrastre y suelte un archivo aquí o haga click",
			"Remove location" : "Quitar ubicación",
			"goto space" : "ir al espacio",
			"available" : "disponibles",
			"deleted" : "borrados",
			"Sending to selected provider..." : "Enviando al proveedor seleccionado...",
			"Sending to selected worker..." : "Enviando al trabajador seleccionado...",
			"New" : "Nueva",
			"Pending" : "Pendiente",
			"Waiting" : "En espera",
			"Expired" : "Caducado",
			"Non expired" : "Activo",
			"Finished" : "Finalizada",
			"Aborted" : "Abortada",
			"Failure" : "Error",
			"Are you sure you want continue with task?" : "¿Está seguro/a que quiere continuar con la tarea?",
			"Folder" : "Directorio",
			"Urgents" : "Urgentes",
			"Nature" : "Naturaleza",
			"Task" : "Tarea",
			"Tasks" : "Tareas",
			"History" : "Histórico",
			"by" : "por",
			"Task is" : "La tarea está",
			"Continue" : "Continuar",
			"No form defined" : "No se ha definido ningún formulario",
			"It could not solve task edition" : "No se puede resolver la edición del elemento",
			"Are you sure to unassign task?" : "¿Está seguro/a que desea desasignar la tarea?",
			"Are you sure to abort task?" : "¿Está seguro/a que desea abortar la tarea?",
			"pospone one hour" : "aplazar una hora",
			"define for next hour" : "definir para la próxima hora",
			"pospone one day" : "aplazar un día",
			"define for next day" : "definir para el próximo día",
			"pospone one month" : "aplazar un mes",
			"define for next month" : "definir para el próximo mes",
			"pospone one year" : "aplazar un año",
			"define for next year" : "definir para el próximo año",
			"don't pospone" : "no esperar más",
			"Due date is" : "La fecha de vencimiento es",
			"Due date not defined" : "No se ha definido una fecha de vencimiento",
			"No external/internal provider defined. Contact with administrator" : "No se ha definido ningún proveedor externo/interno. Contacte con el administrador",
			"No roles of type ::role:: defined for delegation" : "No se ha encontrado ningún role de tipo ::role:: que permita realizar esta acción",
			"No roles of type ::role:: defined for job" : "No se ha encontrado ningún role de tipo ::role:: que permita realizar el trabajo",
			"Select client to whom send order:" : "Selecciona el cliente al cual enviar el encargo:",
			"Select user to whom send order:" : "Selecciona el usuario al cual enviar el encargo:",
			"Setup order for ::role::" : "Configura el encargo que se enviará a ::role::",
			"Sending order..." : "Enviando encargo...",
			"Trying to send order. Last sent request was at" : "Intentando enviar el encargo. El último intento de envío fue realizado el",
			"Trying to send order." : "Intentando enviar el encargo.",
			"Suggested start date" : "Fecha de inicio propuesta",
			"Suggested end date" : "Fecha de fin propuesta",
			"Comments" : "Observaciones",
			"Urgent" : "Urgente",
			"Sending request. Please, wait..." : "Enviando solicitud. Por favor, espere...",
			"There was an attempt to send a request that failed" : "Hubo un intento de envío de una solicitud que falló",
			"Sending response. Please, wait..." : "Enviando respuesta. Por favor, espere...",
			"There was an attempt to send a response that failed" : "Hubo un intento de envío de una respuesta que falló",
			"Retry" : "Reintentar",
			"Unassigned" : "Sin asignar",
			"No pending tasks" : "No hay tareas pendientes",
			"::owner:: is doing job" : "::owner:: está haciendo el trabajo",
			"Job is finished" : "El trabajo ha terminado",
			"Job is aborted" : "El trabajo ha sido abortado",
			"Job is pending to be assigned to user" : "El trabajo está pendiente de ser asignado",
			"No pending tasks" : "No tiene tareas pendientes",
			"Tasks" : "Tareas",
			"News" : "Noticias",
			"Roles" : "Roles",
			"Trash" : "Papelera",
			"Fullname" : "Nombre completo",
			"Email" : "Dirección de correo",
			"Reason" : "Motivo",
			"Assign task ::title:: to user..." : "Asignar la tarea ::title:: al usuario...",
			"No roles" : "No hay roles",
			"Download" : "Descargar",
			"Class" : "Clase",
			"Select class" : "Indique la clase",
			"User" : "Usuario",
			"Type" : "Tipo",
			"All types" : "Todos los tipos",
			"Select type" : "Indique el tipo",
			"Start date" : "Fecha de inicio",
			"End date" : "Fecha de expiración",
			"Select class to add role" : "Indique una clase para añadir el role",
			"Select type to add role" : "Indique un tipo para añadir el role",
			"Begin date must be filled" : "Se debe indicar la fecha de comienzo",
			"Add role" : "Añadir role",
			"Add" : "Añadir",
			"Remove" : "Eliminar",
			"Select user to add role" : "Seleccione un usuario para añadir el role",
			"Select service partner to add role" : "Seleccione un proveedor de servicios para añadir el role",
			"Select feeder partner to add role" : "Seleccione un proveedor de fuente de datos para añadir el role",
			"Role ::role:: is already active for ::user::" : "Role ::role:: ya está en activo para el usuario ::user::",
			"No users" : "No hay usuarios",
			"No service partners available" : "No hay proveedores de servicios disponibles",
			"No feeder partners available" : "No hay proveedores de fuente de datos disponibles",
			"Name" : "Nombre",
			"Partner" : "Proveedor",
			"Class" : "Clase",
			"Role is expired since ::endDate::" : "El role ha expirado desde el ::endDate::",
			"Role is active since ::startDate:: and no expires" : "El role está activo desde el ::startDate:: y no expira",
			"Role is active since ::startDate:: and expires at ::endDate::" : "El role está activo desde el ::startDate:: y expira el ::endDate::",
			"Finish edition" : "Finalizar edición",
			"Edit" : "Editar",
			"Are you sure to revoke role?" : "¿Está seguro/a que desea revocar el role?",
			"Term" : "Término",
			"Terms" : "Términos",
			"Tags count" : "Número de marcadores",
			"Category" : "Categoría",
			"Selectable" : "Seleccionable",
			"Term" : "Término",
			"Code" : "Código",
			"Title" : "Título",
			"Label" : "Etiqueta",
			"Delete date" : "Fecha eliminado",
			"Contain other terms" : "Contiene otros términos",
			"Tags" : "Etiquetas",
			"No tags" : "No hay etiquetas",
			"Add to" : "Añadir a",
			"Add term" : "Añadir término",
			"Add tag" : "Añadir etiqueta",
			"Fill name and label" : "Rellene el nombre y la etiqueta",
			"Value" : "Valor",
			"Name cannot be empty" : "El nombre no puede quedar vacío",
			"Term already exists" : "Término en uso",
			"Term already exists, select other code" : "El término ya existe, indique otro código",
			"New terms added recently that are not published yet" : "Ha añadido recientemente nuevos términos pero no han sido publicados",
			"Delete" : "Borrar",
			"Enable" : "Habilitar",
			"Disable" : "Deshabilitar",
			"Publish" : "Publicar",
			"Publish all" : "Publicar todos",
			"Terms published" : "Los términos han sido publicados",
			"No element defined" : "No se ha creado el elemento",
			"Add element" : "Añadir elemento",
			"Select element type" : "Seleccione el tipo de elemento",
			"Download document" : "Descargar documento",
			"Download document to edit it in your computer." : "Descargue el documento para poder realizar la edición en su ordenador.",
			"Click next if you have already edit the document." : "Haga click en siguiente si ya ha editado el documento.",
			"Edit document" : "Editar documento",
			"Open the document and insert the changes that you want." : "Abra el documento e introduzca los cambios que desee.",
			"When you finish, indicate the location of the modified document to save the last version in the system." : "Cuando termine, indique la localización del documento modificado para guardar la última versión en el sistema.",
			"Document saved" : "Documento guardado",
			"New version of document received." : "Se ha recibido la nueva versión del documento.",
			"Click save to replace current version." : "Haga click en guardar para reemplazar la versión actual.",
			"Modify document" : "Modificar documento",
			"Save" : "Guardar",
			"Document saved successfully" : "El documento ha sido guardado correctamente",
			"Could not save new location" : "No se ha podido guardar la nueva ubicación",
			"No elements" : "No hay elementos",
			"Reset filters" : "Resetear filtros",
			"Filter" : "Filtrar",
			"Element" : "Elemento",
			"Restore element?" : "Recuperar elemento",
			"Are you sure you want to restore element from trash?" : "¿Está seguro/a que desea recuperar el elemento de la papelera?",
			"Are you sure you want to restore all elements?" : "¿Está seguro/a que desea recuperar todos los elementos de la papelera?",
			"Restore" : "Recuperar",
			"Empty trash" : "Vaciar papelera",
			"Are you sure you want to empty the trash?" : "¿Está seguro/a que desea vaciar la papelera?",
			"Are you sure you want to remove selection?" : "¿Está seguro/a que desea eliminar la selección?",
			"Are you sure you want to remove element?" : "¿Está seguro/a que desea eliminar el elemento?",
			"Task is assigned to %s" : "La tarea está asignada a %s",
			"Task is not assigned" : "La tarea no está asignada",
			"Business units" : "Unidades de negocio",
			"(current)" : "(actual)",
			"Operation executed" : "Operación ejecutada",
			"Column" : "Columna",
			"Select column" : "Seleccione una columna",
			"None" : "Ninguna",
			"Downloading data..." : "Descargando datos...",
			"Download finished" : "Descarga finalizada",
			"Condition" : "Condición",
			"Page" : "Página",
			"Filters" : "Filtros",
			"Unassigning task..." : "Desasignando tarea...",
			"Task unassigned" : "Tarea desasignada",
			"Assigning task..." : "Asignando tarea...",
			"Task asigned" : "Tarea asignada",
			"Setting up delegation..." : "Configurando delegación...",
			"Delegation setup" : "Delegación configurada",
			"Setting up job..." : "Configurando trabajo...",
			"Job setup" : "Trabajo configurado",
			"Resolving task..." : "Avanzando tarea...",
			"Task resolved" : "Tarea avanzada",
			"Restricted information" : "Información restringida",
			"active task" : "tarea activa",
			"active tasks" : "tareas activas",
			"pending task" : "tarea pendiente",
			"pending tasks" : "tareas pendientes",
			"You don't have permissions in this service" : "No tiene permisos en este servicio",
			"Open" : "Abrir",
			"No label" : "Sin etiqueta",
			"Service order" : "Solicitud",
			"Service response" : "Respuesta",
			"Info" : "Info",
			"Business model updated" : "Sistema",
			"Business model installed" : "Sistema",
			"User post" : "Post usuario",
			"No title" : "Sin título",
			"Created at" : "Creado el",
			"by" : "por"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;