/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.printers;

import edu.emory.mathcs.backport.java.util.Collections;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.printers.NodePrinter;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.itrules.FrameBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.SetDefinition;
import org.monet.metamodel.internal.DescriptorDefinition;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.library.LibraryDate;
import org.monet.space.kernel.model.BusinessUnit;
import org.monet.space.kernel.model.DataRequest;
import org.monet.space.kernel.model.Dictionary;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeDataRequest;
import org.monet.space.kernel.model.Reference;
import org.monet.space.kernel.model.ReferenceAttribute;
import org.monet.space.office.configuration.Configuration;
import org.monet.space.office.core.model.Language;

public class SetPrinter
extends NodePrinter {
    Map<String, Integer> columnDataSizes = new HashMap<String, Integer>();
    Map<String, Integer> columnPercentages = new HashMap<String, Integer>();
    private static final int WordLengthOffset = 10;

    public SetPrinter(UnitBox box, Node node, NodeDataRequest request, String format, List<String> columns) {
        super(box, node, request, format, columns);
        request.setCodeReference(this.index().getCode());
    }

    @Override
    protected FrameBuilder build(String language) {
        FrameBuilder result = super.baseFrame().add("node");
        SetDefinition definition = this.definition();
        IndexDefinition indexDefinition = this.index();
        result.add("orientation", (Object)(indexDefinition.getReference() != null && indexDefinition.getReference().getAttributePropertyList().size() > 5 ? "landscape" : "portrait"));
        result.add("label", (Object)definition.getLabelString());
        result.add("pageLabel", (Object)this.box.translatorService().translate("Page", language));
        result.add("content", (Object)this.contentFrame(language));
        return result;
    }

    private FrameBuilder contentFrame(String language) {
        SetDefinition definition = this.definition();
        FrameBuilder result = new FrameBuilder(new String[]{"content"});
        result.add("label", (Object)definition.getLabelString());
        result.add("date", (Object)LibraryDate.getDateAndTimeString((Date)new Date(), (String)language, (TimeZone)Language.getCurrentTimeZone(), (String)"text", (Boolean)true, (String)"/"));
        result.add("filters", (Object)this.filtersFrame(language));
        result.add("noElementsMessage", (Object)this.box.translatorService().translate("No elements", language));
        if (this.view().getShow().getIndex() == null) {
            result.add("empty");
            return result;
        }
        int count = LayerHelper.nodeLayer().requestNodeListItemsCount(this.node.getId(), this.request);
        if (count <= 0) {
            result.add("empty");
            return result;
        }
        FrameBuilder references = this.referencesFrame(count, language);
        this.calculateColumnPercentages(count, language);
        result.add("references", (Object)references);
        result.add("referencesCount", (Object)this.referencesCount(count));
        result.add("header", (Object)this.headerFrame(language));
        result.add("headerCount", (Object)this.index().getReference().getAttributePropertyList().size());
        return result;
    }

    private int referencesCount(int count) {
        return count > 0 ? (this.format.equalsIgnoreCase("xls") ? count + 4 : count) : 0;
    }

    private FrameBuilder filtersFrame(String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"filters"});
        String condition = this.request.getCondition();
        if (this.request.getGroupsBy().size() == 0 && (condition == null || condition.isEmpty())) {
            result.add("empty");
            return result;
        }
        result.add("filtersMessage", (Object)this.box.translatorService().translate("Filters", language));
        if (condition != null && !condition.isEmpty()) {
            result.add("filter", (Object)this.filterFrame(this.box.translatorService().translate("Condition", language), condition));
        }
        this.request.getGroupsBy().forEach(groupBy -> {
            AttributeProperty attributeDefinition = this.attributePropertyOf(groupBy.attribute(), language);
            String label = Language.getInstance().getModelResource(attributeDefinition.getLabel());
            List<String> values = this.filterValuesOfGroupBy((DataRequest.GroupBy)groupBy);
            result.add("filter", (Object)this.groupByFilterFrame((DataRequest.GroupBy)groupBy, label, values));
        });
        return result;
    }

    private FrameBuilder filterFrame(String label, String value) {
        return this.filterFrame(label, Collections.singletonList((Object)value));
    }

    private FrameBuilder groupByFilterFrame(DataRequest.GroupBy groupBy, String label, List<String> values) {
        return this.filterFrame(label, values).add(groupBy.operator().toString().toLowerCase());
    }

    private FrameBuilder filterFrame(String label, List<String> values) {
        FrameBuilder result = new FrameBuilder(new String[]{"filter"}).add("label", (Object)label);
        values.forEach(v -> result.add("value", v));
        return result;
    }

    private SetDefinition definition() {
        return (SetDefinition)this.node.getDefinition();
    }

    private IndexDefinition index() {
        return Dictionary.getInstance().getIndexDefinition(this.definition().getIndex().getValue());
    }

    private IndexDefinitionBase.IndexViewProperty indexView() {
        String value = this.view().getShow().getIndex().getWithView().getValue();
        return this.index().getView(value);
    }

    private SetDefinition.SetViewProperty view() {
        return (SetDefinition.SetViewProperty)this.definition().getNodeView(this.request.getCodeView());
    }

    private List<String> filterValuesOfGroupBy(DataRequest.GroupBy groupBy) {
        return groupBy.values().stream().map(v -> {
            if ((v = this.format(groupBy, v)) instanceof Date) {
                return LibraryDate.getDateAndTimeString((Date)((Date)v), (String)Language.getCurrent(), (TimeZone)BusinessUnit.getTimeZone(), (String)"text", (Boolean)false, (String)"/").trim();
            }
            return (String)v;
        }).collect(Collectors.toList());
    }

    private Object format(DataRequest.GroupBy groupBy, Object value) {
        if (!groupBy.attribute().equals("code")) {
            return value;
        }
        return Dictionary.getInstance().getDefinition((String)value).getLabelString();
    }

    private AttributeProperty attributePropertyOf(String attribute, String language) {
        AttributeProperty attributeDefinition = this.index().getAttribute(attribute);
        if (attributeDefinition != null) {
            return attributeDefinition;
        }
        attributeDefinition = new DescriptorDefinition().getAttribute(attribute);
        attributeDefinition.setLabel((Object)this.box.translatorService().translate("Code", language));
        return attributeDefinition;
    }

    private FrameBuilder headerFrame(String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"header"});
        result.add("reference", (Object)this.referenceFrame(language));
        return result;
    }

    private FrameBuilder referencesFrame(int count, String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"references"});
        this.request.setStartPos(Integer.valueOf(0));
        this.request.setLimit(Integer.valueOf(count));
        Collection nodes = LayerHelper.nodeLayer().requestNodeListItems(this.node.getId(), this.request).values();
        int pos = 0;
        for (Node node : nodes) {
            result.add("reference", (Object)this.referenceFrame(node, pos, language));
            ++pos;
        }
        return result;
    }

    private FrameBuilder referenceFrame(String language) {
        FrameBuilder result = new FrameBuilder(new String[]{"reference"});
        this.columns.forEach(column -> result.add("attribute", (Object)this.attributeFrame((String)column, language)));
        return result;
    }

    private FrameBuilder referenceFrame(Node node, int pos, String language) {
        IndexDefinition index = this.index();
        Reference reference = node.getReference(index.getCode());
        FrameBuilder result = new FrameBuilder(new String[]{"reference"});
        if (pos % 2 != 0) {
            result.add("odd", (Object)new FrameBuilder(new String[]{"odd"}));
        }
        this.columns.forEach(column -> result.add("attribute", (Object)this.attributeFrame(reference, (String)column, language)));
        return result;
    }

    private FrameBuilder attributeFrame(Reference reference, String column, String language) {
        FrameBuilder result = this.attributeFrame(column, language);
        AttributeProperty attributeProperty = this.attributePropertyOf(column, language);
        ReferenceAttribute attribute = reference.getAttribute(attributeProperty.getCode());
        String value = this.valueOf(attribute, attributeProperty);
        this.updateColumnDataSize(value, attributeProperty);
        result.add("value", (Object)(!value.isEmpty() ? value : "-"));
        return result;
    }

    private FrameBuilder attributeFrame(String column, String language) {
        AttributeProperty attributeProperty = this.attributePropertyOf(column, language);
        FrameBuilder result = new FrameBuilder(new String[]{"attribute", attributeProperty.getType().toString().toLowerCase()});
        result.add("label", (Object)Language.getInstance().getModelResource(attributeProperty.getLabel(), language));
        result.add("width", (Object)this.columnPercentages.getOrDefault(attributeProperty.getCode(), 0));
        return result;
    }

    private String valueOf(ReferenceAttribute<?> attribute, AttributeProperty attributeDeclaration) {
        Object value = attribute.getValueAsString();
        if (attributeDeclaration.getType() == AttributeProperty.TypeEnumeration.PICTURE) {
            value = Configuration.getInstance().getFmsServletUrl() + "?op=downloadimage&nid=" + this.node.getId() + "&f=" + ((String)value).replace(" ", "%20") + "&thumb=1&r=" + Math.random();
        }
        if (attributeDeclaration.getType() == AttributeProperty.TypeEnumeration.BOOLEAN) {
            value = ((String)value).toLowerCase().equals("true") ? "X" : "";
        }
        return ((String)value).replace("&", "&amp;");
    }

    private void updateColumnDataSize(String value, AttributeProperty attributeProperty) {
        int size = attributeProperty.getType() == AttributeProperty.TypeEnumeration.PICTURE ? 20 : this.columnDataSizes.getOrDefault(attributeProperty.getCode(), 0);
        this.columnDataSizes.put(attributeProperty.getCode(), Math.max(value.length(), size));
    }

    private void calculateColumnPercentages(int numRows, String language) {
        ArrayList<Ref> showList = this.mergeIndexShows();
        if (showList.size() == 0) {
            return;
        }
        int totalSize = this.getTotalSize();
        if (totalSize == 0) {
            return;
        }
        totalSize = this.fixColumnsWithShortOrLongData(totalSize, language);
        int maxColumnSize = this.maxColumnPercentageWith(this.columns.size());
        for (String column : this.columns) {
            AttributeProperty attributeDefinition = this.attributePropertyOf(column, language);
            String code = attributeDefinition.getCode();
            int wordLength = this.wordLength(Language.getInstance().getModelResource(attributeDefinition.getLabel()));
            int dataSize = this.columnDataSizes.getOrDefault(code, 0);
            if (dataSize > 0 && wordLength > dataSize) {
                dataSize = Math.min(wordLength, maxColumnSize);
            }
            int percentage = dataSize * 100 / totalSize;
            this.columnPercentages.put(code, percentage);
        }
    }

    protected ArrayList<Ref> mergeIndexShows() {
        ArrayList<Ref> showList = new ArrayList<Ref>();
        IndexDefinitionBase.IndexViewProperty.ShowProperty showProperty = this.indexView().getShow();
        if (showProperty.getTitle() != null) {
            showList.add(showProperty.getTitle());
        }
        if (showProperty.getPicture() != null) {
            showList.add(showProperty.getPicture());
        }
        showList.addAll(showProperty.getHighlight());
        showList.addAll(showProperty.getLine());
        showList.addAll(showProperty.getLineBelow());
        showList.addAll(showProperty.getFooter());
        return showList;
    }

    private int getTotalSize() {
        return this.columnDataSizes.values().stream().mapToInt(v -> v).sum();
    }

    private int fixColumnsWithShortOrLongData(int totalSize, String language) {
        totalSize = this.fixShortDataColumns(totalSize, language);
        totalSize = this.fixLongDataColumns(totalSize, language);
        return totalSize;
    }

    private int fixShortDataColumns(int totalSize, String language) {
        for (String column : this.columns) {
            AttributeProperty attributeDefinition = this.attributePropertyOf(column, language);
            String code = attributeDefinition.getCode();
            int wordLength = this.wordLength(Language.getInstance().getModelResource(attributeDefinition.getLabel())) + 10;
            int dataSize = this.columnDataSizes.getOrDefault(code, 0);
            if (dataSize <= 0 || wordLength <= dataSize) continue;
            this.columnDataSizes.put(code, wordLength);
            totalSize -= dataSize;
            dataSize = wordLength;
            totalSize += dataSize;
        }
        return totalSize;
    }

    private int fixLongDataColumns(int totalSize, String language) {
        int maxColumnSize = this.maxColumnPercentageWith(this.columns.size());
        for (String column : this.columns) {
            AttributeProperty attributeDefinition = this.attributePropertyOf(column, language);
            String code = attributeDefinition.getCode();
            int dataSize = this.columnDataSizes.getOrDefault(code, 0);
            if (dataSize * 100 / totalSize <= maxColumnSize) continue;
            int newSize = Math.abs(totalSize * maxColumnSize / 100);
            this.columnDataSizes.put(code, newSize);
            totalSize -= dataSize;
            dataSize = newSize;
            totalSize += dataSize;
        }
        return totalSize;
    }

    int wordLength(String label) {
        if (label == null) {
            return 0;
        }
        String[] labelArray = label.split(" ");
        int result = 0;
        for (int i = 0; i < labelArray.length; ++i) {
            if (labelArray[i].length() <= result) continue;
            result = labelArray[i].length();
        }
        return result + 10;
    }

    protected int maxColumnPercentageWith(int countColumns) {
        return 100 / countColumns;
    }
}

