/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.model.datasource.filters.GroupFilter;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskFolderGrouping;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskNatureGrouping;
import io.intino.goros.unit.box.ui.datasources.model.task.TaskUrgentGrouping;
import io.intino.goros.unit.util.AccountHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.TaskHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monet.space.kernel.model.Account;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.TaskSearchRequest;

public class TaskListDatasource
extends PageDatasource<Task> {
    private final UnitBox box;
    private final UISession session;
    private final Account account;
    private final Inbox inbox;
    public static final String FolderGrouping = "folder";
    public static final String UrgentGrouping = "urgent";
    public static final String NatureGrouping = "nature";

    public TaskListDatasource(UnitBox box, UISession session, Inbox inbox) {
        this.box = box;
        this.session = session;
        this.account = AccountHelper.account(session);
        this.inbox = inbox;
    }

    public List<Task> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        TaskSearchRequest request = this.request(condition, filters, sortings);
        request.setStartPos(Integer.valueOf(start));
        request.setLimit(Integer.valueOf(count));
        this.box.linkSession(this.session);
        return new ArrayList<Task>(LayerHelper.taskLayer().searchTasks(this.account, request).get().values());
    }

    public long itemCount(String condition, List<Filter> filters) {
        this.box.linkSession(this.session);
        return LayerHelper.taskLayer().searchTasksCount(this.account, this.request(condition, filters, Collections.emptyList()));
    }

    public List<Group> groups(String key) {
        if (key.equalsIgnoreCase(FolderGrouping)) {
            return Arrays.stream(TaskFolderGrouping.values()).map(f -> new Group().label(f.title())).collect(Collectors.toList());
        }
        if (key.equalsIgnoreCase(UrgentGrouping)) {
            return Arrays.stream(TaskUrgentGrouping.values()).map(f -> new Group().label(f.title())).collect(Collectors.toList());
        }
        if (key.equalsIgnoreCase(NatureGrouping)) {
            return Arrays.stream(TaskNatureGrouping.values()).map(f -> new Group().label(f.title())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static long itemCount(Account account, Inbox inbox) {
        return LayerHelper.taskLayer().searchTasksCount(account, TaskListDatasource.request(inbox));
    }

    private TaskSearchRequest request(String condition, List<Filter> filters, List<String> sortings) {
        TaskSearchRequest request = TaskListDatasource.request(this.inbox);
        request.setCondition(condition);
        this.addParameter(request, filters, FolderGrouping, "situation", value -> TaskFolderGrouping.from(value).name().toLowerCase());
        this.addParameter(request, filters, UrgentGrouping, UrgentGrouping, value -> "" + TaskUrgentGrouping.Urgent.value());
        this.addParameter(request, filters, NatureGrouping, "background", value -> "" + TaskNatureGrouping.from(value).value());
        if (request.getParameter("situation") == null) {
            request.addParameter("situation", TaskFolderGrouping.Active.name().toLowerCase());
        }
        if (sortings.size() <= 0) {
            sortings = Collections.singletonList("update_date#DESC");
        }
        request.setSortsBy(TaskHelper.sortsByOf(sortings));
        return request;
    }

    private void addParameter(TaskSearchRequest request, List<Filter> filters, String name, String parameter, Function<String, String> value) {
        GroupFilter filter = filters.stream().filter(f -> f.grouping().equals(name)).findFirst().orElse(null);
        if (filter == null || filter.groups().size() <= 0) {
            return;
        }
        request.addParameter(parameter, value.apply((String)new ArrayList(filter.groups()).get(0)));
    }

    private static TaskSearchRequest request(Inbox inbox) {
        TaskSearchRequest request = new TaskSearchRequest();
        request.addParameter("box", inbox.name().toLowerCase());
        return request;
    }

    public static enum Inbox {
        TaskTray,
        TaskBoard;


        public String value(String language) {
            if (language.equalsIgnoreCase("es")) {
                return this == TaskTray ? "mistareas" : "tareas";
            }
            return this == TaskTray ? "mytasks" : "tasks";
        }

        public static Inbox from(String key) {
            return key.equalsIgnoreCase("mistareas") || key.equalsIgnoreCase("mytasks") ? TaskTray : TaskBoard;
        }
    }
}

