import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import DisplaysNodeDocumentTemplate from "unit-elements/gen/displays/templates/NodeDocumentTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TaskHistoryEntryLinkTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TaskHistoryEntryLinkTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TaskHistoryEntryLinkTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TaskHistoryEntryLinkTemplateNotifier(this);
		this.requester = new TaskHistoryEntryLinkTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1355316771" title="" target="blank" mode="Link" size="Medium" visible={false}>
				</UiOpenSite>
				<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1678410974" title="" target="self" mode="Link" size="Medium" visible={false}>
				</UiOpenDialog>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2110794028" title="Document" fullscreen={true}>
					<DisplaysNodeDocumentTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2110794028.a_693044843">
					</DisplaysNodeDocumentTemplate>
				</UiDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TaskHistoryEntryLinkTemplate));
DisplayFactory.register("TaskHistoryEntryLinkTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TaskHistoryEntryLinkTemplate)));