/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.util;

import io.intino.alexandria.ui.displays.components.SelectorCollectionBox;
import io.intino.alexandria.ui.displays.components.SelectorComboBox;
import io.intino.alexandria.ui.displays.components.SelectorTabs;
import io.intino.alexandria.ui.displays.components.SelectorToggleBox;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.DictionaryHelper;
import io.intino.goros.unit.util.LayerHelper;
import io.intino.goros.unit.util.StringHelper;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.monet.metamodel.ActivityDefinition;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.PlaceActionProperty;
import org.monet.metamodel.ProcessDefinitionBase;
import org.monet.metamodel.ServiceDefinition;
import org.monet.metamodel.ViewProperty;
import org.monet.space.kernel.agents.AgentSession;
import org.monet.space.kernel.model.Context;
import org.monet.space.kernel.model.Language;
import org.monet.space.kernel.model.Node;
import org.monet.space.kernel.model.NodeItem;
import org.monet.space.kernel.model.Session;
import org.monet.space.kernel.model.Task;

public class DisplayHelper {
    public static void initAgentSession(UISession uiSession) {
        String sessionId = uiSession.id();
        AgentSession agentSession = AgentSession.getInstance();
        Session session = agentSession.get(sessionId);
        if (session != null) {
            return;
        }
        agentSession.add(sessionId);
        agentSession.get(sessionId).setAccount(LayerHelper.federationLayer(uiSession).loadAccount("1"));
    }

    public static void initContext(UnitBox box, UISession session, long thread) {
        Context context = Context.getInstance();
        context.setApplication(Long.valueOf(thread), "127.0.0.1", "office", "user");
        context.setUserServerConfig(Long.valueOf(thread), "localhost", "", Integer.valueOf(box.configuration().port()));
        context.setSessionId(Long.valueOf(thread), session.id());
        context.setDatabaseConnectionType(Long.valueOf(thread), "auto");
    }

    public static void executeDelayed(Consumer<Boolean> consumer) {
        DisplayHelper.executeDelayed(consumer, 1000L);
    }

    public static void executeDelayed(final Consumer<Boolean> consumer, long delay) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                consumer.accept(true);
            }
        }, delay);
    }

    public static void selectDefaultView(SelectorComboBox<?, ?> selector, Node node) {
        String name = DisplayHelper.defaultViewName(node);
        if (name == null) {
            return;
        }
        selector.select(new String[]{name});
    }

    public static void selectDefaultView(SelectorTabs<?, ?> selector, Node node) {
        String name = DisplayHelper.defaultViewName(node);
        if (name == null) {
            return;
        }
        selector.select(name);
    }

    public static void selectDefaultView(SelectorToggleBox selector, Node node) {
        String name = DisplayHelper.defaultViewName(node);
        if (name == null) {
            return;
        }
        selector.select(new String[]{name});
    }

    public static void selectDefaultView(SelectorComboBox<?, ?> selector, Task task) {
        String name = DisplayHelper.defaultViewName(task);
        if (name == null) {
            return;
        }
        selector.select(new String[]{name});
    }

    public static void selectDefaultView(SelectorTabs<?, ?> selector, Task task) {
        String name = DisplayHelper.defaultViewName(task);
        if (name == null) {
            return;
        }
        selector.select(name);
    }

    public static NodeViewProperty defaultView(Node node) {
        NodeViewProperty defaultView = node.getDefinition().getDefaultView();
        List viewList = node.getDefinition().getViewDefinitionList();
        return defaultView != null ? defaultView : (viewList.size() > 0 ? (NodeViewProperty)viewList.get(0) : null);
    }

    public static String defaultViewName(Node node) {
        NodeViewProperty defaultView = DisplayHelper.defaultView(node);
        if (defaultView == null) {
            return null;
        }
        return DisplayHelper.viewNameOf((ViewProperty)defaultView, defaultView.getLabel());
    }

    public static String defaultViewCode(Node node) {
        NodeViewProperty defaultView = DisplayHelper.defaultView(node);
        if (defaultView == null) {
            return null;
        }
        return defaultView.getCode();
    }

    public static ProcessDefinitionBase.ViewProperty defaultView(Task task) {
        if (task.getDefinition().isActivity()) {
            return ((ActivityDefinition)task.getDefinition()).getDefaultView();
        }
        if (task.getDefinition().isService()) {
            return ((ServiceDefinition)task.getDefinition()).getDefaultView();
        }
        return null;
    }

    public static String defaultViewName(Task task) {
        ProcessDefinitionBase.ViewProperty defaultView = DisplayHelper.defaultView(task);
        if (defaultView == null) {
            return "state";
        }
        return DisplayHelper.viewNameOf((ViewProperty)defaultView, defaultView.getLabel());
    }

    private static String viewNameOf(ViewProperty defaultView, Object label) {
        String name = defaultView.getName() != null && !defaultView.getName().isEmpty() ? defaultView.getName() : Language.getInstance().getModelResource(label);
        return name == null || name.isEmpty() ? null : StringHelper.validName(name);
    }

    public static NodeViewProperty defaultEmbeddedView(Node node) {
        NodeDefinition definition = node.getDefinition();
        NodeViewProperty defaultView = definition.getDefaultView();
        if (defaultView == null) {
            return null;
        }
        if (defaultView.isVisibleWhenEmbedded()) {
            return defaultView;
        }
        return definition.getViewDefinitionList().stream().filter(NodeViewProperty::isVisibleWhenEmbedded).findFirst().orElse(defaultView);
    }

    public static void selectNotSystemView(SelectorTabs selector, Node node) {
        NodeViewProperty view = node.getDefinition().getDefaultView();
        if (view != null && !DictionaryHelper.isSystemView(view)) {
            selector.select(Language.getInstance().getModelResource(view.getLabel()));
            return;
        }
        view = node.getDefinition().getViewDefinitionList().stream().filter(v -> !DictionaryHelper.isSystemView(v)).findFirst().orElse(null);
        if (view == null) {
            selector.select(0);
        } else {
            selector.select(StringHelper.validName(Language.getInstance().getModelResource(view.getLabel())));
        }
    }

    public static String requireConfirmationMessage(PlaceActionProperty property) {
        PlaceActionProperty.RequireConfirmationProperty requireConfirmation = property.getRequireConfirmation();
        if (requireConfirmation == null) {
            return null;
        }
        return requireConfirmation.getMessage() != null ? Language.getInstance().getModelResource(requireConfirmation.getMessage()) : "Are you sure you want continue with task?";
    }

    public static SelectorCollectionBox.ValueProvider linkValueProvider() {
        return nodeItem -> ((NodeItem)nodeItem).getAttribute("value");
    }

    public static String translation(Object label) {
        return Language.getInstance().getModelResource(label);
    }
}

