/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.pages;

import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.goros.unit.box.I18n;
import io.intino.goros.unit.box.ui.displays.templates.GorosAppTemplate;
import io.intino.goros.unit.box.ui.pages.AbstractBannerPage;
import io.intino.goros.unit.util.Formatters;
import java.io.IOException;
import java.io.InputStream;
import org.monet.space.kernel.components.ComponentFederation;
import org.monet.space.kernel.model.Banner;
import spark.utils.IOUtils;

public class BannerPage
extends AbstractBannerPage {
    private static final String NoInfo = "<html><head><link type=\"text/css\" rel=\"stylesheet\" href=\"https://fonts.googleapis.com/css?family=Roboto:300\"></head><body><div>No information available</div></body></html>";

    @Override
    public String execute() {
        try {
            String content = IOUtils.toString((InputStream)BannerPage.class.getResourceAsStream("/banner.tpl"));
            return this.replaceMarks(content);
        }
        catch (IOException e) {
            return NoInfo;
        }
    }

    private String replaceMarks(String content) {
        Banner banner = ComponentFederation.getInstance().getDefaultLayer().loadBanner();
        String language = this.session.discoverLanguage();
        String activeTasksMessage = Formatters.countMessage(banner.getCountActiveTasks(), I18n.translate("active task", language), I18n.translate("active tasks", language));
        String pendingTasksMessage = Formatters.countMessage(banner.getCountAliveTasks(), I18n.translate("pending task", language), I18n.translate("pending tasks", language));
        String noPermissionsMessage = I18n.translate("Restricted information", language);
        content = content.replace("::title::", banner.getTitle());
        content = content.replace("::activeTasksMessage::", activeTasksMessage);
        content = content.replace("::pendingTasksMessage::", pendingTasksMessage);
        content = content.replace("::noPermissionsMessage::", noPermissionsMessage);
        content = content.replace("::hasPermissions::", String.valueOf(banner.hasPermissions()));
        content = content.replace("::noHasPermissions::", String.valueOf(!banner.hasPermissions()));
        return content;
    }

    public Soul prepareSoul(UIClient client) {
        return new Soul(this.session){

            public void personify() {
                GorosAppTemplate component = new GorosAppTemplate(BannerPage.this.box);
                this.register((Display)component);
                component.init();
            }
        };
    }
}

