/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.Display;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.DisplayProvider;
import io.intino.goros.unit.box.ui.displays.templates.AbstractTaskStateViewTemplate;
import io.intino.goros.unit.util.TaskHelper;
import org.monet.metamodel.DelegationActionProperty;
import org.monet.metamodel.EditionActionProperty;
import org.monet.metamodel.EnrollActionProperty;
import org.monet.metamodel.LineActionProperty;
import org.monet.metamodel.PlaceProperty;
import org.monet.metamodel.SendJobActionProperty;
import org.monet.metamodel.SendRequestActionProperty;
import org.monet.metamodel.SendResponseActionProperty;
import org.monet.metamodel.WaitActionProperty;
import org.monet.space.kernel.machines.ttm.behavior.ProcessBehavior;
import org.monet.space.kernel.model.Task;
import org.monet.space.kernel.model.User;

public class TaskStateViewTemplate
extends AbstractTaskStateViewTemplate<UnitBox> {
    private Task task;
    private DisplayProvider displayProvider;

    public TaskStateViewTemplate(UnitBox box) {
        super(box);
    }

    public TaskStateViewTemplate task(Task task) {
        this.task = task;
        return this;
    }

    public TaskStateViewTemplate displayProvider(DisplayProvider provider) {
        this.displayProvider = provider;
        return this;
    }

    @Override
    public void init() {
        super.init();
        ((UnitBox)this.box()).notifier().onTaskStateChange((Display)this, this::update);
    }

    public void remove() {
        super.remove();
        ((UnitBox)this.box()).notifier().unTaskStateChange((Display)this);
    }

    public void refresh() {
        super.refresh();
        this.date.value(this.task.getInternalUpdateDate().toInstant());
        this.refreshAssignMessage();
        this.refreshState();
        this.refreshStateDueView();
        this.refreshProcessView();
        this.refreshJobView();
        this.refreshHistoryView();
    }

    private void refreshAssignMessage() {
        User owner = this.task.getOwner();
        this.assignMessage.value(owner != null ? String.format(this.translate("Task is assigned to %s"), owner.getInfo().getFullname()) : this.translate("Task is not assigned"));
    }

    private void refreshState() {
        this.state.value(this.translate(TaskHelper.state(this.task)));
        this.state.backgroundColor(TaskHelper.stateColor(this.task));
    }

    private void refreshStateDueView() {
        boolean dueState = this.task.isFinished() || this.task.isAborted() || this.task.isExpired();
        this.stateDueView.visible(dueState);
        this.stateDueView.onShow(e -> this.stateDueView.stateDueMessage.value(this.translate("Task is") + " " + this.translate(TaskHelper.state(this.task)).toLowerCase()));
    }

    private void refreshProcessView() {
        this.processView.visible(this.isProcess());
        if (!this.isProcess()) {
            return;
        }
        this.refreshPlaceView();
    }

    private void refreshJobView() {
        this.jobView.visible(this.task.isJob());
        this.jobMessage.value(this.jobMessageFor(this.task));
    }

    private void refreshPlaceView() {
        ProcessBehavior process = this.task.getProcess();
        PlaceProperty property = process.getCurrentPlace();
        this.refreshDelegationView(property);
        this.refreshSendJobView(property);
        this.refreshLineView(property);
        this.refreshEditionView(property);
        this.refreshEnrollView(property);
        this.refreshWaitView(property);
        this.refreshSendRequestView(property);
        this.refreshSendResponseView(property);
    }

    private void refreshHistoryView() {
        this.historyViewStamp.task(this.task);
        this.historyViewStamp.refresh();
    }

    private void refreshDelegationView(PlaceProperty property) {
        DelegationActionProperty action = property.getDelegationActionProperty();
        this.delegationView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.delegationView.delegationViewStamp.task(this.task);
        this.delegationView.delegationViewStamp.property(action);
        this.delegationView.delegationViewStamp.displayProvider(this.displayProvider);
        this.delegationView.delegationViewStamp.refresh();
    }

    private void refreshSendJobView(PlaceProperty property) {
        SendJobActionProperty action = property.getSendJobActionProperty();
        this.sendJobView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.sendJobView.sendJobViewStamp.task(this.task);
        this.sendJobView.sendJobViewStamp.property(action);
        this.sendJobView.sendJobViewStamp.displayProvider(this.displayProvider);
        this.sendJobView.sendJobViewStamp.refresh();
    }

    private void refreshLineView(PlaceProperty property) {
        LineActionProperty action = property.getLineActionProperty();
        this.lineView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.lineView.lineViewStamp.task(this.task);
        this.lineView.lineViewStamp.property(action);
        this.lineView.lineViewStamp.onResume(e -> this.refresh());
        this.lineView.lineViewStamp.refresh();
    }

    private void refreshEditionView(PlaceProperty property) {
        EditionActionProperty action = property.getEditionActionProperty();
        this.editionView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.editionView.editionViewStamp.task(this.task);
        this.editionView.editionViewStamp.property(action);
        this.editionView.editionViewStamp.displayProvider(this.displayProvider);
        this.editionView.editionViewStamp.refresh();
    }

    private void refreshEnrollView(PlaceProperty property) {
        EnrollActionProperty action = property.getEnrollActionProperty();
        this.enrollView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.enrollView.enrollViewStamp.task(this.task);
        this.enrollView.enrollViewStamp.property(action);
        this.enrollView.enrollViewStamp.refresh();
    }

    private void refreshWaitView(PlaceProperty property) {
        WaitActionProperty action = property.getWaitActionProperty();
        this.waitView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.waitView.waitViewStamp.task(this.task);
        this.waitView.waitViewStamp.property(action);
        this.waitView.waitViewStamp.refresh();
    }

    private void refreshSendRequestView(PlaceProperty property) {
        SendRequestActionProperty action = property.getSendRequestActionProperty();
        this.sendRequestView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.sendRequestView.sendRequestViewStamp.task(this.task);
        this.sendRequestView.sendRequestViewStamp.property(action);
        this.sendRequestView.sendRequestViewStamp.refresh();
    }

    private void refreshSendResponseView(PlaceProperty property) {
        SendResponseActionProperty action = property.getSendResponseActionProperty();
        this.sendResponseView.visible(action != null && TaskHelper.isAlive(this.task));
        if (action == null) {
            return;
        }
        this.sendResponseView.sendResponseViewStamp.task(this.task);
        this.sendResponseView.sendResponseViewStamp.property(action);
        this.sendResponseView.sendResponseViewStamp.refresh();
    }

    private void update(Task task) {
        if (this.task == null || !this.task.getId().equals(task.getId())) {
            return;
        }
        this.task(task);
        this.refresh();
    }

    private String jobMessageFor(Task task) {
        if (task.isFinished()) {
            return this.translate("Job is finished");
        }
        if (task.isAborted()) {
            return this.translate("Job is aborted");
        }
        if (task.getOwner() != null) {
            return this.translate("::owner:: is doing job").replace("::owner::", task.getOwner().getInfo().getFullname());
        }
        return this.translate("Job is pending to be assigned to user");
    }

    private boolean isProcess() {
        return this.task.isService() || this.task.isActivity();
    }
}

