/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.displays.templates;

import io.intino.alexandria.ui.displays.UserMessage;
import io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.box.ui.displays.templates.AbstractSourceTermDialog;
import io.intino.goros.unit.box.ui.displays.templates.SourceTermTagTemplate;
import io.intino.goros.unit.util.LayerHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.monet.metamodel.SourceDefinition;
import org.monet.space.kernel.model.Source;
import org.monet.space.kernel.model.Term;

public class SourceTermDialog
extends AbstractSourceTermDialog<UnitBox> {
    private Source<SourceDefinition> source;
    private Term term;
    private Consumer<Term> termAddedListener;
    private Consumer<Term> termModifiedListener;
    private Consumer<Term> termDeletedListener;
    private boolean refreshing = false;

    public SourceTermDialog(UnitBox box) {
        super(box);
    }

    public SourceTermDialog source(Source<SourceDefinition> source) {
        this.source = source;
        return this;
    }

    public Term term() {
        return this.term;
    }

    public SourceTermDialog term(Term term) {
        this.term = term;
        return this;
    }

    public SourceTermDialog onTermAdded(Consumer<Term> listener) {
        this.termAddedListener = listener;
        return this;
    }

    public SourceTermDialog onTermModified(Consumer<Term> listener) {
        this.termModifiedListener = listener;
        return this;
    }

    public SourceTermDialog onTermDeleted(Consumer<Term> listener) {
        this.termDeletedListener = listener;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.add.onExecute(e -> this.addChild());
        this.childLabel.onEnterPress(e -> this.addChild());
        this.label.onChange(e -> this.save(t -> {
            if (this.term.getLabel().equals(e.value())) {
                return false;
            }
            this.term.setLabel((String)e.value());
            return true;
        }));
        this.type.onSelect(e -> this.save(t -> this.updateType()));
        this.containOtherTerms.onToggle(e -> this.save(t -> this.updateType()));
        this.childCode.onChange(e -> this.checkChildCode());
        this.initToolbar();
    }

    public void refresh() {
        super.refresh();
        this.refreshGeneralView();
        this.refreshChildrenView();
    }

    private void initToolbar() {
        this.enable.onExecute(e -> this.enable());
        this.disable.onExecute(e -> this.disable());
        this.delete.onExecute(e -> this.delete());
    }

    private void refreshGeneralView() {
        this.refreshing = true;
        this.title.visible(this.term != null);
        this.generalView.visible(this.term != null);
        if (this.term == null) {
            return;
        }
        this.title.value(this.term.getLabel());
        this.code.value(this.term.getCode());
        this.label.value(this.term.getLabel());
        this.type.selection(new String[]{this.term.isTerm() || this.term.isSuperTerm() ? "termType" : "categoryType"});
        this.containOtherTerms.state(this.term.isSuperTerm() ? ToggleEvent.State.On : ToggleEvent.State.Off);
        this.refreshTags();
        this.refreshToolbar();
        this.refreshing = false;
    }

    private void refreshTags() {
        this.tags.clear();
        this.term.getTagsMap().forEach((name, value) -> this.fill((String)name, (String)value, (SourceTermTagTemplate)this.tags.add()));
        this.fill("", "", (SourceTermTagTemplate)this.tags.add());
    }

    private void refreshToolbar() {
        this.enableBlock.visible(!this.term.isEnabled() && !this.term.isNew());
        this.disableBlock.visible(this.term.isEnabled() && !this.term.isNew());
        this.deleteBlock.visible(this.term.isNew());
    }

    private void refreshChildrenView() {
        this.addTitle.visible(this.term == null || this.term.isSuperTerm() || this.term.isCategory());
        this.childrenView.visible(this.term == null || this.term.isSuperTerm() || this.term.isCategory());
        String title = this.term != null ? this.translate("Add to") + " " + this.term.getLabel() : this.translate("Add term");
        this.addTitle.value(title);
    }

    private void addChild() {
        if (!this.checkChild()) {
            return;
        }
        Term child = new Term();
        child.setCode(this.childCode());
        child.setLabel(this.childLabel.value());
        child.setType(0);
        child.setEnabled(true);
        child.setNew(true);
        LayerHelper.sourceLayer().addSourceTerm(this.source, child, this.term != null ? this.term.getCode() : null);
        this.termAddedListener.accept(child);
    }

    private boolean checkChild() {
        if (this.childCode.value() == null || this.childCode.value().isEmpty() || this.childLabel.value() == null || this.childLabel.value().isEmpty()) {
            this.notifyUser(this.translate("Fill name and label"), UserMessage.Type.Warning);
            return false;
        }
        if (!this.checkChildCode()) {
            this.notifyUser(this.translate("Term already exists, select other code"), UserMessage.Type.Error);
            return false;
        }
        return true;
    }

    private void fill(String name, String value, SourceTermTagTemplate view) {
        view.name(name);
        view.value(value);
        view.onChange((n, v) -> this.save(t -> {
            Map tags = this.term.getTagsMap();
            boolean contains = tags.containsKey(n);
            tags.put(n, v);
            this.term.setTags(tags);
            if (!contains && !n.isEmpty()) {
                this.refreshTags();
            }
            return true;
        }));
        view.onDelete((n, v) -> this.save(t -> {
            Map tags = this.term.getTagsMap();
            tags.remove(n);
            this.term.setTags(tags);
            this.refreshTags();
            return true;
        }));
        view.refresh();
    }

    private boolean updateType() {
        int type = this.termType();
        if (type == -1 || type == this.term.getType()) {
            return false;
        }
        this.term.setType(type);
        this.refreshChildrenView();
        return true;
    }

    private int termType() {
        List selection = this.type.selection();
        if (selection.size() <= 0) {
            return -1;
        }
        String value = (String)selection.get(0);
        if (value.equalsIgnoreCase("TermType")) {
            boolean superTerm = this.containOtherTerms.state() == ToggleEvent.State.On;
            return superTerm ? 1 : 0;
        }
        return 2;
    }

    private void enable() {
        this.saveEnabled(true);
        this.refresh();
    }

    private void disable() {
        this.saveEnabled(false);
        this.refresh();
    }

    private void delete() {
        LayerHelper.sourceLayer().deleteSourceTerm(this.source, this.term.getCode());
        this.notifyUser(this.translate("Term deleted"), UserMessage.Type.Success);
        this.termDeletedListener.accept(this.term);
    }

    private void saveEnabled(boolean value) {
        this.save(t -> {
            this.term.setEnabled(value);
            return true;
        });
    }

    private void save(Function<Term, Boolean> consumer) {
        Boolean modified = consumer.apply(this.term);
        if (!modified.booleanValue()) {
            return;
        }
        LayerHelper.sourceLayer().updateSourceTerm(this.source, this.term);
        this.termModifiedListener.accept(this.term);
    }

    private boolean checkChildCode() {
        boolean exists = LayerHelper.sourceLayer().existsSourceTerm(this.source, this.childCode());
        this.childCode.error(exists ? this.translate("Term already exists") : null);
        return !exists;
    }

    private String childCode() {
        return (String)(this.term != null ? this.term.getCode() + "." : "") + this.childCode.value();
    }
}

