/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.unit.box.ui.datasources;

import io.intino.alexandria.ui.model.datasource.Filter;
import io.intino.alexandria.ui.model.datasource.Group;
import io.intino.alexandria.ui.model.datasource.PageDatasource;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.goros.unit.box.UnitBox;
import io.intino.goros.unit.util.LayerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.monet.metamodel.RoleDefinition;
import org.monet.space.kernel.model.FederationUnitFeeder;

public class FederationUnitFeederListDatasource
extends PageDatasource<FederationUnitFeeder> {
    private final UnitBox box;
    private final UISession session;
    private final RoleDefinition roleDefinition;

    public FederationUnitFeederListDatasource(UnitBox box, UISession session, RoleDefinition roleDefinition) {
        this.box = box;
        this.session = session;
        this.roleDefinition = roleDefinition;
    }

    public List<FederationUnitFeeder> items(int start, int count, String condition, List<Filter> filters, List<String> sortings) {
        ArrayList<FederationUnitFeeder> result = new ArrayList<FederationUnitFeeder>(FederationUnitFeederListDatasource.federationUnitsFeeders(this.box, this.session, this.roleDefinition));
        int from = Math.min(start, result.size());
        int end = Math.min(start + count, result.size());
        return result.subList(from, end);
    }

    public long itemCount(String condition, List<Filter> filters) {
        return FederationUnitFeederListDatasource.federationUnitsFeeders(this.box, this.session, this.roleDefinition).size();
    }

    public List<Group> groups(String key) {
        return Collections.emptyList();
    }

    private static List<FederationUnitFeeder> federationUnitsFeeders(UnitBox box, UISession session, RoleDefinition definition) {
        if (definition == null) {
            return Collections.emptyList();
        }
        box.linkSession(session);
        ArrayList federationUnitList = new ArrayList(LayerHelper.federationLayer(session).loadPartners().get().values());
        return federationUnitList.stream().map(fu -> fu.getFeederList().get().values()).flatMap(Collection::stream).filter(feeder -> FederationUnitFeederListDatasource.conforms(feeder, definition)).collect(Collectors.toList());
    }

    private static boolean conforms(FederationUnitFeeder feeder, RoleDefinition definition) {
        return FederationUnitFeederListDatasource.ontologies(definition).contains(feeder.getOntology());
    }

    private static List<String> ontologies(RoleDefinition definition) {
        if (definition.getEnableFeeders() != null) {
            return definition.getEnableFeeders().getOntology();
        }
        return Collections.emptyList();
    }
}

