import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import NewsListItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import NewsListItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NewsListItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new NewsListItemNotifier(this);
		this.requester = new NewsListItemRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982" format="catalogIndexReferenceStyle" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982.a1261801014" format="body2" backgroundColor="#001E3C" mode="uppercase" highlighted={{text:"white",background:"#001E3C"}}>
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982.a460653276" visible={false} mode="normal">
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982.a_2124130058" title="" target="self" mode="Link" size="Medium" visible={false}>
					</UiAction>
					<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982.a1261301418" format="body2 grey" pattern="DD/MM/YYYY HH:mm:ss">
					</UiDate>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1305754982.a1261254814" format="airTop" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NewsListItem));
DisplayFactory.register("NewsListItem", withStyles(styles, { withTheme: true })(withSnackbar(NewsListItem)));