import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiOpenDialog from "alexandria-ui-elements/src/displays/components/OpenDialog";
import UiDialog from "alexandria-ui-elements/src/displays/components/Dialog";
import UiSearchBox from "alexandria-ui-elements/src/displays/components/SearchBox";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiCloseDialog from "alexandria-ui-elements/src/displays/components/CloseDialog";
import DisplaysAssignTaskDialogTableRow from "unit-elements/gen/displays/rows/AssignTaskDialogTableRow";
import DisplaysAssignTaskDialogTableFullnameItem from "unit-elements/gen/displays/items/AssignTaskDialogTableFullnameItem";
import DisplaysAssignTaskDialogTableEmailItem from "unit-elements/gen/displays/items/AssignTaskDialogTableEmailItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TaskToolbarTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TaskToolbarTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TaskToolbarTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TaskToolbarTemplateNotifier(this);
		this.requester = new TaskToolbarTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129" layout="vertical centerjustified flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129.a_1700614773" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129.a_1700614773.a1701904566" title="Actualizar" target="self" mode="Button" size="Small" format="airRight" highlighted="Outline">
						</UiAction>
						<UiOpenDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129.a_1700614773.a1132546268" title="Asignar..." target="self" mode="Button" size="Small" format="airRight" highlighted="Outline" visible={false}>
						</UiOpenDialog>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129.a_1700614773.a682288533" title="Desasignar" target="self" mode="Button" affirmed="Are you sure to unassign task?" size="Small" format="airRight" highlighted="Outline" visible={false}>
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_641858129.a_1700614773.a_1072354909" title="Abortar" target="self" mode="Button" affirmed="Are you sure to abort task?" size="Small" highlighted="Outline" visible={false}>
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738" title="Asignar..." width="80.0%" height="80.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852" layout="vertical flexible" width="100.0%" height="calc(100% - 50px)">
						<UiSearchBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a1417700501" showCountMessage="true">
						</UiSearchBox>
						<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441" format="bordered" noItemsMessage="No hay usuarios" pageSize={20} itemHeight={30} scrollingMark={false} selection="single">
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_1418817057" style={{width:"16%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_1418817057.a1249062106" mode="normal" translate={true} value="Fullname">
								</UiText>
							</UiHeading>
							<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_133987481" style={{width:"16%",paddingRight:"10px"}} hidden="Never">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1464013441.a_133987481.a1767547333" mode="normal" translate={true} value="Email">
								</UiText>
							</UiHeading>
						</UiTable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2052236852.a_1485711337" label="Reason" format="doubleAirBottom doubleAirTop greyBackground" mode="normal" editionMode="Raw" rows={5}>
						</UiTextEditable>
					</UiBlock>
					<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a_2097408964">
					</UiDivider>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a1641800922" layout="horizontal endjustified">
						<UiCloseDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a1641800922.a_886103064" title="Cancel" target="self" mode="Button" size="Medium" format="airRight">
						</UiCloseDialog>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1536110738.a1641800922.a_941839754" title="OK" target="self" mode="Button" readonly={true} size="Medium" highlighted="Fill">
						</UiAction>
					</UiBlock>
				</UiDialog>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TaskToolbarTemplate));
DisplayFactory.register("TaskToolbarTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TaskToolbarTemplate)));