import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import DisplaysNodeNotesTableRow from "unit-elements/gen/displays/rows/NodeNotesTableRow";
import DisplaysNodeNotesTableNameItem from "unit-elements/gen/displays/items/NodeNotesTableNameItem";
import DisplaysNodeNotesTableValueItem from "unit-elements/gen/displays/items/NodeNotesTableValueItem";
import DisplaysNodeNotesTableOperationsItem from "unit-elements/gen/displays/items/NodeNotesTableOperationsItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NodeNotesTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NodeNotesTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NodeNotesTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NodeNotesTemplateNotifier(this);
		this.requester = new NodeNotesTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287" format="bordered spaced" layout="vertical flexible">
					<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965" format="bordered" noItemsMessage="No se han registrado notas" pageSize={20} itemHeight={30} scrollingMark={false}>
						<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965.a_1764897871" style={{width:"30%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965.a_1764897871.a1503996494" mode="normal" value="Nombre">
							</UiText>
						</UiHeading>
						<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965.a_1617921356" style={{width:"60%",paddingRight:"10px"}} hidden="Never">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965.a_1617921356.a_1705265512" mode="normal" value="Valor">
							</UiText>
						</UiHeading>
						<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1318830287.a_1729398965.a_756116213" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						</UiHeading>
					</UiTable>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814" format="bordered spaced smallAirLeft" layout="vertical" width="20.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814.a_545080977" format="h5 doubleAirBottom" mode="normal" value="Añadir nota">
					</UiText>
					<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814.a2111765490" label="Nombre" format="airRight doubleAirBottom" mode="normal">
					</UiTextEditable>
					<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814.a_104247386" label="Valor" format="airRight doubleAirBottom" mode="normal">
					</UiTextEditable>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814.a_1035708630" layout="vertical" width="100px" height="-1px">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_987498814.a_1035708630.a_750260733" title="Añadir" target="self" mode="Button" size="Medium" highlighted="Outline">
						</UiAction>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(NodeNotesTemplate));
DisplayFactory.register("NodeNotesTemplate", withStyles(styles, { withTheme: true })(withSnackbar(NodeNotesTemplate)));