import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import RolesTableTypeItemNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import RolesTableTypeItemRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class RolesTableTypeItem extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new RolesTableTypeItemNotifier(this);
		this.requester = new RolesTableTypeItemRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_499362950" layout="horizontal centerjustified">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_499362950.a270682561" format="centered" mode="normal">
					</UiText>
				</UiBlock>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(RolesTableTypeItem));
DisplayFactory.register("RolesTableTypeItem", withStyles(styles, { withTheme: true })(withSnackbar(RolesTableTypeItem)));