import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiBlockPopover from "alexandria-ui-elements/src/displays/components/BlockPopover";
import UiHtmlViewer from "alexandria-ui-elements/src/displays/components/HtmlViewer";
import DisplaysAssignTaskDialogTableRow from "unit-elements/gen/displays/rows/AssignTaskDialogTableRow";
import DisplaysAssignTaskDialogTableFullnameItem from "unit-elements/gen/displays/items/AssignTaskDialogTableFullnameItem";
import DisplaysAssignTaskDialogTableEmailItem from "unit-elements/gen/displays/items/AssignTaskDialogTableEmailItem";
import DisplaysTrashTableRow from "unit-elements/gen/displays/rows/TrashTableRow";
import DisplaysTrashTableTypeItem from "unit-elements/gen/displays/items/TrashTableTypeItem";
import DisplaysTrashTableLabelItem from "unit-elements/gen/displays/items/TrashTableLabelItem";
import DisplaysTrashTableDeleteDateItem from "unit-elements/gen/displays/items/TrashTableDeleteDateItem";
import DisplaysTrashTableOperationsItem from "unit-elements/gen/displays/items/TrashTableOperationsItem";
import DisplaysRolesTableRow from "unit-elements/gen/displays/rows/RolesTableRow";
import DisplaysRolesTableUserItem from "unit-elements/gen/displays/items/RolesTableUserItem";
import DisplaysRolesTableDefinitionItem from "unit-elements/gen/displays/items/RolesTableDefinitionItem";
import DisplaysRolesTableTypeItem from "unit-elements/gen/displays/items/RolesTableTypeItem";
import DisplaysRolesTableNatureItem from "unit-elements/gen/displays/items/RolesTableNatureItem";
import DisplaysRolesTableStartDateItem from "unit-elements/gen/displays/items/RolesTableStartDateItem";
import DisplaysRolesTableEndDateItem from "unit-elements/gen/displays/items/RolesTableEndDateItem";
import DisplaysRolesTableOperationsItem from "unit-elements/gen/displays/items/RolesTableOperationsItem";
import DisplaysAddRoleUserTableRow from "unit-elements/gen/displays/rows/AddRoleUserTableRow";
import DisplaysAddRoleUserTableFullnameItem from "unit-elements/gen/displays/items/AddRoleUserTableFullnameItem";
import DisplaysAddRoleUserTableEmailItem from "unit-elements/gen/displays/items/AddRoleUserTableEmailItem";
import DisplaysAddRoleServiceTableRow from "unit-elements/gen/displays/rows/AddRoleServiceTableRow";
import DisplaysAddRoleServiceTableLabelItem from "unit-elements/gen/displays/items/AddRoleServiceTableLabelItem";
import DisplaysAddRoleServiceTablePartnerItem from "unit-elements/gen/displays/items/AddRoleServiceTablePartnerItem";
import DisplaysAddRoleFeederTableRow from "unit-elements/gen/displays/rows/AddRoleFeederTableRow";
import DisplaysAddRoleFeederTableLabelItem from "unit-elements/gen/displays/items/AddRoleFeederTableLabelItem";
import DisplaysAddRoleFeederTablePartnerItem from "unit-elements/gen/displays/items/AddRoleFeederTablePartnerItem";
import DisplaysLinksInTableRow from "unit-elements/gen/displays/rows/LinksInTableRow";
import DisplaysLinksInTableLabelItem from "unit-elements/gen/displays/items/LinksInTableLabelItem";
import DisplaysLinksInTableDescriptionItem from "unit-elements/gen/displays/items/LinksInTableDescriptionItem";
import DisplaysLinksOutTableRow from "unit-elements/gen/displays/rows/LinksOutTableRow";
import DisplaysLinksOutTableLabelItem from "unit-elements/gen/displays/items/LinksOutTableLabelItem";
import DisplaysLinksOutTableDescriptionItem from "unit-elements/gen/displays/items/LinksOutTableDescriptionItem";
import DisplaysNodeRevisionsTableRow from "unit-elements/gen/displays/rows/NodeRevisionsTableRow";
import DisplaysNodeRevisionsTableLabelItem from "unit-elements/gen/displays/items/NodeRevisionsTableLabelItem";
import DisplaysNodeRevisionsTableOperationsItem from "unit-elements/gen/displays/items/NodeRevisionsTableOperationsItem";
import DisplaysNodeNotesTableRow from "unit-elements/gen/displays/rows/NodeNotesTableRow";
import DisplaysNodeNotesTableNameItem from "unit-elements/gen/displays/items/NodeNotesTableNameItem";
import DisplaysNodeNotesTableValueItem from "unit-elements/gen/displays/items/NodeNotesTableValueItem";
import DisplaysNodeNotesTableOperationsItem from "unit-elements/gen/displays/items/NodeNotesTableOperationsItem";
import DisplaysTasksTableRow from "unit-elements/gen/displays/rows/TasksTableRow";
import DisplaysTasksTableLabelItem from "unit-elements/gen/displays/items/TasksTableLabelItem";
import DisplaysTasksTableOwnerItem from "unit-elements/gen/displays/items/TasksTableOwnerItem";
import DisplaysTasksTableCreateDateItem from "unit-elements/gen/displays/items/TasksTableCreateDateItem";
import DisplaysTasksTableUpdateDateItem from "unit-elements/gen/displays/items/TasksTableUpdateDateItem";
import DisplaysTasksTableCountMessagesItem from "unit-elements/gen/displays/items/TasksTableCountMessagesItem";
import DisplaysTasksTableOperationsItem from "unit-elements/gen/displays/items/TasksTableOperationsItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TasksTableCatalogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TasksTableCatalogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TasksTableCatalog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TasksTableCatalogNotifier(this);
		this.requester = new TasksTableCatalogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813" format="bordered" noItemsMessage="No hay tareas" pageSize={20} itemHeight={80} scrollingMark={false} selection="single">
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_2092811480" style={{width:"50%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_2092811480.a_1914937335" mode="normal" value="Título">
						</UiText>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a1375044132" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a1375044132.a1718375808" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a1375044132.a1718375808.a1487332096" mode="normal" value="Responsable">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a533449915" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a533449915.a_1850595589" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a533449915.a_1850595589.a878574141" mode="normal" value="Creada">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_310862959" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_310862959.a1185633997" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_310862959.a1185633997.a_930524333" mode="normal" value="Actualizada">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_1176788226" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_1176788226.a_481456276" layout="horizontal centerjustified">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_1176788226.a_481456276.a936959540" mode="normal" value="Mensajes">
							</UiText>
						</UiBlock>
					</UiHeading>
					<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a901307813.a_1241580638" style={{width:"10%",paddingRight:"10px"}} hidden="Never">
					</UiHeading>
				</UiTable>
				<UiBlockPopover context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_635827682" format="spaced" layout="vertical" position="BottomCenter">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_635827682.a1437612294" format="h6 airBottom" mode="normal" value="Más información">
					</UiText>
					<UiHtmlViewer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_635827682.a1135183605">
					</UiHtmlViewer>
				</UiBlockPopover>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(TasksTableCatalog));
DisplayFactory.register("TasksTableCatalog", withStyles(styles, { withTheme: true })(withSnackbar(TasksTableCatalog)));