import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSelectPreviousItem from "alexandria-ui-elements/src/displays/components/SelectPreviousItem";
import UiSelectNextItem from "alexandria-ui-elements/src/displays/components/SelectNextItem";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiDateEditable from "alexandria-ui-elements/src/displays/components/DateEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import RoleEmbeddedTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import RoleEmbeddedTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class RoleEmbeddedTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new RoleEmbeddedTemplateNotifier(this);
		this.requester = new RoleEmbeddedTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037" format="bottomBordered bottomSpaced leftSpaced middleTopSpaced" layout="horizontal">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a1523265971" layout="horizontal flexible">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a1523265971.a2107348201" title="Editar" target="self" mode="Button" size="Small" format="airRight" highlighted="Outline">
						</UiAction>
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a1523265971.a_1689454171" title="Revocar" target="self" mode="Button" affirmed="Are you sure to revoke role?" size="Small" highlighted="Outline">
						</UiAction>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a_693241596" layout="horizontal endjustified">
						<UiSelectPreviousItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a_693241596.a_698856845" title="Anterior" target="self" mode="MaterialIconButton" icon="KeyboardArrowLeft" size="Small" format="airRight">
						</UiSelectPreviousItem>
						<UiSelectNextItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1909865037.a_693241596.a_1253885841" title="Siguiente" target="self" mode="MaterialIconButton" icon="KeyboardArrowRight" size="Small" format="airRight">
						</UiSelectNextItem>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662" format="spaced" layout="vertical flexible" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a_133366491" layout="horizontal center">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a_133366491.a_1129547358" format="airRight" mode="normal">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a_133366491.a_658050662" format="body2 pillStyle" mode="normal" highlighted={{text:"white",background:"transparent"}}>
						</UiText>
					</UiBlock>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1135013134" format="grey" mode="normal">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1993608898" format="doubleAirBottom doubleAirTop" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1993608898.a_555387279" label="Class" mode="normal">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1993608898.a_508985640" label="Type" mode="normal">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1993608898.a297270469" label="Nature" mode="normal">
						</UiText>
						<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a1993608898.a_1699329454" label="Start date" pattern="DD/MM/YYYY HH:mm">
						</UiDate>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a691431112" layout="vertical" width="300px" height="-1px">
						<UiDateEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_278537662.a691431112.a1188956304" label="End date" pattern="DD/MM/YYYY" allowEmpty={true}>
						</UiDateEditable>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(RoleEmbeddedTemplate));
DisplayFactory.register("RoleEmbeddedTemplate", withStyles(styles, { withTheme: true })(withSnackbar(RoleEmbeddedTemplate)));