import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import DownloadDialogOptionNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import DownloadDialogOptionRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DownloadDialogOption extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new DownloadDialogOptionNotifier(this);
		this.requester = new DownloadDialogOptionRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="airBottom" layout="horizontal" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1769813299" layout="vertical" width="25.0%" height="100.0%">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1769813299.a_783095790" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1986938386" layout="flexible">
					<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1986938386.a582355576" traceable={true} multipleSelection={false} placeholder="Seleccione una columna" maxMenuHeight={300}>
					</UiSelectorComboBox>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(DownloadDialogOption));
DisplayFactory.register("DownloadDialogOption", withStyles(styles, { withTheme: true })(withSnackbar(DownloadDialogOption)));