import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSelectorCollectionBox from "alexandria-ui-elements/src/displays/components/SelectorCollectionBox";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysComboFilterTemplateMold from "unit-elements/gen/displays/items/ComboFilterTemplateMold";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ComboFilterTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ComboFilterTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ComboFilterTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ComboFilterTemplateNotifier(this);
		this.requester = new ComboFilterTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1152908214" format="body2" mode="normal">
				</UiText>
				<UiSelectorCollectionBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1343038752" multipleSelection={true} placeholder="Seleccione una opción">
					<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1343038752.a_562694753options" pageSize={20} itemHeight={30} scrollingMark={true} selection="single">
					</UiList>
				</UiSelectorCollectionBox>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ComboFilterTemplate));
DisplayFactory.register("ComboFilterTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ComboFilterTemplate)));