import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiList from "alexandria-ui-elements/src/displays/components/List";
import DisplaysNewsListItem from "unit-elements/gen/displays/items/NewsListItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import NewsTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import NewsTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class NewsTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new NewsTemplateNotifier(this);
		this.requester = new NewsTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock format="smallAir" layout="vertical flexible" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488525792" format="bordered spaced" layout="horizontal">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488525792.a1378858195" layout="vertical flexible">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488525792.a1378858195.a1358273901" layout="horizontal">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488525792.a1378858195.a1358273901.a_2012988266" format="h4 bold" mode="normal" translate={true} value="News">
							</UiText>
						</UiBlock>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a488525792.a1378858195.a_1100913553" format="body2" mode="normal">
						</UiText>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1757074223" format="smallAirTop" layout="horizontal flexible">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1757074223.a794529795" format="bordered" layout="vertical flexible">
						<UiList context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1757074223.a794529795.a1595842283" noItemsMessage="No hay noticias" pageSize={20} itemHeight={110} scrollingMark={false}>
						</UiList>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(NewsTemplate));
DisplayFactory.register("NewsTemplate", withStyles(styles, { withTheme: true })(withSnackbar(NewsTemplate)));