import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TasksToolbarTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TasksToolbarTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TasksToolbarTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TasksToolbarTemplateNotifier(this);
		this.requester = new TasksToolbarTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal center" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a474606329" visible={false} layout="horizontal center">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a474606329.a_933250188" format="airRight" mode="normal" value="Han llegado nuevas tareas">
					</UiText>
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a474606329.a1418861461" title="Actualizar" target="self" mode="Button" size="Small" highlighted="Outline">
					</UiAction>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TasksToolbarTemplate));
DisplayFactory.register("TasksToolbarTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TasksToolbarTemplate)));