import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiActionSwitch from "alexandria-ui-elements/src/displays/components/ActionSwitch";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import DisplaysSourceTermTagTemplate from "unit-elements/gen/displays/templates/SourceTermTagTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import SourceTermDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import SourceTermDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class SourceTermDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new SourceTermDialogNotifier(this);
		this.requester = new SourceTermDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020" format="doubleAirBottom middleSpaced leftSpaced rightSpaced" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a202840821" format="h5 airBottom" mode="normal">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017" format="bordered dialog" layout="vertical">
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a218576090" label="Code" format="doubleAirBottom" mode="normal" placeholder="" readonly={true}>
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a_1806183001" label="Label" format="doubleAirBottom" mode="normal" placeholder="">
						</UiTextEditable>
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a219092519" label="Type" multipleSelection={false} placeholder="Select type" maxMenuHeight={300}>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a219092519.a2041399518" name="termType" mode="normal" translate={true} value="Term">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a219092519.a_143270800" name="categoryType" mode="normal" translate={true} value="Category">
							</UiText>
						</UiSelectorComboBox>
						<UiActionSwitch context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a_1512657282" title="Contain other terms" target="self" mode="Link" size="Medium" format="doubleAirBottom" state="Off">
						</UiActionSwitch>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a_2104397699" format="grey" mode="normal" translate={true} value="Tags">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a219069190" multiple={{instances:"tags",arrangement:"Vertical",noItemsMessage:"No tags",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717" format="airTop airBottom" layout="horizontal">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a2022598492" format="airRight" visible={false} layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a2022598492.a_1380910138" title="Enable" target="self" mode="Button" size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a_555526605" format="airRight" visible={false} layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a_555526605.a_1023591204" title="Disable" target="self" mode="Button" size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a_1965367244" format="airRight" visible={false} layout="vertical" width="120px" height="-1px">
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1123941020.a1701105017.a855052717.a_1965367244.a_558055402" title="Delete" target="self" mode="Button" size="Small" highlighted="Outline">
								</UiAction>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931" format="middleSpaced leftSpaced rightSpaced" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a_499239167" format="h5 airBottom" mode="normal">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a646728088" format="bordered dialog" layout="vertical">
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a646728088.a_348922111" label="Code" format="doubleAirBottom" mode="normal" placeholder="">
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a646728088.a2076209248" label="Label" format="doubleAirBottom" mode="normal" placeholder="">
						</UiTextEditable>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a646728088.a240865195" layout="vertical" width="150px" height="-1px">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_815145931.a646728088.a240865195.a_996141550" title="Add" target="self" mode="Button" size="Small" highlighted="Outline">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(SourceTermDialog));
DisplayFactory.register("SourceTermDialog", withStyles(styles, { withTheme: true })(withSnackbar(SourceTermDialog)));