import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiFileEditable from "alexandria-ui-elements/src/displays/components/FileEditable";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import GorosInstallTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import GorosInstallTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GorosInstallTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new GorosInstallTemplateNotifier(this);
		this.requester = new GorosInstallTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700" format="blackBackground relative" layout="horizontal end" width="-1px" height="150px">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700.a_1260021814" layout="vertical" width="165px" height="-1px">
						<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700.a_1260021814.a_1870334643" format="installerImageStyle" width="128px" height="128px">
						</UiImage>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700.a1002821382" format="airBottom" layout="vertical">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700.a1002821382.a_1507252780" format="white doubleAirLeft" mode="uppercase" value="Goros Installer">
						</UiText>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a560247700.a1002821382.a_825346407" format="h1 white doubleAirLeft" mode="normal" value="Upload Business Model">
						</UiText>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773" layout="vertical flexible centercenter" width="100.0%" height="75.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708" format="doubleAirTop" layout="vertical">
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1401952263" format="doubleAirBottom" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1401952263.a929318106" format="h3" mode="normal" value="Unit model not defined">
							</UiText>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1401952263.a1590574334" format="grey" mode="normal" value="Upload Unit model by using eclipse IDE or drag and drop here">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a_1627124588" format="doubleAirBottom" layout="vertical">
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a_1627124588.a_1998636773" mode="normal" value="Business unit model zip file">
							</UiText>
							<UiFileEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a_1627124588.a_2101228214" dropZone={true}>
							</UiFileEditable>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a_1627124588.a1148937030" format="doubleAirTop" visible={false} layout="vertical centercenter">
								<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a_1627124588.a1148937030.a_906680557" mode="Bar">
								</UiSpinner>
							</UiBlock>
						</UiBlock>
						<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1376822535" format="airBottom">
						</UiDivider>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1461324776" layout="vertical end">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a_1556295708.a1461324776.a1669991490" title="Upload" target="self" mode="Button" readonly={true} size="Medium" highlighted="Outline">
							</UiAction>
						</UiBlock>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a800089264" format="bordered doubleAirTop dialog autoOverflow" visible={false} layout="vertical flexible" width="100.0%" height="50.0%" animation={{mode:"Slide",direction:"Right",duration:"500"}}>
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a800089264.a_431088506" format="h3 airBottom" mode="normal" translate={true} value="Console">
						</UiText>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1099687773.a800089264.a981804955" multiple={{instances:"logEntries",arrangement:"Vertical",noItemsMessage:"No logging info available",spacing:0,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}} mode="normal">
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(GorosInstallTemplate));
DisplayFactory.register("GorosInstallTemplate", withStyles(styles, { withTheme: true })(withSnackbar(GorosInstallTemplate)));