import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiDate from "alexandria-ui-elements/src/displays/components/Date";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysTaskOrderTemplate from "unit-elements/gen/displays/templates/TaskOrderTemplate";
import DisplaysTaskPlaceDelegationTemplate from "unit-elements/gen/displays/templates/TaskPlaceDelegationTemplate";
import DisplaysTaskPlaceSendJobTemplate from "unit-elements/gen/displays/templates/TaskPlaceSendJobTemplate";
import DisplaysTaskPlaceLineTemplate from "unit-elements/gen/displays/templates/TaskPlaceLineTemplate";
import DisplaysTaskPlaceEditionTemplate from "unit-elements/gen/displays/templates/TaskPlaceEditionTemplate";
import DisplaysTaskPlaceEnrollTemplate from "unit-elements/gen/displays/templates/TaskPlaceEnrollTemplate";
import DisplaysTaskPlaceWaitTemplate from "unit-elements/gen/displays/templates/TaskPlaceWaitTemplate";
import DisplaysTaskPlaceSendRequestTemplate from "unit-elements/gen/displays/templates/TaskPlaceSendRequestTemplate";
import DisplaysTaskPlaceSendResponseTemplate from "unit-elements/gen/displays/templates/TaskPlaceSendResponseTemplate";
import DisplaysTaskHistoryTemplate from "unit-elements/gen/displays/templates/TaskHistoryTemplate";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import TaskStateViewTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import TaskStateViewTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class TaskStateViewTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new TaskStateViewTemplateNotifier(this);
		this.requester = new TaskStateViewTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<DisplaysTaskOrderTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_613089335" visible={false}>
				</DisplaysTaskOrderTemplate>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a322929797" format="grey doubleAirBottom" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_722683450" format="doubleAirBottom" layout="vertical">
					<UiDate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_722683450.a_1005632251" format="body2 grey middleAirRight" pattern="DD/MM/YYYY HH:mm:ss">
					</UiDate>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_722683450.a_1095427558" mode="normal" highlighted={{text:"white",background:"#33942F"}}>
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a394641967" layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a394641967.a_1919652454" mode="normal">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823" layout="vertical">
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_927069434" layout="vertical" width="100.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_927069434.a26651563" mode="normal" value="Task is finished">
						</UiText>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a1105898123" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceDelegationTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a1105898123.a162249762">
						</DisplaysTaskPlaceDelegationTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a138278268" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceSendJobTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a138278268.a45583596">
						</DisplaysTaskPlaceSendJobTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a984626647" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceLineTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a984626647.a_1213456862">
						</DisplaysTaskPlaceLineTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_256268379" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceEditionTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_256268379.a_617770662">
						</DisplaysTaskPlaceEditionTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a1560223241" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceEnrollTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a1560223241.a_136829982">
						</DisplaysTaskPlaceEnrollTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a41316056" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceWaitTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a41316056.a190857474">
						</DisplaysTaskPlaceWaitTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_907655602" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceSendRequestTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a_907655602.a109808456">
						</DisplaysTaskPlaceSendRequestTemplate>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a2072102220" layout="vertical" width="100.0%" height="100.0%">
						<DisplaysTaskPlaceSendResponseTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_372785823.a2072102220.a_549719166">
						</DisplaysTaskPlaceSendResponseTemplate>
					</UiBlockConditional>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1221181834" format="doubleAirTop" layout="vertical">
					<DisplaysTaskHistoryTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1221181834.a152325434">
					</DisplaysTaskHistoryTemplate>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(TaskStateViewTemplate));
DisplayFactory.register("TaskStateViewTemplate", withStyles(styles, { withTheme: true })(withSnackbar(TaskStateViewTemplate)));