import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import BannerTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import BannerTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class BannerTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new BannerTemplateNotifier(this);
		this.requester = new BannerTemplateRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2098568786" visible={false} layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_2098568786.a1293519871" format="body2 grey" mode="normal" translate={true} value="Restricted information">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_925345761" visible={false} layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_925345761.a_862912504" format="body2 grey" mode="normal">
					</UiText>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_925345761.a2030560343" format="body2 grey" mode="normal">
					</UiText>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(BannerTemplate));
DisplayFactory.register("BannerTemplate", withStyles(styles, { withTheme: true })(withSnackbar(BannerTemplate)));