/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.space;

import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.classpath.ClasspathTransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class MavenDependencyResolver {
    private static RepositorySystem system;
    private static final String DEFAULT_REPO_LOCAL;
    private static final RemoteRepository DEFAULT_REPO_REMOTE;
    private static RepositorySystemSession session;
    private final List<RemoteRepository> remoteRepos;

    private static void loadService() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, ClasspathTransporterFactory.class);
        system = (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static void init() {
        MavenDependencyResolver.init(DEFAULT_REPO_LOCAL);
    }

    private static void init(String localRepo) {
        if (system == null) {
            MavenDependencyResolver.loadService();
        }
        if (session == null) {
            session = MavenDependencyResolver.buildSession(localRepo);
        }
    }

    public static List<Dependency> dependenciesFrom(DependencyResult result, boolean includeUnresolved) {
        PreorderNodeListGenerator nodeListGenerator = new PreorderNodeListGenerator();
        result.getRoot().accept((DependencyVisitor)nodeListGenerator);
        return nodeListGenerator.getDependencies(includeUnresolved);
    }

    public MavenDependencyResolver(List<RemoteRepository> remoteRepos) {
        MavenDependencyResolver.init();
        this.remoteRepos = remoteRepos.isEmpty() ? List.of(DEFAULT_REPO_REMOTE) : remoteRepos;
    }

    public MavenDependencyResolver(String localRepository, List<RemoteRepository> remoteRepos) {
        MavenDependencyResolver.init(localRepository);
        this.remoteRepos = remoteRepos.isEmpty() ? List.of(DEFAULT_REPO_REMOTE) : remoteRepos;
    }

    public static MetadataResult metadata(DefaultArtifact artifact) {
        MavenDependencyResolver.init();
        return (MetadataResult)system.resolveMetadata(session, Collections.singleton(new MetadataRequest((Metadata)new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), Metadata.Nature.RELEASE_OR_SNAPSHOT)))).get(0);
    }

    public ArtifactResult resolveSources(Artifact dependency) {
        try {
            return system.resolveArtifact(session, new ArtifactRequest(dependency, this.remoteRepos, null));
        }
        catch (ArtifactResolutionException e) {
            return e.getResult();
        }
    }

    public DependencyResult resolve(DefaultArtifact artifact, String scope) throws DependencyResolutionException {
        return system.resolveDependencies(session, this.request(artifact, scope));
    }

    private DependencyRequest request(DefaultArtifact artifact, String scope) {
        return new DependencyRequest(new CollectRequest(List.of(new Dependency((Artifact)artifact, scope.toLowerCase())), null, this.remoteRepos), null);
    }

    private static RepositorySystemSession buildSession(String localRepo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        return session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepo))).setCache((RepositoryCache)new DefaultRepositoryCache());
    }

    static RemoteRepository repository(String url, String identifier, boolean isSnapshot, String updatePolicy) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(identifier, "default", url);
        if (isSnapshot) {
            builder.setSnapshotPolicy(new RepositoryPolicy(true, updatePolicy, "warn")).setReleasePolicy(new RepositoryPolicy(false, updatePolicy, "warn"));
        } else {
            builder.setReleasePolicy(new RepositoryPolicy(true, updatePolicy, "warn")).setSnapshotPolicy(new RepositoryPolicy(false, updatePolicy, "warn"));
        }
        return builder.build();
    }

    static {
        DEFAULT_REPO_LOCAL = String.format("%s/.m2/repository", System.getProperty("user.home"));
        DEFAULT_REPO_REMOTE = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
        MavenDependencyResolver.loadService();
    }
}

