/*
 * Decompiled with CFR 0.152.
 */
package org.monet.space.kernel.model;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;

public class BusinessModelClassLoader
extends ClassLoader {
    protected String modelPathBase;
    protected String modelLibrariesPathBase;
    private static HashMap<String, Class<?>> modelClasses = new HashMap();
    private static HashMap<String, Class<?>> libraryClasses = new HashMap();

    public BusinessModelClassLoader(String modelPathBase, String modelLibrariesPathBase) {
        this.modelPathBase = modelPathBase;
        this.modelLibrariesPathBase = modelLibrariesPathBase;
    }

    byte[] getClassBytes(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        boolean eof = false;
        while (!eof) {
            try {
                int i = bis.read();
                if (i == -1) {
                    eof = true;
                    continue;
                }
                baos.write(i);
            }
            catch (IOException e) {
                Logger.error(e);
                return null;
            }
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        InputStream is = null;
        try {
            if (modelClasses.containsKey(name)) {
                Class<?> clazz = modelClasses.get(name);
                return clazz;
            }
            if (libraryClasses.containsKey(name)) {
                Class<?> clazz = libraryClasses.get(name);
                return clazz;
            }
            File file = new File(this.modelPathBase, name.replace(".", "/") + ".class");
            if (!file.exists()) {
                file = new File(this.modelLibrariesPathBase, name.replace(".", "/") + ".class");
            }
            if (!file.exists()) {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(name);
                return clazz;
            }
            is = new FileInputStream(file);
            byte[] buf = this.getClassBytes(is);
            Class<?> resultClass = this.defineClass(name, buf, 0, buf.length, null);
            if (this.isLibraryClass(name)) {
                libraryClasses.put(name, resultClass);
            } else {
                modelClasses.put(name, resultClass);
            }
            Class<?> clazz = resultClass;
            return clazz;
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        try {
            File file = new File(this.modelPathBase, name);
            if (!file.exists()) {
                file = new File(this.modelLibrariesPathBase, name);
            }
            if (!file.exists()) {
                return super.findResource(name);
            }
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> superResources = super.findResources(name);
        ArrayList<URL> result = new ArrayList<URL>();
        while (superResources.hasMoreElements()) {
            result.add(superResources.nextElement());
        }
        File file = new File(this.modelPathBase, name);
        if (file.exists()) {
            result.add(file.toURI().toURL());
        }
        if ((file = new File(this.modelLibrariesPathBase, name)).exists()) {
            result.add(file.toURI().toURL());
        }
        return Collections.enumeration(result);
    }

    private boolean isLibraryClass(String name) {
        return new File(this.modelLibrariesPathBase, name.replace(".", "/") + ".class").exists();
    }

    public static void reset() {
        modelClasses.clear();
    }
}

