/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.metamodel.TaskRequestProperty;
import org.monet.metamodel.TaskResponseProperty;
import org.monet.metamodel.internal.Ref;

public class TaskCollaboratorProperty
extends ReferenceableProperty {
    protected Ref _task;
    protected LinkedHashMap<String, RequestProperty> _requestPropertyMap = new LinkedHashMap();
    protected LinkedHashMap<String, ResponseProperty> _responsePropertyMap = new LinkedHashMap();
    protected AbortedProperty _abortedProperty;

    public Ref getTask() {
        return this._task;
    }

    public void setTask(Ref value) {
        this._task = value;
    }

    public void addRequest(RequestProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        RequestProperty current = this._requestPropertyMap.get(key);
        if (current != null) {
            current.merge(value);
        } else {
            this._requestPropertyMap.put(key, value);
        }
    }

    public Map<String, RequestProperty> getRequestMap() {
        return this._requestPropertyMap;
    }

    public Collection<RequestProperty> getRequestList() {
        return this._requestPropertyMap.values();
    }

    public void addResponse(ResponseProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ResponseProperty current = this._responsePropertyMap.get(key);
        if (current != null) {
            current.merge(value);
        } else {
            this._responsePropertyMap.put(key, value);
        }
    }

    public Map<String, ResponseProperty> getResponseMap() {
        return this._responsePropertyMap;
    }

    public Collection<ResponseProperty> getResponseList() {
        return this._responsePropertyMap.values();
    }

    public AbortedProperty getAborted() {
        return this._abortedProperty;
    }

    public void setAborted(AbortedProperty value) {
        if (this._abortedProperty != null) {
            this._abortedProperty.merge(value);
        } else {
            this._abortedProperty = value;
        }
    }

    public void merge(TaskCollaboratorProperty child) {
        super.merge(child);
        if (child._task != null) {
            this._task = child._task;
        }
        for (RequestProperty requestProperty : child._requestPropertyMap.values()) {
            this.addRequest(requestProperty);
        }
        for (ResponseProperty responseProperty : child._responsePropertyMap.values()) {
            this.addResponse(responseProperty);
        }
        if (this._abortedProperty == null) {
            this._abortedProperty = child._abortedProperty;
        } else {
            this._abortedProperty.merge(child._abortedProperty);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return TaskCollaboratorProperty.class;
    }

    public static class RequestProperty
    extends TaskRequestProperty {
        protected void merge(RequestProperty child) {
            super.merge(child);
        }
    }

    public static class ResponseProperty
    extends TaskResponseProperty {
        protected void merge(ResponseProperty child) {
            super.merge(child);
        }
    }

    public static class AbortedProperty {
        protected Ref _unlock;
        protected Ref _goto;

        public Ref getUnlock() {
            return this._unlock;
        }

        public void setUnlock(Ref value) {
            this._unlock = value;
        }

        public Ref getGoto() {
            return this._goto;
        }

        public void setGoto(Ref value) {
            this._goto = value;
        }

        protected void merge(AbortedProperty child) {
            if (child._unlock != null) {
                this._unlock = child._unlock;
            }
            if (child._goto != null) {
                this._goto = child._goto;
            }
        }
    }
}

