/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.EntityDefinition;
import org.monet.metamodel.ViewProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class IndexDefinitionBase
extends EntityDefinition {
    protected ReferenceProperty _referenceProperty;
    protected LinkedHashMap<String, IndexViewProperty> _indexViewPropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return DefinitionType.index;
    }

    public ReferenceProperty getReference() {
        return this._referenceProperty;
    }

    public void setReference(ReferenceProperty value) {
        if (this._referenceProperty != null) {
            this._referenceProperty.merge(value);
        } else {
            this._referenceProperty = value;
        }
    }

    public void addView(IndexViewProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        IndexViewProperty current = this._indexViewPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    IndexViewProperty instance = (IndexViewProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._indexViewPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._indexViewPropertyMap.put(key, value);
        }
    }

    public Map<String, IndexViewProperty> getViewMap() {
        return this._indexViewPropertyMap;
    }

    public Collection<IndexViewProperty> getViewList() {
        return this._indexViewPropertyMap.values();
    }

    public void copy(IndexDefinitionBase instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        this._referenceProperty = instance._referenceProperty;
        for (IndexViewProperty item : instance._indexViewPropertyMap.values()) {
            this.addView(item);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(IndexDefinitionBase child) {
        super.merge(child);
        if (this._referenceProperty == null) {
            this._referenceProperty = child._referenceProperty;
        } else if (child._referenceProperty != null) {
            this._referenceProperty.merge(child._referenceProperty);
        }
        for (IndexViewProperty item : child._indexViewPropertyMap.values()) {
            this.addView(item);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return IndexDefinitionBase.class;
    }

    public static class ReferenceProperty {
        protected LinkedHashMap<String, AttributeProperty> _attributePropertyMap = new LinkedHashMap();

        public void addAttributeProperty(AttributeProperty value) {
            String key = value.getName() != null ? value.getName() : value.getCode();
            AttributeProperty current = this._attributePropertyMap.get(key);
            if (current != null) {
                if (current.getClass().isAssignableFrom(value.getClass())) {
                    try {
                        AttributeProperty instance = (AttributeProperty)value.getClass().newInstance();
                        instance.copy(current);
                        instance.setCode(value.getCode());
                        instance.setName(value.getName());
                        instance.merge(value);
                        this._attributePropertyMap.put(key, instance);
                    }
                    catch (Exception exception) {}
                } else {
                    current.merge(value);
                }
            } else {
                this._attributePropertyMap.put(key, value);
            }
        }

        public Map<String, AttributeProperty> getAttributePropertyMap() {
            return this._attributePropertyMap;
        }

        public Collection<AttributeProperty> getAttributePropertyList() {
            return this._attributePropertyMap.values();
        }

        protected void copy(ReferenceProperty instance) {
            for (AttributeProperty item : instance._attributePropertyMap.values()) {
                this.addAttributeProperty(item);
            }
        }

        protected void merge(ReferenceProperty child) {
            for (AttributeProperty item : child._attributePropertyMap.values()) {
                this.addAttributeProperty(item);
            }
        }
    }

    public static class IndexViewProperty
    extends ViewProperty {
        protected IsDefault _isDefault;
        protected ShowProperty _showProperty;

        public boolean isDefault() {
            return this._isDefault != null;
        }

        public IsDefault getIsDefault() {
            return this._isDefault;
        }

        public void setIsDefault(boolean value) {
            this._isDefault = value ? new IsDefault() : null;
        }

        public ShowProperty getShow() {
            return this._showProperty;
        }

        public void setShow(ShowProperty value) {
            if (this._showProperty != null) {
                this._showProperty.merge(value);
            } else {
                this._showProperty = value;
            }
        }

        protected void copy(IndexViewProperty instance) {
            this._code = instance._code;
            this._name = instance._name;
            this._isDefault = instance._isDefault;
            this._showProperty = instance._showProperty;
        }

        protected void merge(IndexViewProperty child) {
            super.merge(child);
            if (this._isDefault == null) {
                this._isDefault = child._isDefault;
            } else if (child._isDefault != null) {
                this._isDefault.merge(child._isDefault);
            }
            if (this._showProperty == null) {
                this._showProperty = child._showProperty;
            } else if (child._showProperty != null) {
                this._showProperty.merge(child._showProperty);
            }
        }

        public static class IsDefault {
            protected void copy(IsDefault instance) {
            }

            protected void merge(IsDefault child) {
            }
        }

        public static class ShowProperty {
            protected Ref _title;
            protected ArrayList<Ref> _line = new ArrayList();
            protected ArrayList<Ref> _lineBelow = new ArrayList();
            protected ArrayList<Ref> _highlight = new ArrayList();
            protected ArrayList<Ref> _footer = new ArrayList();
            protected Ref _icon;
            protected Ref _picture;

            public Ref getTitle() {
                return this._title;
            }

            public void setTitle(Ref value) {
                this._title = value;
            }

            public ArrayList<Ref> getLine() {
                return this._line;
            }

            public void setLine(ArrayList<Ref> value) {
                this._line = value;
            }

            public ArrayList<Ref> getLineBelow() {
                return this._lineBelow;
            }

            public void setLineBelow(ArrayList<Ref> value) {
                this._lineBelow = value;
            }

            public ArrayList<Ref> getHighlight() {
                return this._highlight;
            }

            public void setHighlight(ArrayList<Ref> value) {
                this._highlight = value;
            }

            public ArrayList<Ref> getFooter() {
                return this._footer;
            }

            public void setFooter(ArrayList<Ref> value) {
                this._footer = value;
            }

            public Ref getIcon() {
                return this._icon;
            }

            public void setIcon(Ref value) {
                this._icon = value;
            }

            public Ref getPicture() {
                return this._picture;
            }

            public void setPicture(Ref value) {
                this._picture = value;
            }

            protected void copy(ShowProperty instance) {
                this._title = instance._title;
                this._line.addAll(instance._line);
                this._lineBelow.addAll(instance._lineBelow);
                this._highlight.addAll(instance._highlight);
                this._footer.addAll(instance._footer);
                this._icon = instance._icon;
                this._picture = instance._picture;
            }

            protected void merge(ShowProperty child) {
                if (child._title != null) {
                    this._title = child._title;
                }
                if (child._line != null) {
                    this._line.addAll(child._line);
                }
                if (child._lineBelow != null) {
                    this._lineBelow.addAll(child._lineBelow);
                }
                if (child._highlight != null) {
                    this._highlight.addAll(child._highlight);
                }
                if (child._footer != null) {
                    this._footer.addAll(child._footer);
                }
                if (child._icon != null) {
                    this._icon = child._icon;
                }
                if (child._picture != null) {
                    this._picture = child._picture;
                }
            }
        }
    }
}

