/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.NodeDefinition;
import org.monet.metamodel.NodeDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.RuleProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class DesktopDefinitionBase
extends NodeDefinition {
    protected ContainProperty _containProperty;
    protected ForProperty _forProperty;
    protected LinkedHashMap<String, ViewProperty> _viewPropertyMap = new LinkedHashMap();
    protected ArrayList<RuleLinkProperty> _ruleLinkPropertyList = new ArrayList();

    @Override
    public DefinitionType getType() {
        return DefinitionType.desktop;
    }

    public ContainProperty getContain() {
        return this._containProperty;
    }

    public void setContain(ContainProperty value) {
        if (this._containProperty != null) {
            this._containProperty.merge(value);
        } else {
            this._containProperty = value;
        }
    }

    public ForProperty getFor() {
        return this._forProperty;
    }

    public void setFor(ForProperty value) {
        if (this._forProperty != null) {
            this._forProperty.merge(value);
        } else {
            this._forProperty = value;
        }
    }

    public void addView(ViewProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ViewProperty current = this._viewPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    ViewProperty instance = (ViewProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._viewPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._viewPropertyMap.put(key, value);
        }
    }

    public Map<String, ViewProperty> getViewMap() {
        return this._viewPropertyMap;
    }

    public Collection<ViewProperty> getViewList() {
        return this._viewPropertyMap.values();
    }

    public ArrayList<RuleLinkProperty> getRuleLinkList() {
        return this._ruleLinkPropertyList;
    }

    public void copy(DesktopDefinitionBase instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        this._containProperty = instance._containProperty;
        this._forProperty = instance._forProperty;
        for (ViewProperty viewProperty : instance._viewPropertyMap.values()) {
            this.addView(viewProperty);
        }
        this._ruleLinkPropertyList.addAll(instance._ruleLinkPropertyList);
        this._isSingleton = instance._isSingleton;
        this._isReadonly = instance._isReadonly;
        this._isPrivate = instance._isPrivate;
        this._requirePartnerContextProperty = instance._requirePartnerContextProperty;
        this._isBreadcrumbsDisabled = instance._isBreadcrumbsDisabled;
        for (NodeDefinitionBase.OperationProperty operationProperty : instance._operationPropertyMap.values()) {
            this.addOperation(operationProperty);
        }
        this._ruleNodePropertyList.addAll(instance._ruleNodePropertyList);
        this._ruleViewPropertyList.addAll(instance._ruleViewPropertyList);
        this._ruleOperationPropertyList.addAll(instance._ruleOperationPropertyList);
        this._displayPropertyList.addAll(instance._displayPropertyList);
        this._isAbstract = instance._isAbstract;
    }

    public void merge(DesktopDefinitionBase child) {
        super.merge(child);
        if (this._containProperty == null) {
            this._containProperty = child._containProperty;
        } else if (child._containProperty != null) {
            this._containProperty.merge(child._containProperty);
        }
        if (this._forProperty == null) {
            this._forProperty = child._forProperty;
        } else if (child._forProperty != null) {
            this._forProperty.merge(child._forProperty);
        }
        for (ViewProperty item : child._viewPropertyMap.values()) {
            this.addView(item);
        }
        this._ruleLinkPropertyList.addAll(child._ruleLinkPropertyList);
    }

    @Override
    public Class<?> getMetamodelClass() {
        return DesktopDefinitionBase.class;
    }

    public static class ContainProperty {
        protected ArrayList<Ref> _node = new ArrayList();

        public ArrayList<Ref> getNode() {
            return this._node;
        }

        public void setNode(ArrayList<Ref> value) {
            this._node = value;
        }

        protected void copy(ContainProperty instance) {
            this._node.addAll(instance._node);
        }

        protected void merge(ContainProperty child) {
            if (child._node != null) {
                this._node.addAll(child._node);
            }
        }
    }

    public static class ForProperty {
        protected ArrayList<Ref> _role = new ArrayList();

        public ArrayList<Ref> getRole() {
            return this._role;
        }

        public void setRole(ArrayList<Ref> value) {
            this._role = value;
        }

        protected void copy(ForProperty instance) {
            this._role.addAll(instance._role);
        }

        protected void merge(ForProperty child) {
            if (child._role != null) {
                this._role.addAll(child._role);
            }
        }
    }

    public static class ViewProperty
    extends NodeViewProperty {
        protected ShowProperty _showProperty;

        public ShowProperty getShow() {
            return this._showProperty;
        }

        public void setShow(ShowProperty value) {
            if (this._showProperty != null) {
                this._showProperty.merge(value);
            } else {
                this._showProperty = value;
            }
        }

        protected void copy(ViewProperty instance) {
            this._label = instance._label;
            this._code = instance._code;
            this._name = instance._name;
            this._showProperty = instance._showProperty;
            this._isDefault = instance._isDefault;
            this._isVisibleWhenEmbedded = instance._isVisibleWhenEmbedded;
            this._forProperty = instance._forProperty;
        }

        protected void merge(ViewProperty child) {
            super.merge(child);
            if (this._showProperty == null) {
                this._showProperty = child._showProperty;
            } else if (child._showProperty != null) {
                this._showProperty.merge(child._showProperty);
            }
        }

        public static class ShowProperty {
            protected ArrayList<Ref> _link = new ArrayList();
            protected ArrayList<Ref> _dashboard = new ArrayList();

            public ArrayList<Ref> getLink() {
                return this._link;
            }

            public void setLink(ArrayList<Ref> value) {
                this._link = value;
            }

            public ArrayList<Ref> getDashboard() {
                return this._dashboard;
            }

            public void setDashboard(ArrayList<Ref> value) {
                this._dashboard = value;
            }

            protected void copy(ShowProperty instance) {
                this._link.addAll(instance._link);
                this._dashboard.addAll(instance._dashboard);
            }

            protected void merge(ShowProperty child) {
                if (child._link != null) {
                    this._link.addAll(child._link);
                }
                if (child._dashboard != null) {
                    this._dashboard.addAll(child._dashboard);
                }
            }
        }
    }

    public static class RuleLinkProperty
    extends RuleProperty {
        protected ArrayList<AddFlagEnumeration> _addFlag = new ArrayList();
        protected ToProperty _toProperty;

        public ArrayList<AddFlagEnumeration> getAddFlag() {
            return this._addFlag;
        }

        public void setAddFlag(ArrayList<AddFlagEnumeration> value) {
            this._addFlag = value;
        }

        public ToProperty getTo() {
            return this._toProperty;
        }

        public void setTo(ToProperty value) {
            if (this._toProperty != null) {
                this._toProperty.merge(value);
            } else {
                this._toProperty = value;
            }
        }

        protected void copy(RuleLinkProperty instance) {
            this._addFlag.addAll(instance._addFlag);
            this._code = instance._code;
            this._toProperty = instance._toProperty;
            this._listenProperty = instance._listenProperty;
        }

        protected void merge(RuleLinkProperty child) {
            super.merge(child);
            if (child._addFlag != null) {
                this._addFlag.addAll(child._addFlag);
            }
            if (this._toProperty == null) {
                this._toProperty = child._toProperty;
            } else if (child._toProperty != null) {
                this._toProperty.merge(child._toProperty);
            }
        }

        public static class ToProperty {
            protected ArrayList<Ref> _link = new ArrayList();

            public ArrayList<Ref> getLink() {
                return this._link;
            }

            public void setLink(ArrayList<Ref> value) {
                this._link = value;
            }

            protected void copy(ToProperty instance) {
                this._link.addAll(instance._link);
            }

            protected void merge(ToProperty child) {
                if (child._link != null) {
                    this._link.addAll(child._link);
                }
            }
        }

        public static enum AddFlagEnumeration {
            HIDDEN;

        }
    }
}

