/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DesktopDefinitionTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("desktopdefinition")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("module", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("module", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport org.monet.space.kernel.model.Source;\nimport org.monet.space.kernel.model.Node;\nimport io.intino.goros.unit.util.AccountHelper;\nimport io.intino.goros.unit.util.LayerHelper;\n\nimport java.util.List;\n\npublic class ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template extends Abstract")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private Node node;\n    private boolean readonly = false;\n\n    public ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void open(String code, boolean readonly) {\n        node(LayerHelper.nodeLayer().locateNode(code));\n        readonly(readonly);\n        refresh();\n    }\n\n    public void open(String id, String view, boolean readonly) {\n        node(LayerHelper.nodeLayer().loadNode(id));\n        readonly(readonly);\n        refresh();\n    }\n\n    public ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template node(Node node) {\n        this.node = node;\n        return this;\n    }\n\n    public ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template readonly(boolean value) {\n        this.readonly = value;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        initToolbar();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshToolbar();\n        refreshLabels();\n    }\n\n    private void initToolbar() {\n        ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("toolbar", "editableInitCall"))).output(Outputs.literal("\n    }\n\n    private void refreshToolbar() {\n        ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("toolbar", "editableRefreshCall"))).output(Outputs.literal("\n    }\n\n    private void refreshLabels() {\n        loading.visible(true);\n        labels.visible(false);\n        ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("view", "refreshCall").multiple("\n"))).output(Outputs.literal("\n        loading.visible(false);\n        labels.visible(true);\n    }\n\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("view", "refreshMethod").multiple("\n"))).output(Outputs.literal("\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("toolbar", "editableMethods"))).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("nodeview"), (LogicalExpression)Predicates.trigger("refreshcall"))).output(Outputs.placeholder("show", "refreshCall")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("nodeview"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.placeholder("show", "refreshMethod")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("show"), (LogicalExpression)Predicates.trigger("refreshcall"))).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("item", "refreshCall").multiple("\n"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("show"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("item", "refreshMethod").multiple("\n"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("item"), (LogicalExpression)Predicates.trigger("refreshcall"))).output(Outputs.literal("refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("item", "thesaurus"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("private void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("() {\n    Source<?> source = io.intino.goros.unit.util.SourceHelper.locateSource(\"")).output(Outputs.placeholder("code", new String[0])).output(Outputs.literal("\");\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal(".visible(source != null);\n    if (source == null) return;\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Link.address(path -> path.replace(\":name\", \"")).output(Outputs.placeholder("name", "lowerCase")).output(Outputs.literal("\"));\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Link.title(source.getLabel());\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("item"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("private void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("() {\n    Node node = io.intino.goros.unit.util.NodeHelper.singleton(\"")).output(Outputs.placeholder("code", new String[0])).output(Outputs.literal("\");\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal(".visible(node != null && AccountHelper.hasRoles(node.getDefinition(), session()));\n    if (node == null) return;\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Link.address(path -> path.replace(\":name\", \"")).output(Outputs.placeholder("name", "lowerCase")).output(Outputs.literal("\").replace(\":mode\", readonly ? \"default\" : \"edit\"));\n    ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Link.title(node.getLabel());\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("toolbar"), (LogicalExpression)Predicates.trigger("editableinitcall"))).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("operationsGroup", "editableInitCall"))).output(Outputs.literal("\n")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("operation", "editableInitCall").multiple("\n"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("operation"), (LogicalExpression)Predicates.trigger("executemethodcall"))).output(Outputs.literal("if (option.equals(\"")).output(Outputs.placeholder("label", new String[0])).output(Outputs.literal("\")) io.intino.goros.unit.util.NodeHelper.executeOperation(session(), operaciones, node, \"")).output(Outputs.placeholder("name", new String[0])).output(Outputs.literal("\", translate(\"Operation executed\"), box().routeManager().routeDispatcher());")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

