/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.EntityDefinition;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class DatastoreDefinitionBase
extends EntityDefinition {
    protected IsExternalFed _isExternalFed;
    protected LinkedHashMap<String, DimensionProperty> _dimensionPropertyMap = new LinkedHashMap();
    protected LinkedHashMap<String, CubeProperty> _cubePropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return DefinitionType.datastore;
    }

    public boolean isExternalFed() {
        return this._isExternalFed != null;
    }

    public IsExternalFed getIsExternalFed() {
        return this._isExternalFed;
    }

    public void setIsExternalFed(boolean value) {
        this._isExternalFed = value ? new IsExternalFed() : null;
    }

    public void addDimension(DimensionProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        DimensionProperty current = this._dimensionPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    DimensionProperty instance = (DimensionProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._dimensionPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._dimensionPropertyMap.put(key, value);
        }
    }

    public Map<String, DimensionProperty> getDimensionMap() {
        return this._dimensionPropertyMap;
    }

    public Collection<DimensionProperty> getDimensionList() {
        return this._dimensionPropertyMap.values();
    }

    public void addCube(CubeProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        CubeProperty current = this._cubePropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    CubeProperty instance = (CubeProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._cubePropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._cubePropertyMap.put(key, value);
        }
    }

    public Map<String, CubeProperty> getCubeMap() {
        return this._cubePropertyMap;
    }

    public Collection<CubeProperty> getCubeList() {
        return this._cubePropertyMap.values();
    }

    public void copy(DatastoreDefinitionBase instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        this._isExternalFed = instance._isExternalFed;
        for (DimensionProperty dimensionProperty : instance._dimensionPropertyMap.values()) {
            this.addDimension(dimensionProperty);
        }
        for (CubeProperty cubeProperty : instance._cubePropertyMap.values()) {
            this.addCube(cubeProperty);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(DatastoreDefinitionBase child) {
        super.merge(child);
        if (this._isExternalFed == null) {
            this._isExternalFed = child._isExternalFed;
        } else if (child._isExternalFed != null) {
            this._isExternalFed.merge(child._isExternalFed);
        }
        for (DimensionProperty dimensionProperty : child._dimensionPropertyMap.values()) {
            this.addDimension(dimensionProperty);
        }
        for (CubeProperty cubeProperty : child._cubePropertyMap.values()) {
            this.addCube(cubeProperty);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return DatastoreDefinitionBase.class;
    }

    public static class IsExternalFed {
        protected void copy(IsExternalFed instance) {
        }

        protected void merge(IsExternalFed child) {
        }
    }

    public static class DimensionProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected String _ontology;
        protected LinkedHashMap<String, FeatureProperty> _featurePropertyMap = new LinkedHashMap();

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public String getOntology() {
            return this._ontology;
        }

        public void setOntology(String value) {
            this._ontology = value;
        }

        public void addFeature(FeatureProperty value) {
            String key = value.getName() != null ? value.getName() : value.getCode();
            FeatureProperty current = this._featurePropertyMap.get(key);
            if (current != null) {
                if (current.getClass().isAssignableFrom(value.getClass())) {
                    try {
                        FeatureProperty instance = (FeatureProperty)value.getClass().newInstance();
                        instance.copy(current);
                        instance.setCode(value.getCode());
                        instance.setName(value.getName());
                        instance.merge(value);
                        this._featurePropertyMap.put(key, instance);
                    }
                    catch (Exception exception) {}
                } else {
                    current.merge(value);
                }
            } else {
                this._featurePropertyMap.put(key, value);
            }
        }

        public Map<String, FeatureProperty> getFeatureMap() {
            return this._featurePropertyMap;
        }

        public Collection<FeatureProperty> getFeatureList() {
            return this._featurePropertyMap.values();
        }

        protected void copy(DimensionProperty instance) {
            this._label = instance._label;
            this._ontology = instance._ontology;
            this._code = instance._code;
            this._name = instance._name;
            for (FeatureProperty item : instance._featurePropertyMap.values()) {
                this.addFeature(item);
            }
        }

        protected void merge(DimensionProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._ontology != null) {
                this._ontology = child._ontology;
            }
            for (FeatureProperty item : child._featurePropertyMap.values()) {
                this.addFeature(item);
            }
        }

        public static class FeatureProperty
        extends ReferenceableProperty {
            protected Object _label;
            protected TypeEnumeration _type;
            protected Ref _source;

            public Object getLabel() {
                return this._label;
            }

            public void setLabel(Object value) {
                this._label = value;
            }

            public TypeEnumeration getType() {
                return this._type;
            }

            public void setType(TypeEnumeration value) {
                this._type = value;
            }

            public Ref getSource() {
                return this._source;
            }

            public void setSource(Ref value) {
                this._source = value;
            }

            protected void copy(FeatureProperty instance) {
                this._label = instance._label;
                this._type = instance._type;
                this._source = instance._source;
                this._code = instance._code;
                this._name = instance._name;
            }

            protected void merge(FeatureProperty child) {
                super.merge(child);
                if (child._label != null) {
                    this._label = child._label;
                }
                if (child._type != null) {
                    this._type = child._type;
                }
                if (child._source != null) {
                    this._source = child._source;
                }
            }

            public static enum TypeEnumeration {
                STRING,
                TERM,
                BOOLEAN,
                INTEGER,
                REAL;

            }
        }
    }

    public static class CubeProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected ResolutionEnumeration _resolution;
        protected ArrayList<Ref> _use = new ArrayList();
        protected LinkedHashMap<String, MetricProperty> _metricPropertyMap = new LinkedHashMap();

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public ResolutionEnumeration getResolution() {
            return this._resolution;
        }

        public void setResolution(ResolutionEnumeration value) {
            this._resolution = value;
        }

        public ArrayList<Ref> getUse() {
            return this._use;
        }

        public void setUse(ArrayList<Ref> value) {
            this._use = value;
        }

        public void addMetric(MetricProperty value) {
            String key = value.getName() != null ? value.getName() : value.getCode();
            MetricProperty current = this._metricPropertyMap.get(key);
            if (current != null) {
                if (current.getClass().isAssignableFrom(value.getClass())) {
                    try {
                        MetricProperty instance = (MetricProperty)value.getClass().newInstance();
                        instance.copy(current);
                        instance.setCode(value.getCode());
                        instance.setName(value.getName());
                        instance.merge(value);
                        this._metricPropertyMap.put(key, instance);
                    }
                    catch (Exception exception) {}
                } else {
                    current.merge(value);
                }
            } else {
                this._metricPropertyMap.put(key, value);
            }
        }

        public Map<String, MetricProperty> getMetricMap() {
            return this._metricPropertyMap;
        }

        public Collection<MetricProperty> getMetricList() {
            return this._metricPropertyMap.values();
        }

        protected void copy(CubeProperty instance) {
            this._label = instance._label;
            this._resolution = instance._resolution;
            this._use.addAll(instance._use);
            this._code = instance._code;
            this._name = instance._name;
            for (MetricProperty item : instance._metricPropertyMap.values()) {
                this.addMetric(item);
            }
        }

        protected void merge(CubeProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._resolution != null) {
                this._resolution = child._resolution;
            }
            if (child._use != null) {
                this._use.addAll(child._use);
            }
            for (MetricProperty item : child._metricPropertyMap.values()) {
                this.addMetric(item);
            }
        }

        public static enum ResolutionEnumeration {
            YEARS,
            MONTHS,
            DAYS,
            HOURS,
            MINUTES,
            SECONDS;

        }

        public static class MetricProperty
        extends ReferenceableProperty {
            protected Object _label;
            protected Ref _scale;

            public Object getLabel() {
                return this._label;
            }

            public void setLabel(Object value) {
                this._label = value;
            }

            public Ref getScale() {
                return this._scale;
            }

            public void setScale(Ref value) {
                this._scale = value;
            }

            protected void copy(MetricProperty instance) {
                this._label = instance._label;
                this._scale = instance._scale;
                this._code = instance._code;
                this._name = instance._name;
            }

            protected void merge(MetricProperty child) {
                super.merge(child);
                if (child._label != null) {
                    this._label = child._label;
                }
                if (child._scale != null) {
                    this._scale = child._scale;
                }
            }
        }
    }
}

