/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers;

import io.intino.goros.modernizing.monet.util.StringUtil;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.CompositeFieldPropertyBase;
import org.monet.metamodel.ContainerDefinitionBase;
import org.monet.metamodel.Definition;
import org.monet.metamodel.DesktopDefinitionBase;
import org.monet.metamodel.FormDefinitionBase;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.ProcessDefinitionBase;
import org.monet.metamodel.SetDefinition;
import org.monet.metamodel.SetDefinitionBase;
import org.monet.metamodel.ViewProperty;

public class RendererHelper {
    public static String nameOf(Definition definition, String basePackage) {
        String prefix = RendererHelper.prefixOf(definition, basePackage);
        String name = definition.getName();
        name = name.contains(".") ? name.substring(name.lastIndexOf(".") + 1) : name;
        return prefix + name;
    }

    private static String prefixOf(Definition definition, String basePackage) {
        String prefix = definition.getName();
        if (!prefix.contains(".")) {
            return "";
        }
        prefix = prefix.substring(0, prefix.lastIndexOf("."));
        prefix = prefix.replace(basePackage + ".", "").replace(basePackage, "").replace(".", "-");
        return StringUtil.snakeCaseToCamelCase(prefix);
    }

    public static String nameOf(IndexDefinitionBase.IndexViewProperty viewProperty) {
        return RendererHelper.nameOf(viewProperty, viewProperty.getName());
    }

    public static String nameOf(NodeViewProperty viewProperty) {
        return RendererHelper.nameOf(viewProperty, RendererHelper.normalize(RendererHelper.labelOf(viewProperty)));
    }

    public static String nameOf(ProcessDefinitionBase.ViewProperty viewProperty) {
        return RendererHelper.nameOf(viewProperty, RendererHelper.normalize(RendererHelper.labelOf(viewProperty)));
    }

    public static String nameOf(ViewProperty viewProperty, String label) {
        String name = viewProperty.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return RendererHelper.normalize(label != null ? label : viewProperty.getCode());
    }

    public static String shortName(String snakeName) {
        return Arrays.stream(snakeName.split("-")).map(RendererHelper::initials).collect(Collectors.joining("-"));
    }

    public static String initials(String name) {
        String initials = name.replaceAll("[a-z]", "");
        if (!initials.isEmpty()) {
            return initials;
        }
        return name.length() > 2 ? name.substring(0, 3) : name;
    }

    public static String labelOf(NodeViewProperty viewProperty) {
        return RendererHelper.labelOf((String)viewProperty.getLabel(), viewProperty.getName());
    }

    public static String labelOf(ProcessDefinitionBase.ViewProperty viewProperty) {
        return RendererHelper.labelOf((String)viewProperty.getLabel(), viewProperty.getName());
    }

    public static String labelOf(String label, String name) {
        return label != null && !label.isEmpty() ? label : name;
    }

    public static String normalize(String name) {
        if (name == null) {
            return null;
        }
        name = name.replace("/", "-").replace(" ", "-").replace("_", "-");
        return StringUtil.stripAccents(StringUtil.firstUpperCase(StringUtil.snakeCaseToCamelCase(name)));
    }

    public static String typeOf(NodeViewProperty viewProperty) {
        if (viewProperty instanceof DesktopDefinitionBase.ViewProperty) {
            return RendererHelper.typeOf(((DesktopDefinitionBase.ViewProperty)viewProperty).getShow());
        }
        if (viewProperty instanceof SetDefinition.SetViewProperty) {
            return RendererHelper.typeOf(((SetDefinition.SetViewProperty)viewProperty).getShow());
        }
        if (viewProperty instanceof ContainerDefinitionBase.ViewProperty) {
            return RendererHelper.typeOf(((ContainerDefinitionBase.ViewProperty)viewProperty).getShow());
        }
        if (viewProperty instanceof FormDefinitionBase.FormViewProperty) {
            return RendererHelper.typeOf(((FormDefinitionBase.FormViewProperty)viewProperty).getShow());
        }
        return null;
    }

    public static String typeOf(DesktopDefinitionBase.ViewProperty.ShowProperty showProperty) {
        if (showProperty.getLink().size() > 0) {
            return "links";
        }
        if (showProperty.getDashboard().size() > 0) {
            return "dashboards";
        }
        return null;
    }

    public static String typeOf(SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty) {
        if (showProperty.getIndex() != null) {
            return "index";
        }
        if (showProperty.getItems() != null) {
            return "items";
        }
        if (showProperty.getOwnedPrototypes() != null) {
            return "ownedprototypes";
        }
        if (showProperty.getSharedPrototypes() != null) {
            return "sharedprototypes";
        }
        if (showProperty.getLocations() != null) {
            return "locations";
        }
        if (showProperty.getReport() != null) {
            return "report";
        }
        return null;
    }

    public static String typeOf(ContainerDefinitionBase.ViewProperty.ShowProperty showProperty) {
        if (showProperty.getLinksIn() != null) {
            return "linksin";
        }
        if (showProperty.getLinksOut() != null) {
            return "linksout";
        }
        if (showProperty.getLocation() != null) {
            return "location";
        }
        if (showProperty.getNotes() != null) {
            return "notes";
        }
        if (showProperty.getRecentTask() != null) {
            return "recenttask";
        }
        if (showProperty.getRevisions() != null) {
            return "revisions";
        }
        if (showProperty.getTasks() != null) {
            return "tasks";
        }
        if (showProperty.getComponent().size() > 0) {
            return "components";
        }
        return null;
    }

    public static String typeOf(FormDefinitionBase.FormViewProperty.ShowProperty showProperty) {
        if (showProperty.getNotes() != null) {
            return "notes";
        }
        if (showProperty.getField().size() > 0) {
            return "fields";
        }
        if (showProperty.getAttachments() != null) {
            return "attachments";
        }
        if (showProperty.getRecentTask() != null) {
            return "recenttask";
        }
        if (showProperty.getLayout() != null) {
            return "layout";
        }
        if (showProperty.getLayoutExtended() != null) {
            return "layoutextended";
        }
        if (showProperty.getLinksIn() != null) {
            return "linksin";
        }
        if (showProperty.getLinksOut() != null) {
            return "linksout";
        }
        if (showProperty.getLocation() != null) {
            return "location";
        }
        if (showProperty.getRevisions() != null) {
            return "revisions";
        }
        if (showProperty.getTasks() != null) {
            return "tasks";
        }
        return null;
    }

    public static String typeOf(CompositeFieldPropertyBase.ViewProperty.ShowProperty showProperty) {
        if (showProperty == null || showProperty.getField().size() > 0) {
            return "fields";
        }
        if (showProperty.getLayout() != null) {
            return "layout";
        }
        return null;
    }

    public static String attributeTypeOf(AttributeProperty attributeProperty) {
        AttributeProperty.TypeEnumeration type = attributeProperty.getType();
        if (type == AttributeProperty.TypeEnumeration.DATE) {
            return "Date";
        }
        if (type == AttributeProperty.TypeEnumeration.PICTURE) {
            return "Image";
        }
        if (type == AttributeProperty.TypeEnumeration.INTEGER || type == AttributeProperty.TypeEnumeration.REAL) {
            return "Number";
        }
        return "Text";
    }

    public static String dimensionTypeOf(AttributeProperty attributeProperty) {
        AttributeProperty.TypeEnumeration type = attributeProperty.getType();
        if (type == AttributeProperty.TypeEnumeration.DATE) {
            return "DateRange";
        }
        if (type == AttributeProperty.TypeEnumeration.BOOLEAN) {
            return "Check";
        }
        return "Combo";
    }

    public static String dimensionPatternOf(AttributeProperty attributeProperty) {
        AttributeProperty.TypeEnumeration type = attributeProperty.getType();
        if (type != AttributeProperty.TypeEnumeration.DATE) {
            return null;
        }
        AttributeProperty.PrecisionEnumeration precision = attributeProperty.getPrecision();
        if (precision == null) {
            return "DD/MM/YYYY";
        }
        if (precision == AttributeProperty.PrecisionEnumeration.YEARS) {
            return "YYYY";
        }
        if (precision == AttributeProperty.PrecisionEnumeration.MONTHS) {
            return "MM/YYYY";
        }
        if (precision == AttributeProperty.PrecisionEnumeration.DAYS) {
            return "DD/MM/YYYY";
        }
        if (precision == AttributeProperty.PrecisionEnumeration.HOURS) {
            return "DD/MM/YYYY HH";
        }
        if (precision == AttributeProperty.PrecisionEnumeration.MINUTES) {
            return "DD/MM/YYYY HH:mm";
        }
        return "DD/MM/YYYY HH:mm:ss";
    }

    public static int countAttributes(IndexDefinitionBase.IndexViewProperty viewProperty) {
        IndexDefinitionBase.IndexViewProperty.ShowProperty show = viewProperty.getShow();
        int count = 0;
        if (show.getTitle() != null) {
            ++count;
        }
        if (show.getPicture() != null) {
            ++count;
        }
        if (show.getIcon() != null) {
            ++count;
        }
        count += show.getHighlight().size();
        count += show.getLine().size();
        count += show.getLineBelow().size();
        return count += show.getFooter().size();
    }
}

