/*
 * Decompiled with CFR 0.152.
 */
package org.monet.space.kernel.bpi.java.locator;

import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class PackageReader {
    private String packagePath;
    private Set<String> classnames;

    public PackageReader(String classpathRoot) {
        this.packagePath = classpathRoot;
    }

    public Set<String> read() {
        Logger.info("Reading classes in businessmodel");
        this.loadClassNames(this.packagePath);
        Logger.info("Number of classes found: " + this.classnames.size());
        return this.classnames;
    }

    private void loadClassNames(String packagePath) {
        this.classnames = new HashSet<String>();
        File directory = new File(packagePath);
        this.readDirectory(directory);
    }

    private void readDirectory(File dir) {
        File[] filenames = dir.listFiles(file -> file.isDirectory() && !file.getName().startsWith(".") || file.getName().endsWith(".class"));
        if (filenames == null) {
            Logger.error("Could not read directory " + dir.getAbsolutePath());
            return;
        }
        for (File filename : filenames) {
            if (filename.isFile()) {
                this.classnames.add(PackageReader.toPackageName(filename.getAbsolutePath(), this.packagePath));
                continue;
            }
            this.readDirectory(filename);
        }
    }

    private static String toPackageName(String absolutePath, String packagePath) {
        String result = absolutePath.replace(packagePath, "");
        return (result = result.replace("\\", "##").replace("/", "##").replace(".class", "").replace("##", ".")).startsWith(".") ? result.substring(1) : result;
    }
}

