/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.EntityDefinition;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class KpiDefinition
extends EntityDefinition {
    protected LinkedHashMap<String, ParameterProperty> _parameterPropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return null;
    }

    public void addParameter(ParameterProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ParameterProperty current = this._parameterPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    ParameterProperty instance = (ParameterProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._parameterPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._parameterPropertyMap.put(key, value);
        }
    }

    public Map<String, ParameterProperty> getParameterMap() {
        return this._parameterPropertyMap;
    }

    public Collection<ParameterProperty> getParameterList() {
        return this._parameterPropertyMap.values();
    }

    public void copy(KpiDefinition instance) {
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        for (ParameterProperty item : instance._parameterPropertyMap.values()) {
            this.addParameter(item);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(KpiDefinition child) {
        super.merge(child);
        for (ParameterProperty item : child._parameterPropertyMap.values()) {
            this.addParameter(item);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return KpiDefinition.class;
    }

    public static class ParameterProperty
    extends ReferenceableProperty {
        protected Long _historic;
        protected Ref _indicator;
        protected Ref _feature;
        protected Ref _kpi;

        public Long getHistoric() {
            return this._historic;
        }

        public void setHistoric(Long value) {
            this._historic = value;
        }

        public Ref getIndicator() {
            return this._indicator;
        }

        public void setIndicator(Ref value) {
            this._indicator = value;
        }

        public Ref getFeature() {
            return this._feature;
        }

        public void setFeature(Ref value) {
            this._feature = value;
        }

        public Ref getKpi() {
            return this._kpi;
        }

        public void setKpi(Ref value) {
            this._kpi = value;
        }

        protected void copy(ParameterProperty instance) {
            this._historic = instance._historic;
            this._indicator = instance._indicator;
            this._feature = instance._feature;
            this._kpi = instance._kpi;
            this._code = instance._code;
            this._name = instance._name;
        }

        protected void merge(ParameterProperty child) {
            super.merge(child);
            if (child._historic != null) {
                this._historic = child._historic;
            }
            if (child._indicator != null) {
                this._indicator = child._indicator;
            }
            if (child._feature != null) {
                this._feature = child._feature;
            }
            if (child._kpi != null) {
                this._kpi = child._kpi;
            }
        }
    }
}

