/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.monet.metamodel.EntityDefinition;
import org.monet.metamodel.ReferenceableProperty;
import org.monet.metamodel.internal.Ref;
import org.monet.space.kernel.model.DefinitionType;

public class CubeDefinitionBase
extends EntityDefinition {
    protected ResolutionEnumeration _resolution;
    protected ArrayList<Ref> _dimension = new ArrayList();
    protected LinkedHashMap<String, MeasureProperty> _measurePropertyMap = new LinkedHashMap();
    protected LinkedHashMap<String, IndicatorProperty> _indicatorPropertyMap = new LinkedHashMap();
    protected LinkedHashMap<String, ViewProperty> _viewPropertyMap = new LinkedHashMap();

    @Override
    public DefinitionType getType() {
        return DefinitionType.cube;
    }

    public ResolutionEnumeration getResolution() {
        return this._resolution;
    }

    public void setResolution(ResolutionEnumeration value) {
        this._resolution = value;
    }

    public ArrayList<Ref> getDimension() {
        return this._dimension;
    }

    public void setDimension(ArrayList<Ref> value) {
        this._dimension = value;
    }

    public void addMeasure(MeasureProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        MeasureProperty current = this._measurePropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    MeasureProperty instance = (MeasureProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._measurePropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._measurePropertyMap.put(key, value);
        }
    }

    public Map<String, MeasureProperty> getMeasureMap() {
        return this._measurePropertyMap;
    }

    public Collection<MeasureProperty> getMeasureList() {
        return this._measurePropertyMap.values();
    }

    public void addIndicator(IndicatorProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        IndicatorProperty current = this._indicatorPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    IndicatorProperty instance = (IndicatorProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._indicatorPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._indicatorPropertyMap.put(key, value);
        }
    }

    public Map<String, IndicatorProperty> getIndicatorMap() {
        return this._indicatorPropertyMap;
    }

    public Collection<IndicatorProperty> getIndicatorList() {
        return this._indicatorPropertyMap.values();
    }

    public void addView(ViewProperty value) {
        String key = value.getName() != null ? value.getName() : value.getCode();
        ViewProperty current = this._viewPropertyMap.get(key);
        if (current != null) {
            if (current.getClass().isAssignableFrom(value.getClass())) {
                try {
                    ViewProperty instance = (ViewProperty)value.getClass().newInstance();
                    instance.copy(current);
                    instance.setCode(value.getCode());
                    instance.setName(value.getName());
                    instance.merge(value);
                    this._viewPropertyMap.put(key, instance);
                }
                catch (Exception exception) {}
            } else {
                current.merge(value);
            }
        } else {
            this._viewPropertyMap.put(key, value);
        }
    }

    public Map<String, ViewProperty> getViewMap() {
        return this._viewPropertyMap;
    }

    public Collection<ViewProperty> getViewList() {
        return this._viewPropertyMap.values();
    }

    public void copy(CubeDefinitionBase instance) {
        this._resolution = instance._resolution;
        this._dimension.addAll(instance._dimension);
        this._code = instance._code;
        this._name = instance._name;
        this._parent = instance._parent;
        this._label = instance._label;
        this._description = instance._description;
        this._help = instance._help;
        for (MeasureProperty measureProperty : instance._measurePropertyMap.values()) {
            this.addMeasure(measureProperty);
        }
        for (IndicatorProperty indicatorProperty : instance._indicatorPropertyMap.values()) {
            this.addIndicator(indicatorProperty);
        }
        for (ViewProperty viewProperty : instance._viewPropertyMap.values()) {
            this.addView(viewProperty);
        }
        this._isAbstract = instance._isAbstract;
    }

    public void merge(CubeDefinitionBase child) {
        super.merge(child);
        if (child._resolution != null) {
            this._resolution = child._resolution;
        }
        if (child._dimension != null) {
            this._dimension.addAll(child._dimension);
        }
        for (MeasureProperty measureProperty : child._measurePropertyMap.values()) {
            this.addMeasure(measureProperty);
        }
        for (IndicatorProperty indicatorProperty : child._indicatorPropertyMap.values()) {
            this.addIndicator(indicatorProperty);
        }
        for (ViewProperty viewProperty : child._viewPropertyMap.values()) {
            this.addView(viewProperty);
        }
    }

    @Override
    public Class<?> getMetamodelClass() {
        return CubeDefinitionBase.class;
    }

    public static enum ResolutionEnumeration {
        MONTHS,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS;

    }

    public static class MeasureProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected Ref _metric;

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public Ref getMetric() {
            return this._metric;
        }

        public void setMetric(Ref value) {
            this._metric = value;
        }

        protected void copy(MeasureProperty instance) {
            this._label = instance._label;
            this._metric = instance._metric;
            this._code = instance._code;
            this._name = instance._name;
        }

        protected void merge(MeasureProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._metric != null) {
                this._metric = child._metric;
            }
        }
    }

    public static class IndicatorProperty
    extends ReferenceableProperty {
        protected Object _label;
        protected Ref _measure;
        protected Ref _metric;
        protected InterpolationEnumeration _interpolation;
        protected OperatorEnumeration _operator;
        protected ChartEnumeration _chart;
        protected AlertEnumeration _alert;

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public Ref getMeasure() {
            return this._measure;
        }

        public void setMeasure(Ref value) {
            this._measure = value;
        }

        public Ref getMetric() {
            return this._metric;
        }

        public void setMetric(Ref value) {
            this._metric = value;
        }

        public InterpolationEnumeration getInterpolation() {
            return this._interpolation;
        }

        public void setInterpolation(InterpolationEnumeration value) {
            this._interpolation = value;
        }

        public OperatorEnumeration getOperator() {
            return this._operator;
        }

        public void setOperator(OperatorEnumeration value) {
            this._operator = value;
        }

        public ChartEnumeration getChart() {
            return this._chart;
        }

        public void setChart(ChartEnumeration value) {
            this._chart = value;
        }

        public AlertEnumeration getAlert() {
            return this._alert;
        }

        public void setAlert(AlertEnumeration value) {
            this._alert = value;
        }

        protected void copy(IndicatorProperty instance) {
            this._label = instance._label;
            this._measure = instance._measure;
            this._metric = instance._metric;
            this._interpolation = instance._interpolation;
            this._operator = instance._operator;
            this._chart = instance._chart;
            this._alert = instance._alert;
            this._code = instance._code;
            this._name = instance._name;
        }

        protected void merge(IndicatorProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (child._measure != null) {
                this._measure = child._measure;
            }
            if (child._metric != null) {
                this._metric = child._metric;
            }
            if (child._interpolation != null) {
                this._interpolation = child._interpolation;
            }
            if (child._operator != null) {
                this._operator = child._operator;
            }
            if (child._chart != null) {
                this._chart = child._chart;
            }
            if (child._alert != null) {
                this._alert = child._alert;
            }
        }

        public static enum InterpolationEnumeration {
            LEFT_STEP,
            MIDDLE_STEP,
            RIGHT_STEP,
            LINEAR;

        }

        public static enum OperatorEnumeration {
            SUM,
            COUNT,
            AVERAGE,
            DEVIATION,
            INTEGRAL;

        }

        public static enum ChartEnumeration {
            BOTTOM,
            BASE,
            TOP;

        }

        public static enum AlertEnumeration {
            INCREASE,
            DECREASE;

        }
    }

    public static class ViewProperty
    extends org.monet.metamodel.ViewProperty {
        protected Object _label;
        protected IsDefault _isDefault;
        protected ForProperty _forProperty;
        protected ShowProperty _showProperty;

        public Object getLabel() {
            return this._label;
        }

        public void setLabel(Object value) {
            this._label = value;
        }

        public boolean isDefault() {
            return this._isDefault != null;
        }

        public IsDefault getIsDefault() {
            return this._isDefault;
        }

        public void setIsDefault(boolean value) {
            this._isDefault = value ? new IsDefault() : null;
        }

        public ForProperty getFor() {
            return this._forProperty;
        }

        public void setFor(ForProperty value) {
            if (this._forProperty != null) {
                this._forProperty.merge(value);
            } else {
                this._forProperty = value;
            }
        }

        public ShowProperty getShow() {
            return this._showProperty;
        }

        public void setShow(ShowProperty value) {
            if (this._showProperty != null) {
                this._showProperty.merge(value);
            } else {
                this._showProperty = value;
            }
        }

        protected void copy(ViewProperty instance) {
            this._label = instance._label;
            this._code = instance._code;
            this._name = instance._name;
            this._isDefault = instance._isDefault;
            this._forProperty = instance._forProperty;
            this._showProperty = instance._showProperty;
        }

        protected void merge(ViewProperty child) {
            super.merge(child);
            if (child._label != null) {
                this._label = child._label;
            }
            if (this._isDefault == null) {
                this._isDefault = child._isDefault;
            } else if (child._isDefault != null) {
                this._isDefault.merge(child._isDefault);
            }
            if (this._forProperty == null) {
                this._forProperty = child._forProperty;
            } else if (child._forProperty != null) {
                this._forProperty.merge(child._forProperty);
            }
            if (this._showProperty == null) {
                this._showProperty = child._showProperty;
            } else if (child._showProperty != null) {
                this._showProperty.merge(child._showProperty);
            }
        }

        public static class IsDefault {
            protected void copy(IsDefault instance) {
            }

            protected void merge(IsDefault child) {
            }
        }

        public static class ForProperty {
            protected Ref _role;

            public Ref getRole() {
                return this._role;
            }

            public void setRole(Ref value) {
                this._role = value;
            }

            protected void copy(ForProperty instance) {
                this._role = instance._role;
            }

            protected void merge(ForProperty child) {
                if (child._role != null) {
                    this._role = child._role;
                }
            }
        }

        public static class ShowProperty {
            protected ArrayList<Ref> _indicator = new ArrayList();
            protected ScaleEnumeration _scale;

            public ArrayList<Ref> getIndicator() {
                return this._indicator;
            }

            public void setIndicator(ArrayList<Ref> value) {
                this._indicator = value;
            }

            public ScaleEnumeration getScale() {
                return this._scale;
            }

            public void setScale(ScaleEnumeration value) {
                this._scale = value;
            }

            protected void copy(ShowProperty instance) {
                this._indicator.addAll(instance._indicator);
                this._scale = instance._scale;
            }

            protected void merge(ShowProperty child) {
                if (child._indicator != null) {
                    this._indicator.addAll(child._indicator);
                }
                if (child._scale != null) {
                    this._scale = child._scale;
                }
            }

            public static enum ScaleEnumeration {
                YEAR,
                MONTH,
                DAY,
                HOUR,
                MINUTE,
                SECOND;

            }
        }
    }
}

