/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.Formatters;
import io.intino.goros.modernizing.monet.renderers.RendererHelper;
import io.intino.goros.modernizing.monet.renderers.definition.NodeRenderer;
import io.intino.goros.modernizing.monet.renderers.templates.java.SetTemplate;
import io.intino.goros.modernizing.monet.util.StringUtil;
import io.intino.itrules.Engine;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.monet.metamodel.AttributeProperty;
import org.monet.metamodel.Definition;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.NodeViewProperty;
import org.monet.metamodel.SetDefinition;
import org.monet.metamodel.SetDefinitionBase;
import org.monet.metamodel.internal.DescriptorDefinition;
import org.monet.metamodel.internal.Ref;

public abstract class SetRenderer<D extends SetDefinition>
extends NodeRenderer<D> {
    private static final int LineHeight = 10;

    public SetRenderer(Dictionary dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public void write() {
        FrameBuilder builder = this.buildFrame();
        this.writeJava(builder);
        this.writeKonos(builder);
        this.writeEmbeddedTemplate();
        this.writeViewsTemplate();
        this.writeFiltersTemplates();
    }

    @Override
    protected FrameBuilder buildFrame() {
        return super.buildFrame().add("setdefinition");
    }

    @Override
    protected boolean isVisibleOnRevision(NodeViewProperty viewProperty) {
        return false;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.monet.renderers.templates.konos.SetTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new SetTemplate();
    }

    @Override
    protected FrameBuilder viewFrame(NodeViewProperty viewProperty) {
        FrameBuilder result = this.baseViewFrame(viewProperty).add("collectionview");
        result.add("materialIcon", this.materialIcon(viewProperty));
        result.add("height", this.calculateHeight((SetDefinition.SetViewProperty)viewProperty));
        this.addFacets((SetDefinition.SetViewProperty)viewProperty, result);
        this.addShow((SetDefinition.SetViewProperty)viewProperty, result);
        this.addAttributes((SetDefinition.SetViewProperty)viewProperty, result);
        this.addAnalyze((SetDefinition.SetViewProperty)viewProperty, result);
        return result;
    }

    protected void addFacets(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.LocationsProperty locations = viewProperty.getShow().getLocations();
        if (locations == null) {
            return;
        }
        if (locations.getLayer() == SetDefinitionBase.SetViewPropertyBase.ShowProperty.LocationsProperty.LayerEnumeration.HEAT) {
            builder.add("heatmap", "Heatmap");
        } else {
            builder.add("clustermap", "Cluster");
        }
    }

    private int calculateHeight(SetDefinition.SetViewProperty viewProperty) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty show = viewProperty.getShow();
        if (show.getItems() != null) {
            return 50;
        }
        if (show.getIndex() != null) {
            return this.calculateIndexHeight(viewProperty);
        }
        if (show.getLocations() != null) {
            return this.calculateLocationsHeight(viewProperty);
        }
        return 124;
    }

    private int calculateIndexHeight(SetDefinition.SetViewProperty viewProperty) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty index = viewProperty.getShow().getIndex();
        return this.calculateAttributesHeight(viewProperty, index.getWithView(), false);
    }

    private int calculateLocationsHeight(SetDefinition.SetViewProperty viewProperty) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.LocationsProperty locations = viewProperty.getShow().getLocations();
        return this.calculateAttributesHeight(viewProperty, locations.getWithView(), true);
    }

    protected int calculateAttributesHeight(SetDefinition.SetViewProperty viewProperty, Ref withView, boolean full) {
        IndexDefinition definition = this.dictionary.getIndexDefinition(withView.getDefinition());
        IndexDefinitionBase.IndexViewProperty indexView = definition.getView(withView.getValue());
        IndexDefinitionBase.IndexViewProperty.ShowProperty show = indexView.getShow();
        if (show.getPicture() != null) {
            return 124;
        }
        int size = 60;
        size += show.getLine().size() > 0 ? 10 * this.countLines(show.getLine().size()) : 0;
        if (full) {
            size += show.getLineBelow().size() > 0 ? 10 * this.countLines(show.getLineBelow().size()) : 0;
        }
        size += show.getHighlight().size() > 0 ? 10 * this.countLines(show.getHighlight().size()) : 0;
        if (full) {
            size += show.getFooter().size() > 0 ? 10 * this.countLines(show.getFooter().size()) : 0;
        }
        return size;
    }

    protected int countLines(int size) {
        if (size <= 3) {
            return 1;
        }
        return Math.round(size / 3) + (size % 3 != 0 ? 1 : 0);
    }

    @Override
    protected boolean hasTemplate(NodeViewProperty viewProperty) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty = ((SetDefinition.SetViewProperty)viewProperty).getShow();
        if (showProperty.getItems() != null) {
            return true;
        }
        if (showProperty.getIndex() != null) {
            return true;
        }
        if (showProperty.getLocations() != null) {
            return true;
        }
        if (showProperty.getSharedPrototypes() != null) {
            return true;
        }
        return showProperty.getOwnedPrototypes() != null;
    }

    private void addShow(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty = viewProperty.getShow();
        FrameBuilder result = this.baseFrame().add("show");
        result.add(this.typeOf(showProperty));
        result.add("view", this.nameOf(viewProperty));
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("itemType", this.itemTypeFrame(viewProperty));
        result.add("componentType", this.componentTypeFrame(viewProperty));
        result.add("datasourceType", this.datasourceType(showProperty));
        result.add("datasourceAddType", this.datasourceAddType(showProperty));
        if (showProperty.getItems() != null) {
            this.addItemsShow(viewProperty, showProperty, result);
        } else if (showProperty.getIndex() != null) {
            this.addIndexShow(viewProperty, showProperty, result, builder);
        } else if (showProperty.getOwnedPrototypes() != null) {
            this.addIndexOwnedPrototypes(viewProperty, showProperty, result);
        } else if (showProperty.getLocations() != null) {
            this.addLocationsShow(viewProperty, showProperty, result);
        }
        this.addAttributes(viewProperty, result);
        builder.add("show", result);
    }

    private String datasourceType(SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty) {
        if (showProperty.getLocations() != null) {
            return "CollectionMapDatasource";
        }
        if (showProperty.getOwnedPrototypes() != null) {
            return "NodeOwnedPrototypesDatasource";
        }
        if (showProperty.getSharedPrototypes() != null) {
            return "NodeSharedPrototypesDatasource";
        }
        return "CollectionDatasource";
    }

    private FrameBuilder datasourceAddType(SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty) {
        FrameBuilder result = new FrameBuilder("datasourceAddType");
        if (showProperty.getLocations() != null) {
            result.add("map");
        }
        return result;
    }

    private void addItemsShow(SetDefinition.SetViewProperty viewProperty, SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty, FrameBuilder builder) {
        builder.add("reference", "td");
    }

    private FrameBuilder itemTypeFrame(SetDefinition.SetViewProperty viewProperty) {
        FrameBuilder result = this.baseFrame().add("itemType");
        result.add(this.typeOf(viewProperty));
        return result;
    }

    private FrameBuilder componentTypeFrame(SetDefinition.SetViewProperty viewProperty) {
        FrameBuilder result = this.baseFrame().add("componentType");
        result.add(this.typeOf(viewProperty));
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("view", this.nameOf(viewProperty));
        return result;
    }

    private void addIndexShow(SetDefinition.SetViewProperty viewProperty, SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty, FrameBuilder result, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty index = showProperty.getIndex();
        this.addReferenceShow(index.getWithView(), result);
        this.addDefaultSorting(index.getWithView(), index.getSortBy(), builder);
        this.addDefaultSortingMode(index.getWithView(), index.getSortMode(), builder);
    }

    protected void addDefaultSorting(Ref withView, Ref sortBy, FrameBuilder builder) {
        if (sortBy == null) {
            builder.add("defaultSorting", "T\u00edtulo");
            return;
        }
        IndexDefinition definition = this.dictionary.getIndexDefinition(withView.getDefinition());
        AttributeProperty attribute = definition.getAttribute(sortBy.getValue());
        String label = attribute.getName().equalsIgnoreCase("FechaCreacion") ? "Fecha de creaci\u00f3n" : this.clean(attribute.getLabel());
        builder.add("defaultSorting", label);
    }

    protected void addDefaultSortingMode(Ref withView, SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty.SortModeEnumeration mode, FrameBuilder builder) {
        builder.add("defaultSortingMode", mode != null ? this.modeOf(mode) : "Ascendente");
    }

    private String modeOf(SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty.SortModeEnumeration mode) {
        return mode == SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty.SortModeEnumeration.ASC ? "Ascendente" : "Descendente";
    }

    private void addIndexOwnedPrototypes(SetDefinition.SetViewProperty viewProperty, SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty, FrameBuilder builder) {
        builder.add("reference", "td");
    }

    private void addLocationsShow(SetDefinition.SetViewProperty viewProperty, SetDefinitionBase.SetViewPropertyBase.ShowProperty showProperty, FrameBuilder builder) {
        this.addReferenceShow(showProperty.getLocations().getWithView(), builder);
    }

    private void addReferenceShow(Ref withView, FrameBuilder builder) {
        IndexDefinition definition = this.dictionary.getIndexDefinition(withView.getDefinition());
        builder.add("reference", definition.getCode());
    }

    private void addAttributes(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty show = viewProperty.getShow();
        if (show.getItems() != null) {
            this.addItemsAttributes(viewProperty, builder);
        } else if (show.getIndex() != null) {
            this.addIndexAttributes(viewProperty, builder);
        } else if (show.getOwnedPrototypes() != null) {
            this.addDescriptorAttributes(viewProperty, builder);
        } else if (show.getLocations() != null) {
            this.addLocationsAttributes(viewProperty, builder);
        }
        if (!this.hasDetails(show)) {
            builder.add("hasDetails", "false");
        }
    }

    protected boolean hasDetails(SetDefinitionBase.SetViewPropertyBase.ShowProperty showDefinition) {
        if (showDefinition.getIndex() == null) {
            return false;
        }
        Ref withView = showDefinition.getIndex().getWithView();
        IndexDefinition definition = this.dictionary.getIndexDefinition(withView.getDefinition());
        IndexDefinitionBase.IndexViewProperty indexView = definition.getView(withView.getValue());
        IndexDefinitionBase.IndexViewProperty.ShowProperty show = indexView.getShow();
        return show != null && (!show.getFooter().isEmpty() || !show.getLineBelow().isEmpty());
    }

    private void addItemsAttributes(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        builder.add("attribute", this.attributeTitleFrame((NodeViewProperty)viewProperty, "label", "T\u00edtulo", 30, "row"));
        builder.add("attribute", this.attributeFrame((NodeViewProperty)viewProperty, "description", "Descripci\u00f3n", 30, "row"));
        builder.add("attribute", this.attributeFrame((NodeViewProperty)viewProperty, "create_date", "Fecha creaci\u00f3n", 15, "row"));
        builder.add("attribute", this.attributeFrame((NodeViewProperty)viewProperty, "update_date", "Fecha actualizaci\u00f3n", 15, "row"));
    }

    private boolean isLocations(SetDefinition.SetViewProperty viewProperty) {
        return viewProperty.getShow().getLocations() != null;
    }

    private void addDescriptorAttributes(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        DescriptorDefinition definition = new DescriptorDefinition();
        this.addIndexViewAttribute("title", this.attributeTitleFrame(viewProperty, definition, new Ref("label"), 1, "item"), builder);
        this.addIndexViewAttribute("line", this.attributeFrame(viewProperty, definition, new Ref("create_date"), 1, "item"), builder);
    }

    private void addIndexAttributes(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.IndexProperty index = viewProperty.getShow().getIndex();
        this.addIndexViewAttributes(viewProperty, index.getWithView(), builder, true);
    }

    private void addLocationsAttributes(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty.LocationsProperty locations = viewProperty.getShow().getLocations();
        this.addIndexViewAttributes(viewProperty, locations.getWithView(), builder, false);
        builder.add("locations");
    }

    private void addIndexViewAttributes(SetDefinition.SetViewProperty viewProperty, Ref withView, FrameBuilder builder, boolean useNullScope) {
        IndexDefinition definition = this.dictionary.getIndexDefinition(withView.getDefinition());
        IndexDefinitionBase.IndexViewProperty indexView = definition.getView(withView.getValue());
        IndexDefinitionBase.IndexViewProperty.ShowProperty show = indexView.getShow();
        int countAttributes = RendererHelper.countAttributes(indexView);
        this.addIndexViewAttribute("title", show.getTitle() != null ? this.attributeTitleFrame(viewProperty, definition, show.getTitle(), countAttributes, "item") : this.attributeFrame(viewProperty, definition, new Ref("label"), countAttributes, "item"), builder);
        if (show.getPicture() != null) {
            this.addIndexViewAttribute("picture", this.attributeFrame(viewProperty, definition, show.getPicture(), countAttributes, "item"), builder);
        }
        if (show.getIcon() != null) {
            this.addIndexViewAttribute("icon", this.attributeFrame(viewProperty, definition, show.getIcon(), countAttributes, "item"), builder);
        }
        show.getHighlight().forEach(h -> this.addIndexViewAttribute("highlight", this.attributeFrame(viewProperty, definition, (Ref)h, countAttributes, "item"), builder));
        show.getLine().forEach(l -> this.addIndexViewAttribute("line", this.attributeFrame(viewProperty, definition, (Ref)l, countAttributes, "item"), builder));
        show.getLineBelow().forEach(lb -> this.addIndexViewAttribute("lineBelow", this.attributeFrame(viewProperty, definition, (Ref)lb, countAttributes, useNullScope ? null : "item"), builder));
        show.getFooter().forEach(f -> this.addIndexViewAttribute("footer", this.attributeFrame(viewProperty, definition, (Ref)f, countAttributes, useNullScope ? null : "item"), builder));
    }

    private void addIndexViewAttribute(String section, FrameBuilder attributeFrame, FrameBuilder builder) {
        builder.add(section, attributeFrame.add(section));
        builder.add("attribute", attributeFrame);
    }

    private void addAnalyze(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        if (viewProperty.getAnalyze() == null) {
            return;
        }
        this.addDimensions(viewProperty, builder);
        this.addSortings(viewProperty, builder);
    }

    protected void addDimensions(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.AnalyzePropertyBase.DimensionProperty dimension = viewProperty.getAnalyze().getDimension();
        if (dimension == null) {
            return;
        }
        Collection<Ref> dimensionList = dimension.getAttribute().stream().collect(Collectors.toMap(Ref::getValue, a -> a, (a1, a2) -> a1)).values();
        dimensionList.forEach(d -> this.addDimension((Ref)d, builder));
    }

    private void addDimension(Ref dimension, FrameBuilder builder) {
        IndexDefinition definition = this.dictionary.getIndexDefinition(dimension.getDefinition());
        AttributeProperty attributeProperty = definition.getAttribute(dimension.getValue());
        builder.add("dimension", this.attributeFrame(attributeProperty, "dimension"));
    }

    protected void addSortings(SetDefinition.SetViewProperty viewProperty, FrameBuilder builder) {
        SetDefinitionBase.SetViewPropertyBase.AnalyzePropertyBase.SortingProperty sorting = viewProperty.getAnalyze().getSorting();
        if (sorting == null) {
            return;
        }
        Collection<Ref> sortingList = sorting.getAttribute().stream().collect(Collectors.toMap(Ref::getValue, a -> a, (a1, a2) -> a1)).values();
        sortingList.forEach(d -> this.addSorting(viewProperty, (Ref)d, builder));
    }

    private void addSorting(SetDefinition.SetViewProperty viewProperty, Ref sorting, FrameBuilder builder) {
        IndexDefinition definition = this.dictionary.getIndexDefinition(sorting.getDefinition());
        AttributeProperty attributeProperty = definition.getAttribute(sorting.getValue());
        builder.add("sorting", this.attributeFrame(attributeProperty, "sorting").add("view", this.nameOf(viewProperty)));
    }

    private FrameBuilder attributeFrame(AttributeProperty attributeProperty, String type) {
        FrameBuilder result = this.baseFrame().add(type);
        result.add("name", attributeProperty.getName());
        result.add("code", attributeProperty.getCode());
        result.add("label", this.clean(attributeProperty.getLabel()));
        result.add("type", RendererHelper.dimensionTypeOf(attributeProperty));
        return result;
    }

    private FrameBuilder attributeFrame(SetDefinition.SetViewProperty viewProperty, IndexDefinition definition, Ref attribute, int countAttributes, String scope) {
        String pattern;
        AttributeProperty attributeProperty = definition.getAttribute(attribute.getValue());
        FrameBuilder result = this.baseFrame().add("attribute");
        result.add("reference", attributeProperty != null ? "reference" : "node.getReference()");
        if (attributeProperty == null) {
            attributeProperty = new DescriptorDefinition().getAttribute(attribute.getValue());
        }
        result.add(attributeProperty.getType().name().toLowerCase());
        if (scope != null) {
            result.add("scope", scope);
        }
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("view", this.nameOf(viewProperty));
        result.add("name", this.normalize(attributeProperty.getName()));
        result.add("shortName", this.shortName(viewProperty, attributeProperty));
        result.add("code", attributeProperty.getCode());
        result.add("label", this.clean(attributeProperty.getLabel()));
        result.add("type", RendererHelper.attributeTypeOf(attributeProperty));
        result.add("width", countAttributes > 0 ? Math.round(100.0 / (double)countAttributes) : 0L);
        if (RendererHelper.attributeTypeOf(attributeProperty).equalsIgnoreCase("Text")) {
            result.add("cropWithEllipsis", 140);
        }
        if ((pattern = RendererHelper.dimensionPatternOf(attributeProperty)) != null) {
            result.add("pattern", pattern);
        }
        return result;
    }

    private FrameBuilder attributeTitleFrame(SetDefinition.SetViewProperty viewProperty, IndexDefinition definition, Ref attribute, int countAttributes, String scope) {
        FrameBuilder result = this.attributeFrame(viewProperty, definition, attribute, countAttributes, scope);
        if (this.isLocations(viewProperty)) {
            result.add("location");
        }
        return result;
    }

    private FrameBuilder attributeFrame(NodeViewProperty viewProperty, String key, String label, int width, String scope) {
        FrameBuilder result = this.baseFrame().add("attribute");
        result.add(this.typeOf(viewProperty));
        if (scope != null) {
            result.add("scope", scope);
        }
        result.add("reference", !viewProperty.getCode().equals("td") ? "reference" : "node.getReference()");
        result.add("definition", this.nameOf((Definition)this.definition()));
        result.add("view", this.nameOf(viewProperty));
        result.add("name", this.normalize(key));
        result.add("shortName", this.shortName(viewProperty, this.normalize(key)));
        result.add("code", key);
        result.add("label", this.clean(label));
        result.add("width", width);
        return result;
    }

    private FrameBuilder attributeTitleFrame(NodeViewProperty viewProperty, String key, String label, int width, String scope) {
        FrameBuilder result = this.attributeFrame(viewProperty, key, label, width, scope);
        if (!(viewProperty instanceof SetDefinition.SetViewProperty)) {
            return result;
        }
        if (this.isLocations((SetDefinition.SetViewProperty)viewProperty)) {
            result.add("location");
        }
        return result;
    }

    private String shortName(SetDefinition.SetViewProperty viewProperty, AttributeProperty attributeProperty) {
        return this.shortName((NodeViewProperty)viewProperty, this.normalize(attributeProperty.getName()));
    }

    private String shortName(NodeViewProperty viewProperty, String attributeName) {
        String name = this.nameOf((Definition)this.definition());
        String viewName = this.nameOf(viewProperty);
        return RendererHelper.shortName(name) + RendererHelper.shortName(viewName) + attributeName;
    }

    private String materialIcon(NodeViewProperty viewProperty) {
        SetDefinitionBase.SetViewPropertyBase.ShowProperty show = ((SetDefinition.SetViewProperty)viewProperty).getShow();
        if (show.getItems() != null) {
            return "ViewHeadline";
        }
        if (show.getIndex() != null) {
            return "ViewList";
        }
        if (show.getLocations() != null) {
            return "Map";
        }
        if (show.getOwnedPrototypes() != null) {
            return "AssignmentInd";
        }
        if (show.getSharedPrototypes() != null) {
            return "Assignment";
        }
        if (show.getReport() != null) {
            return "Assessment";
        }
        return null;
    }

    private void writeFiltersTemplates() {
        ((SetDefinition)this.definition()).getViewDefinitionList().stream().filter(this::hasTemplate).forEach(this::writeFiltersTemplate);
    }

    private void writeFiltersTemplate(NodeViewProperty view) {
        this.resetAddedDisplays();
        FrameBuilder viewFrame = this.viewFrame(view).add("filter");
        File file = new File(this.javaPackage() + this.nameOf((Definition)this.definition()) + StringUtil.firstUpperCase(this.nameOf(view)) + "FiltersTemplate.java");
        this.writeFrame(file, new Engine(this.javaTemplate()).addAll(Formatters.all).render(viewFrame.toFrame()));
    }
}

