/*
 * Decompiled with CFR 0.152.
 */
package org.monet.metamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.monet.metamodel.BooleanFieldProperty;
import org.monet.metamodel.CheckFieldProperty;
import org.monet.metamodel.CompositeFieldProperty;
import org.monet.metamodel.DateFieldProperty;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FileFieldProperty;
import org.monet.metamodel.FormDefinitionBase;
import org.monet.metamodel.LinkFieldProperty;
import org.monet.metamodel.MemoFieldProperty;
import org.monet.metamodel.NodeFieldProperty;
import org.monet.metamodel.NumberFieldProperty;
import org.monet.metamodel.PictureFieldProperty;
import org.monet.metamodel.SelectFieldProperty;
import org.monet.metamodel.SerialFieldProperty;
import org.monet.metamodel.SummationFieldProperty;
import org.monet.metamodel.TextFieldProperty;
import org.monet.metamodel.interfaces.HasMappings;
import org.monet.metamodel.interfaces.HasSchema;
import org.monet.metamodel.interfaces.IsInitiable;

public class FormDefinition
extends FormDefinitionBase
implements IsInitiable,
HasMappings {
    private ArrayList<FieldProperty> superFieldList = new ArrayList();
    private HashMap<String, String> fieldsPath = new HashMap();

    private void createFieldPropertyList(CompositeFieldProperty field) {
        if (!this.fieldsPath.containsKey(field.getCode())) {
            this.fieldsPath.put(field.getCode(), field.getCode());
        }
        for (FieldProperty childField : field.getAllFieldPropertyList()) {
            this._allFieldPropertyMap.put(childField.getCode(), childField);
            this._allFieldPropertyMap.put(childField.getName(), childField);
            this.fieldsPath.put(childField.getCode(), this.fieldsPath.get(field.getCode()) + "." + childField.getCode());
            if (childField.isComposite()) {
                this.createFieldPropertyList((CompositeFieldProperty)childField);
                continue;
            }
            if (childField.isBoolean()) {
                this.addBooleanFieldProperty((BooleanFieldProperty)childField);
                continue;
            }
            if (childField.isCheck()) {
                this.addCheckFieldProperty((CheckFieldProperty)childField);
                continue;
            }
            if (childField.isDate()) {
                this.addDateFieldProperty((DateFieldProperty)childField);
                continue;
            }
            if (childField.isFile()) {
                this.addFileFieldProperty((FileFieldProperty)childField);
                continue;
            }
            if (childField.isLink()) {
                this.addLinkFieldProperty((LinkFieldProperty)childField);
                continue;
            }
            if (childField.isMemo()) {
                this.addMemoFieldProperty((MemoFieldProperty)childField);
                continue;
            }
            if (childField.isNode()) {
                this.addNodeFieldProperty((NodeFieldProperty)childField);
                continue;
            }
            if (childField.isNumber()) {
                this.addNumberFieldProperty((NumberFieldProperty)childField);
                continue;
            }
            if (childField.isPicture()) {
                this.addPictureFieldProperty((PictureFieldProperty)childField);
                continue;
            }
            if (childField.isSelect()) {
                this.addSelectFieldProperty((SelectFieldProperty)childField);
                continue;
            }
            if (childField.isSerial()) {
                this.addSerialFieldProperty((SerialFieldProperty)childField);
                continue;
            }
            if (childField.isText()) {
                this.addTextFieldProperty((TextFieldProperty)childField);
                continue;
            }
            if (!childField.isSummation()) continue;
            this.addSummationFieldProperty((SummationFieldProperty)childField);
        }
    }

    protected void createFieldPropertyList() {
        super.createAllFieldPropertyList();
        for (FieldProperty field : this._allFieldPropertyList) {
            if (field.isComposite()) {
                this.createFieldPropertyList((CompositeFieldProperty)field);
                continue;
            }
            this.fieldsPath.put(field.getCode(), field.getCode());
        }
    }

    @Override
    public void init() {
        this.createAllFieldPropertyMap();
        this.createFieldPropertyList();
        for (FormDefinitionBase.FormViewProperty view : this._formViewPropertyMap.values()) {
            if (this.getDefaultView() == null) {
                this.setDefaultView(view);
            }
            if (view.isDefault() && !view.isVisibleWhenEmbedded()) {
                this.setDefaultView(view);
            }
            this.viewsMap.put(view.getCode(), view);
            this.viewsMap.put(view.getName(), view);
            if (!view.isVisibleWhenEmbedded()) {
                this.tabViewList.add(view);
            }
            this.viewList.add(view);
        }
    }

    public List<FieldProperty> getSuperFieldPropertyList() {
        return this.superFieldList;
    }

    public boolean hasSuperFieldProperties() {
        return this.superFieldList.size() > 0;
    }

    public HashSet<String> getSchemaAttributesUsingSuperFields() {
        HashSet<String> result = new HashSet<String>();
        if (!this.hasSuperFieldProperties()) {
            return result;
        }
        HashMap<String, String> fieldsAttributes = ((HasSchema)((Object)this)).getSchemaDefinition().getFieldsAttributesMap();
        for (FieldProperty field : this.superFieldList) {
            if (!fieldsAttributes.containsKey(field._name)) continue;
            result.add(fieldsAttributes.get(field._code));
        }
        return result;
    }

    public String getFieldPath(String key) {
        FieldProperty fieldDefinition = this.getField(key);
        return this.fieldsPath.get(fieldDefinition.getCode());
    }

    @Override
    protected void initRulesMap() {
        super.initRulesMap();
        for (FormDefinitionBase.RuleFormProperty rule : this._ruleFormPropertyList) {
            this.rulesMap.put(rule.getCode(), rule);
        }
    }

    @Override
    public Class<?> getMappingClass(String code) {
        return null;
    }

    public ArrayList<String> getSources() {
        ArrayList<String> sourceList = new ArrayList<String>();
        for (CheckFieldProperty checkFieldProperty : this.getCheckFieldPropertyList()) {
            if (checkFieldProperty.getSource() == null) continue;
            sourceList.add(checkFieldProperty.getSource().getValue());
        }
        for (SelectFieldProperty selectFieldProperty : this.getSelectFieldPropertyList()) {
            if (selectFieldProperty.getSource() == null) continue;
            sourceList.add(selectFieldProperty.getSource().getValue());
        }
        return sourceList;
    }

    public HashMap<String, FieldProperty> getFields() {
        return this._allFieldPropertyMap;
    }
}

