/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class UITemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("ui", "routedispatcher"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates.AppTemplate;\nimport io.intino.alexandria.ui.Soul;\n\npublic class RouteDispatcher extends AbstractRouteDispatcher {\n\n    @Override\n    public void dispatchHome(Soul soul) {\n        soul.currentLayer(AppTemplate.class).openHome();\n    }\n\n    @Override\n    public void dispatchError(Soul soul) {\n    }\n\n    @Override\n    public void dispatchSingleton(Soul soul, String name, String mode) {\n        AppTemplate display = soul.currentLayer(AppTemplate.class);\n        if (mode != null && mode.equals(\"undefined\")) mode = null;\n        boolean readonly = mode != null && !mode.equalsIgnoreCase(\"edit\");\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "dispatchSingleton").multiple("\n"))).output(this.literal("\n    }\n\n    @Override\n    public void dispatchInstance(Soul soul, String name, String id, String view, String mode) {\n        AppTemplate display = soul.currentLayer(AppTemplate.class);\n        if (view != null && view.equals(\"undefined\")) view = null;\n        if (mode != null && mode.equals(\"undefined\")) mode = null;\n        boolean readonly = mode != null && !mode.equalsIgnoreCase(\"edit\");\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "dispatchInstance").multiple("\n"))).output(this.literal("\n    }\n\n    @Override\n    public void dispatchTask(Soul soul, String name, String inbox, String task) {\n        AppTemplate display = soul.currentLayer(AppTemplate.class);\n        if (task != null && task.equals(\"undefined\")) task = null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "dispatchTask").multiple("\n"))).output(this.literal("\n    }\n\n    @Override\n    public void dispatchTaskTray(Soul soul, String folder) {\n        soul.currentLayer(AppTemplate.class).openTaskTray(folder);\n    }\n\n    @Override\n    public void dispatchTaskBoard(Soul soul, String folder) {\n        soul.currentLayer(AppTemplate.class).openTaskBoard(folder);\n    }\n\n    @Override\n    public void dispatchRoles(Soul soul) {\n        soul.currentLayer(AppTemplate.class).openRoles();\n    }\n\n    @Override\n    public void dispatchTrash(Soul soul) {\n        soul.currentLayer(AppTemplate.class).openTrash();\n    }\n\n    @Override\n    public void dispatchNews(Soul soul) {\n        soul.currentLayer(AppTemplate.class).openNews();\n    }\n}")), this.rule().condition(this.allTypes("ui", "app"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport org.monet.metamodel.*;\nimport org.monet.metamodel.internal.Ref;\nimport org.monet.space.kernel.agents.AgentSession;\nimport org.monet.space.kernel.components.layers.FederationLayer;\nimport org.monet.space.kernel.components.layers.TaskLayer;\nimport org.monet.space.kernel.constants.ApplicationInterface;\nimport org.monet.space.kernel.constants.Database;\nimport org.monet.space.kernel.model.Dictionary;\nimport org.monet.space.kernel.model.*;\nimport org.monet.space.office.ApplicationOffice;\nimport io.intino.goros.unit.box.ui.datasources.TaskInboxDatasource;\nimport io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox;\nimport io.intino.goros.unit.util.AccountHelper;\nimport io.intino.goros.unit.util.LayerHelper;\n\nimport java.time.Instant;\nimport java.util.List;\n\nimport static java.util.Collections.emptyList;\n\npublic class AppTemplate extends AbstractAppTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private View current = null;\n    private boolean sessionClosedDialogOpened = false;\n    private Instant lastCheck;\n\n    public enum View { Dashboard, Roles, TaskTray, TaskBoard, News, Trash")).output(this.expression(new Rule.Output[0]).output(this.literal(", ")).output(this.mark("definition", "declaration").multiple(", "))).output(this.literal(" }\n\n    public AppTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        if (!org.monet.space.kernel.model.BusinessUnit.getInstance().isInstalled()) {\n            notifier.redirect(session().browser().baseUrl() + \"/install\");\n            return;\n        }\n        box().unit().initSession(session());\n        initLoggedChecker();\n        taskTrayLink.address(path -> path.replace(\":folder\", \"Pendientes\"));\n        taskBoardLink.address(path -> path.replace(\":folder\", \"Pendientes\"));\n        reloadPage.onExecute(e -> notifier.redirect(session().browser().requestUrl()));\n        io.intino.goros.unit.util.DisplayHelper.initAgentSession(session());\n        io.intino.goros.unit.util.DisplayHelper.initContext(box().unit(), session(), Thread.currentThread().getId());\n        box().pushService().onLinkedToThread(session().client(), threadId -> {\n            io.intino.goros.unit.util.DisplayHelper.initContext(box().unit(), session(), threadId);\n            checkFederation();\n        });\n        box().notifier().onTaskCreated(this, this::refreshTasksCount);\n        box().notifier().onTaskAssigned(this, this::refreshTasksCount);\n        box().notifier().onTaskUnAssigned(this, this::refreshTasksCount);\n        box().notifier().onTaskStateChange(this, this::refreshTasksCount);\n        refresh();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshDrawer();\n    }\n\n    @Override\n    public void remove() {\n        super.remove();\n        box().notifier().unTaskCreated(this);\n        box().notifier().unTaskAssigned(this);\n        box().notifier().unTaskUnAssigned(this);\n        box().notifier().unTaskStateChange(this);\n    }\n\n    public void embedded(boolean embedded) {\n        if (!embedded) return;\n        header.hide();\n        drawer.hide();\n    }\n\n    public void openHome() {\n        Distribution distribution = BusinessUnit.getInstance().getDistribution();\n        Distribution.ShowProperty showProperty = distribution.getShow();\n        if (false) {}\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "openHome").multiple("\n"))).output(this.literal("\n        else openForbiddenPage();\n    }\n\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "method").multiple("\n"))).output(this.literal("\n\n    public void openForbiddenPage() {\n        loading.visible(false);\n        forbiddenPage.show();\n    }\n\n    public void openDashboard() {\n        if (initializationTaskOpened()) return;\n        openView(View.Dashboard);\n        if (dashboardPage.dashboardStamp != null) dashboardPage.dashboardStamp.refresh();\n    }\n\n    public void openRoles() {\n        if (initializationTaskOpened()) return;\n        openView(View.Roles);\n        if (rolesPage.rolesStamp != null) rolesPage.rolesStamp.refresh();\n    }\n\n    public void openTaskTray(String folder) {\n        if (initializationTaskOpened()) return;\n        openView(View.TaskTray);\n        if (taskTrayPage.taskTrayStamp != null) {\n            taskTrayPage.taskTrayStamp.folder(folder);\n            taskTrayPage.taskTrayStamp.refresh();\n        }\n    }\n\n    public void openTaskBoard(String folder) {\n        if (initializationTaskOpened()) return;\n        openView(View.TaskBoard);\n        if (taskBoardPage.taskBoardStamp != null) {\n            taskBoardPage.taskBoardStamp.folder(folder);\n            taskBoardPage.taskBoardStamp.refresh();\n        }\n    }\n\n    public void openNews() {\n        openView(View.News);\n        if (newsPage.newsStamp != null) newsPage.newsStamp.refresh();\n    }\n\n    public void openTrash() {\n        openView(View.Trash);\n        if (trashPage.trashStamp != null) trashPage.trashStamp.refresh();\n    }\n\n    private void refreshDrawer() {\n        Distribution distribution = BusinessUnit.getInstance().getDistribution();\n        Distribution.ShowProperty showProperty = distribution.getShow();\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "refreshDrawer").multiple("\n"))).output(this.literal("\n        dashboard.visible(AccountHelper.hasRoles(dashboardRoles(showProperty), session()));\n        roles.visible(showProperty.getTabRoles() != null && AccountHelper.hasRoles(showProperty.getTabRoles().getFor(), session()));\n        taskTray.visible(showProperty.getTabTasktray() != null && AccountHelper.hasRoles(showProperty.getTabTasktray().getFor(), session()));\n        if (taskTray.isVisible()) taskTray.value(AccountHelper.aliveTaskTrayTasksCount(session()));\n        taskBoard.visible(showProperty.getTabTaskboard() != null && AccountHelper.hasRoles(showProperty.getTabTaskboard().getFor(), session()));\n        if (taskBoard.isVisible()) taskBoard.value(AccountHelper.activeTaskBoardTasksCount(session()));\n        news.visible(showProperty.getTabNews() != null && AccountHelper.hasRoles(showProperty.getTabNews().getFor(), session()));\n        trash.visible(showProperty.getTabTrash() != null && AccountHelper.hasRoles(showProperty.getTabTrash().getFor(), session()));\n    }\n\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "rolesMethod").multiple("\n"))).output(this.literal("\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "setupAddressMethod").multiple("\n"))).output(this.literal("\n\n    private List<Ref> nodeDefinitionRoles(Distribution.ShowProperty showProperty, String code) {\n        NodeDefinition definition = showProperty.getTabEnvironment().stream().map(te -> org.monet.space.kernel.model.Dictionary.getInstance().getNodeDefinition(te.getValue())).filter(d -> d.getCode().equals(code)).findFirst().orElse(null);\n        if (definition == null) return null;\n        if (!definition.isEnvironment()) return null;\n\n        if (definition.isDesktop()) {\n            DesktopDefinition desktopDefinition = (DesktopDefinition) definition;\n            return desktopDefinition.getFor() != null ? desktopDefinition.getFor().getRole() : emptyList();\n        } else if (definition.isContainer() && definition.isEnvironment()) {\n            ContainerDefinition containerDefinition = (ContainerDefinition) definition;\n            return containerDefinition.getFor() != null ? containerDefinition.getFor().getRole() : emptyList();\n        }\n\n        return null;\n    }\n\n    private List<Ref> dashboardRoles(Distribution.ShowProperty showProperty) {\n        return dashboardRoles(showProperty, \"Dashboard\");\n    }\n\n    private List<Ref> dashboardRoles(Distribution.ShowProperty showProperty, String name) {\n        DashboardDefinition definition = showProperty.getTabDashboard().stream().map(te -> org.monet.space.kernel.model.Dictionary.getInstance().getDashboardDefinition(te.getDefinition())).filter(d -> d.getName().equals(name)).findFirst().orElse(null);\n        if (definition == null) return null;\n        return definition.getFor() != null ? definition.getFor().getRole() : emptyList();\n    }\n\n    private void openView(View view) {\n        loading.visible(false);\n        if (current == view) return;\n        if (current != null) blockOf(current).hide();\n        blockOf(view).show();\n        current = view;\n    }\n\n    private boolean initializationTaskOpened() {\n        Task task = io.intino.goros.unit.util.LayerHelper.taskLayer().getCurrentInitializerTask();\n        if (task == null) return false;\n        if (canResolveInitializerTask()) openInitializationTask(task.getId(), io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox.TaskBoard.name());\n        else openUpdateRequiredPage();\n        return true;\n    }\n\n    private void openUpdateRequiredPage() {\n        loading.visible(false);\n        updateRequiredPage.visible(true);\n    }\n\n    private boolean canResolveInitializerTask() {\n        FederationLayer federationLayer = io.intino.goros.unit.util.LayerHelper.federationLayer(session());\n        if (!federationLayer.isLogged()) return true;\n        TaskLayer taskLayer = io.intino.goros.unit.util.LayerHelper.taskLayer();\n        Task currentInitializerTask = taskLayer.getCurrentInitializerTask();\n        Account account = federationLayer.loadAccount();\n        return account.canResolveInitializerTask(currentInitializerTask);\n    }\n\n    private BlockConditional blockOf(View view) {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "block").multiple("\n"))).output(this.literal("\n        if (view == View.Dashboard) return dashboardPage;\n        if (view == View.Roles) return rolesPage;\n        if (view == View.TaskTray) return taskTrayPage;\n        if (view == View.TaskBoard) return taskBoardPage;\n        if (view == View.News) return newsPage;\n        if (view == View.Trash) return trashPage;\n        return null;\n    }\n\n    private boolean openInitializationTask(String id, String inbox) {\n        Task initializationTask = io.intino.goros.unit.util.LayerHelper.taskLayer().getCurrentInitializerTask();\n        if (initializationTask != null && (!initializationTask.getId().equals(id) || !canResolveInitializerTask())) {\n            openUpdateRequiredPage();\n            return false;\n        }\n        Task task = io.intino.goros.unit.util.LayerHelper.taskLayer().loadTask(id);\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("definition", "taskInitialization").multiple("\n"))).output(this.literal("\n        return true;\n    }\n\n    private void refreshTasksCount(Task task) {\n        if (taskTray.isVisible()) taskTray.value(AccountHelper.aliveTaskTrayTasksCount(session()));\n        if (taskBoard.isVisible()) taskBoard.value(AccountHelper.activeTaskBoardTasksCount(session()));\n    }\n\n    private void initLoggedChecker() {\n        sessionClosedDialog.onClose(e -> sessionClosedDialogOpened = false);\n    }\n\n    private void checkFederation() {\n        try {\n            if (checkAgain() && !LayerHelper.federationLayer(session()).isLogged()) showSessionClosedDialog();\n            lastCheck = Instant.now();\n        }\n        catch (Throwable ignored) {\n            showSessionClosedDialog();\n        }\n    }\n\n    private boolean checkAgain() {\n        return lastCheck == null || Instant.now().toEpochMilli()-lastCheck.toEpochMilli() > 1_000;\n    }\n\n    private void showSessionClosedDialog() {\n        if (sessionClosedDialogOpened) return;\n        sessionClosedDialog.open();\n        sessionClosedDialogOpened = true;\n    }\n\n}")), this.rule().condition(this.allTypes("ui", "header"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport org.monet.metamodel.Distribution;\nimport org.monet.metamodel.Project;\nimport org.monet.space.kernel.Kernel;\nimport org.monet.space.kernel.exceptions.DataException;\nimport org.monet.space.kernel.model.BusinessUnit;\n\nimport java.io.File;\nimport java.net.MalformedURLException;\nimport java.net.URL;\n\npublic class HeaderTemplate extends AbstractHeaderTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n\n    public HeaderTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        BusinessUnit businessUnit = BusinessUnit.getInstance();\n        Distribution distribution = businessUnit.getDistribution();\n        Project project = businessUnit.getBusinessModel().getProject();\n        title.value(distribution != null ? BusinessUnit.getTitle(distribution, project) : \"\");\n        subtitle.value(businessUnit.getLabel());\n        logo.value(logo());\n        businessUnitsBlock.onOpen(e -> businessUnitsStamp.refresh());\n    }\n\n    private URL logo() {\n        try {\n            return new File(Kernel.getInstance().getConfiguration().getFederationLogoFile()).toURI().toURL();\n        } catch (DataException | MalformedURLException ignored) {\n            return HeaderTemplate.class.getResource(\"/images/logo.png\");\n        }\n    }\n}")), this.rule().condition(this.allTypes("definition", "container", "environment"), this.trigger("openhome")).output(this.literal("else if (AccountHelper.hasRoles(")).output(this.mark("name", "firstLowerCase")).output(this.literal("Roles(showProperty), session())) open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(io.intino.goros.unit.util.NodeHelper.getEnvironmentNodeId(io.intino.goros.unit.util.AccountHelper.account(session()), \"")).output(this.mark("code", new String[0])).output(this.literal("\"), null, true);")), this.rule().condition(this.allTypes("definition", "desktop"), this.trigger("openhome")).output(this.literal("else if (AccountHelper.hasRoles(")).output(this.mark("name", "firstLowerCase")).output(this.literal("Roles(showProperty), session())) open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(true);")), this.rule().condition(this.allTypes("definition", "container", "environment"), this.trigger("refreshdrawer")).output(this.mark("name", "firstLowerCase")).output(this.literal("Link.address(this::setup")).output(this.mark("name", "firstUpperCase")).output(this.literal("Link);")), this.rule().condition(this.allTypes("definition", "desktop"), this.trigger("refreshdrawer")).output(this.mark("name", "firstLowerCase")).output(this.literal("Link.address(path -> path.replace(\":name\", \"")).output(this.mark("name", "lowercase")).output(this.literal("\").replace(\":mode\", \"default\"));\n")).output(this.mark("name", "firstLowerCase")).output(this.literal(".visible(AccountHelper.hasRoles(")).output(this.mark("name", "firstLowerCase")).output(this.literal("Roles(showProperty), session()));")), this.rule().condition(this.type("definition"), this.trigger("refreshdrawer")), this.rule().condition(this.allTypes("definition", "container", "environment"), this.trigger("rolesmethod")).output(this.literal("private List<Ref> ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Roles(Distribution.ShowProperty showProperty) {\n    return nodeDefinitionRoles(showProperty, \"")).output(this.mark("code", new String[0])).output(this.literal("\");\n}")), this.rule().condition(this.allTypes("definition", "desktop"), this.trigger("rolesmethod")).output(this.literal("private List<Ref> ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Roles(Distribution.ShowProperty showProperty) {\n    return nodeDefinitionRoles(showProperty, \"")).output(this.mark("code", new String[0])).output(this.literal("\");\n}")), this.rule().condition(this.allTypes("definition", "container", "environment"), this.trigger("setupaddressmethod")).output(this.literal("private String setup")).output(this.mark("name", "firstUpperCase")).output(this.literal("Link(String path) {\n    String id = io.intino.goros.unit.util.NodeHelper.getEnvironmentNodeId(io.intino.goros.unit.util.AccountHelper.account(session()), \"")).output(this.mark("code", new String[0])).output(this.literal("\");\n    return path.replace(\":name\", \"")).output(this.mark("name", "lowercase")).output(this.literal("\").replace(\":id\", id != null ? id : \"\").replace(\":view\", \"default\").replace(\":mode\", \"default\");\n}")), this.rule().condition(this.type("definition"), this.trigger("setupaddressmethod")), this.rule().condition(this.type("definition"), this.trigger("rolesmethod")), this.rule().condition(this.allTypes("definition", "index"), this.trigger("declaration")), this.rule().condition(this.type("definition"), this.trigger("declaration")).output(this.mark("name", "firstUpperCase")), this.rule().condition(this.allTypes("definition", "process"), this.trigger("method")).output(this.literal("public void open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(String task, String inbox) {\n    if (openInitializationTask(task, inbox)) return;\n    open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(io.intino.goros.unit.util.LayerHelper.taskLayer().loadTask(task), inbox);\n}\n\nprivate void open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(Task task, String inbox) {\n    openView(View.")).output(this.mark("name", "firstUpperCase")).output(this.literal(");\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp != null) {\n        ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.inbox(io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox.from(inbox));\n        ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.open(task.getId());\n    }\n}")), this.rule().condition(this.allTypes("definition", "index"), this.trigger("method")), this.rule().condition(this.allTypes("definition", "source"), this.trigger("method")).output(this.literal("public void open")).output(this.mark("name", "firstUpperCase")).output(this.literal("() {\n    if (initializationTaskOpened()) return;\n    openView(View.")).output(this.mark("name", "firstUpperCase")).output(this.literal(");\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp == null) return;\n    ")).output(this.expression(new Rule.Output[0]).output(this.mark("sourceDesktop", new String[0]))).output(this.literal("\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.open(\"")).output(this.mark("code", new String[0])).output(this.literal("\");\n}")), this.rule().condition(this.type("sourceDesktop"), new Rule.Condition[0]).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.desktop(\"")).output(this.mark("desktopLabel", new String[0])).output(this.literal("\", \"/elemento/")).output(this.mark("desktop", "lowerCase")).output(this.literal("\");")), this.rule().condition(this.allTypes("definition", "process"), this.trigger("taskinitialization")).output(this.literal("if (task.getDefinition().getCode().equals(\"")).output(this.mark("code", new String[0])).output(this.literal("\")) open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(task, inbox);")), this.rule().condition(this.type("definition"), this.trigger("taskinitialization")), this.rule().condition(this.allTypes("definition", "singleton"), this.trigger("method")).output(this.literal("public void open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(boolean readonly) {\n    if (initializationTaskOpened()) return;\n    openView(View.")).output(this.mark("name", "firstUpperCase")).output(this.literal(");\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp != null) {\n        ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.open(\"")).output(this.mark("code", new String[0])).output(this.literal("\", readonly);\n    }\n}")), this.rule().condition(this.type("definition"), this.trigger("method")).output(this.literal("public void open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(String id, String view, boolean readonly) {\n    if (initializationTaskOpened()) return;\n    openView(View.")).output(this.mark("name", "firstUpperCase")).output(this.literal(");\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp != null) {\n        ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.open(id, view, readonly);\n    }\n}")), this.rule().condition(this.allTypes("definition", "process"), this.trigger("dispatchtask")).output(this.literal("if (name.equalsIgnoreCase(\"")).output(this.mark("name", new String[0])).output(this.literal("\")) display.open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(task, inbox);")), this.rule().condition(this.type("definition"), this.trigger("dispatchtask")), this.rule().condition(this.allTypes("definition", "source"), this.trigger("dispatchsingleton")).output(this.literal("if (name.equalsIgnoreCase(\"")).output(this.mark("name", new String[0])).output(this.literal("\")) display.open")).output(this.mark("name", "firstUpperCase")).output(this.literal("();")), this.rule().condition(this.allTypes("definition", "singleton"), this.trigger("dispatchsingleton")).output(this.literal("if (name.equalsIgnoreCase(\"")).output(this.mark("name", new String[0])).output(this.literal("\")) display.open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(readonly);")), this.rule().condition(this.type("definition"), this.trigger("dispatchsingleton")), this.rule().condition(this.allTypes("definition", "source"), this.trigger("dispatchinstance")), this.rule().condition(this.allTypes("definition", "process"), this.trigger("dispatchinstance")), this.rule().condition(this.allTypes("definition", "singleton"), this.trigger("dispatchinstance")), this.rule().condition(this.allTypes("definition", "index"), this.trigger("dispatchinstance")), this.rule().condition(this.type("definition"), this.trigger("dispatchinstance")).output(this.literal("if (name.equalsIgnoreCase(\"")).output(this.mark("name", new String[0])).output(this.literal("\")) display.open")).output(this.mark("name", "firstUpperCase")).output(this.literal("(id, view, readonly);")), this.rule().condition(this.allTypes("definition", "index"), this.trigger("block")), this.rule().condition(this.type("definition"), this.trigger("block")).output(this.literal("if (view == View.")).output(this.mark("name", "firstUpperCase")).output(this.literal(") return ")).output(this.mark("name", "firstLowerCase")).output(this.literal("Page;")));
    }
}

