/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.templates.java;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class TasksTemplate
extends Template {
    @Override
    public RuleSet ruleSet() {
        return new RuleSet().add(this.rule().condition(this.allTypes("tasks", "nodetasks"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport org.monet.space.kernel.model.Node;\nimport io.intino.goros.unit.box.ui.datasources.NodeTasksDatasource;\n\npublic class NodeTasksTemplate extends AbstractNodeTasksTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private Node node;\n    private boolean readonly = true;\n    private String view;\n\n    public NodeTasksTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public NodeTasksTemplate node(Node node) {\n        this.node = node;\n        return this;\n    }\n\n    public NodeTasksTemplate view(String view) {\n        this.view = view;\n        return this;\n    }\n\n    public NodeTasksTemplate readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public boolean editing() {\n        return !readonly;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        tasks.inbox(io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox.TaskBoard);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        tasks.source(new NodeTasksDatasource(box().unit(), session(), node, node.getDefinition().getNodeView(view)));\n        tasks.refresh();\n    }\n\n}")), this.rule().condition(this.allTypes("tasks", "inbox"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\n\npublic class ")).output(this.mark("inboxType", "firstUpperCase")).output(this.literal("Template extends Abstract")).output(this.mark("inboxType", "firstUpperCase")).output(this.literal("Template<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String folder;\n\n    public ")).output(this.mark("inboxType", "firstUpperCase")).output(this.literal("Template(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public ")).output(this.mark("inboxType", "firstUpperCase")).output(this.literal("Template folder(String folder) {\n        this.folder = folder;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        tasks.inbox(io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox.")).output(this.mark("inboxType", "firstUpperCase")).output(this.literal(");\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        tasks.folder(folder);\n        tasks.readonly(false);\n        tasks.refresh();\n    }\n\n}")), this.rule().condition(this.allTypes("tasks", "embedded"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport io.intino.alexandria.ui.displays.components.Collection;\nimport io.intino.alexandria.ui.displays.components.SearchBox;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport org.monet.space.kernel.components.ComponentPersistence;\nimport org.monet.space.kernel.model.Task;\nimport io.intino.goros.unit.box.ui.datasources.TaskListDatasource;\nimport io.intino.goros.unit.box.ui.ViewMode;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class TasksEmbeddedTemplate extends AbstractTasksEmbeddedTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String view;\n    private TaskListDatasource.Inbox inbox;\n    private TaskListDatasource source;\n    private Task selectedTask;\n    private boolean readonly = true;\n    private java.util.function.Consumer<Long> itemsCountListener;\n    private java.util.function.Consumer<Boolean> showFiltersListener;\n    private java.util.function.Consumer<io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State> toggleFiltersListener;\n    private java.util.function.Consumer<io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State> toggleViewListener;\n    private SearchBox searchBox;\n    private io.intino.goros.unit.box.ui.ViewMode viewMode = io.intino.goros.unit.box.ui.ViewMode.Compact;\n\n    public TasksEmbeddedTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public TasksEmbeddedTemplate view(String view) {\n        this.view = view;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate inbox(TaskListDatasource.Inbox inbox) {\n        this.inbox = inbox;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate source(TaskListDatasource source) {\n        this.source = source;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public boolean editing() {\n        return !readonly;\n    }\n\n    public TasksEmbeddedTemplate bindTo(SearchBox search) {\n        this.searchBox = search;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate toggleFilters(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        toggleFiltersViewVisibility(state);\n        return this;\n    }\n\n    public TasksEmbeddedTemplate onShowFilters(java.util.function.Consumer<Boolean> listener) {\n        this.showFiltersListener = listener;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate onToggleFilters(java.util.function.Consumer<io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State> listener) {\n        this.toggleFiltersListener = listener;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate toggleView(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        this.viewMode = state == ToggleEvent.State.On ? io.intino.goros.unit.box.ui.ViewMode.Full : io.intino.goros.unit.box.ui.ViewMode.Compact;\n        refreshViewMode();\n        return this;\n    }\n\n    public TasksEmbeddedTemplate onToggleView(java.util.function.Consumer<io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State> listener) {\n        this.toggleViewListener = listener;\n        return this;\n    }\n\n    public TasksEmbeddedTemplate onItemsCountChange(java.util.function.Consumer<Long> listener) {\n        this.itemsCountListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        box().notifier().onTaskCreated(this, task -> refresh());\n        initViews();\n    }\n\n    @Override\n    public void remove() {\n        super.remove();\n        box().notifier().unTaskCreated(this);\n    }\n\n    public Collection currentCollection() {\n        if (tableView.isVisible()) return tableView.tableViewStamp.tasksTable;\n        return listView.listViewStamp.tasksList;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshCollapse();\n        refreshView();\n    }\n\n    private void initViews() {\n        hideViews.onExecute(e -> hideViews());\n        tableView.onInit(e -> {\n            tableView.tableViewStamp.tasksTable.onRefreshItemCount(this::refreshCount);\n            tableView.tableViewStamp.tasksTable.onSelect(this::open);\n        });\n        tableView.onShow(e -> {\n            bindCurrentViewTo(tableView.tableViewStamp.tasksTable);\n            if (searchBox != null) searchBox.bindTo(tableView.tableViewStamp.tasksTable);\n            tableView.tableViewStamp.source(source);\n            tableView.tableViewStamp.readonly(readonly);\n            tableView.tableViewStamp.refresh();\n            showFilters();\n        });\n        listView.onInit(e -> {\n            listView.listViewStamp.tasksList.onRefreshItemCount(this::refreshCount);\n            listView.listViewStamp.tasksList.onSelect(this::open);\n        });\n        listView.onShow(e -> {\n            bindCurrentViewTo(listView.listViewStamp.tasksList);\n            if (searchBox != null) searchBox.bindTo(listView.listViewStamp.tasksList);\n            listView.listViewStamp.source(source);\n            listView.listViewStamp.readonly(readonly);\n            listView.listViewStamp.refresh();\n            showFilters();\n        });\n        filtersView.onInit(e -> initFilters());\n        filtersView.onShow(e -> filtersView.tasksFiltersStamp.refresh());\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "init").multiple("\n"))).output(this.literal("\n    }\n\n    private void refreshView() {\n        if (view == null) view = \"list\";\n        if (view.equals(\"table\")) {\n            listView.hide();\n            tableView.show();\n        }\n        else if (view.equals(\"list\")) {\n            tableView.hide();\n            listView.show();\n        }\n        //selectedTask = null;\n    }\n\n    private void refresh(Task task) {\n        if (tableView.isVisible()) tableView.tableViewStamp.refresh(task);\n        if (listView.isVisible()) listView.listViewStamp.refresh(task);\n    }\n\n    private void refreshCount(RefreshCountEvent event) {\n        if (itemsCountListener != null) itemsCountListener.accept(event.count());\n    }\n\n    private void toggleFiltersViewVisibility(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        showViews();\n        hideChildViews();\n        if (state == io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.On) filtersView.show();\n        else filtersView.hide();\n    }\n\n    private void refreshViewMode() {\n        if (viewMode == io.intino.goros.unit.box.ui.ViewMode.Full) {\n            if (selectedTask != null) hideViews();\n            else {\n                showViews();\n                close();\n            }\n        }\n        else showViews();\n    }\n\n    private void bindCurrentViewTo(io.intino.alexandria.ui.displays.components.Collection collection) {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "bind").multiple("\n"))).output(this.literal("\n    }\n\n    private void initFilters() {\n        filtersView.tasksFiltersStamp.readonly(readonly);\n        filtersView.tasksFiltersStamp.bindTo(currentCollection());\n        filtersView.tasksFiltersStamp.refresh();\n    }\n\n    private Task reloadSelected() {\n        if (selectedTask == null) return null;\n        return ComponentPersistence.getInstance().getTaskLayer().loadTask(selectedTask.getId());\n    }\n\n    private void open(SelectionEvent event) {\n        List<Task> selection = event.selection();\n        open(selection.size() > 0 ? selection.get(0) : null);\n    }\n\n    private void open(Task task) {\n        io.intino.alexandria.ui.displays.components.BlockConditional selectedView = selectedTaskView();\n        selectedTask = selectedView != null && selectedView.isVisible() && task == null ? null : task;\n        updateSelectedTaskViewVisibility(selectedTask != null);\n    }\n\n    private BlockConditional selectedTaskView() {\n        if (selectedTask == null) return null;\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "selectedView").multiple("\n"))).output(this.literal("\n        return null;\n    }\n\n    private void close() {\n        selectedTask = null;\n        enableCollapse(false);\n        updateSelectedTaskViewVisibility(false);\n    }\n\n    private void updateSelectedTaskViewVisibility(boolean visible) {\n        if (visible) {\n            if (filtersView.isVisible()) {\n                toggleFiltersViewVisibility(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.Off);\n                if (toggleFiltersListener != null) toggleFiltersListener.accept(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State.Off);\n            }\n            showSelectedTaskView();\n        }\n        else hideChildViews();\n    }\n\n    private void showFilters() {\n        if (showFiltersListener != null) showFiltersListener.accept(true);\n        if (!filtersView.isVisible()) return;\n        filtersView.show();\n        filtersView.refresh();\n    }\n\n    private void showSelectedTaskView() {\n        if (viewMode == io.intino.goros.unit.box.ui.ViewMode.Full) hideViews();\n        if (selectedTask == null) return;\n        BlockConditional selectedView = selectedTaskView();\n        if (selectedView == null) return;\n        if (!selectedView.isVisible()) hideChildViews();\n        selectedView.show();\n        enableCollapse(true);\n    }\n\n    private void hideChildViews() {\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "hide").multiple("\n"))).output(this.literal("\n        enableCollapse(false);\n    }\n\n    private void refreshCollapse() {\n        viewsToolbar.visible(selectedTask != null);\n        views.visible(true);\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "hideCollectionCall").multiple("\n"))).output(this.literal("\n    }\n\n    private void enableCollapse(boolean value) {\n        boolean visible = value && views.isVisible();\n        viewsToolbar.visible(visible);\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "enableCollapseCall").multiple("\n"))).output(this.literal("\n    }\n\n    private void showViews() {\n        views.visible(true);\n        enableCollapse(selectedTask != null);\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("process", "hideCollectionCall").multiple("\n"))).output(this.literal("\n    }\n\n    private void hideViews() {\n        views.visible(false);\n        enableCollapse(selectedTask != null);\n        ")).output(this.expression(new Rule.Output[0]).output(this.mark("toolbar", "showCollectionCall").multiple("\n"))).output(this.literal("\n    }\n\n}")), this.rule().condition(this.type("tasks"), new Rule.Condition[0]).output(this.literal("package ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.ui.displays.templates;\n\nimport ")).output(this.mark("package", new String[0])).output(this.literal(".")).output(this.mark("module", "lowerCase")).output(this.literal(".box.")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box;\nimport io.intino.alexandria.ui.displays.components.Collection;\nimport io.intino.alexandria.ui.displays.events.Event;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.goros.unit.box.ui.datasources.TaskInboxDatasource;\nimport io.intino.goros.unit.box.ui.datasources.TaskListDatasource;\nimport io.intino.goros.unit.util.Formatters;\n\nimport java.util.List;\n\npublic class TasksTemplate extends AbstractTasksTemplate<")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box> {\n    private String view;\n    private String folder;\n    private String sorting;\n    private String sortingMode;\n    private TaskInboxDatasource source;\n    private TaskListDatasource.Inbox inbox;\n    private boolean readonly = true;\n\n    public TasksTemplate(")).output(this.mark("boxName", "firstUpperCase")).output(this.literal("Box box) {\n        super(box);\n    }\n\n    public TasksTemplate folder(String folder) {\n        this.folder = folder;\n        return this;\n    }\n\n    public TasksTemplate inbox(TaskListDatasource.Inbox inbox) {\n        this.inbox = inbox;\n        return this;\n    }\n\n    public TasksTemplate readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public boolean editing() {\n        return !readonly;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        initToolbar();\n        initSortings();\n        initContent();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        label.value(translate(inbox == io.intino.goros.unit.box.ui.datasources.TaskListDatasource.Inbox.TaskBoard ? \"Tasks\" : \"My tasks\"));\n        refreshContent();\n        if (viewSelector.selection().size() <= 0) viewSelector.select(view);\n        else viewSelector.select(viewSelector.selection().get(0));\n    }\n\n    private void initToolbar() {\n        if (view == null) view = \"list\";\n        viewSelector.onSelect(this::selectView);\n        filters.onToggle(e -> toggleFilters(e.state()));\n        toggleView.state(ToggleEvent.State.Off);\n        toggleView.onToggle(e -> toggleView(e.state()));\n        DownloadDialog.onOpen(e -> refreshDownloadDialog());\n    }\n\n    private void initSortings() {\n        sortings.onSelect(this::selectSortingMode);\n        sortingsMode.add(\"Ascendente\");\n        sortingsMode.add(\"Descendente\");\n        sortingsMode.onSelect(this::selectSorting);\n        removeSorting.onExecute(this::removeSorting);\n    }\n\n    private void initContent() {\n        content.onItemsCountChange(this::refreshCount);\n        content.onShowFilters(e -> refreshSortings());\n        content.onToggleFilters(this::refreshToggleFiltersButton);\n        content.onToggleView(this::refreshToggleViewButton);\n        content.bindTo(search);\n    }\n\n    private void refreshCount(long countValue) {\n        count.value(Formatters.countMessage(countValue, translate(\"Task\").toLowerCase(), translate(\"Tasks\").toLowerCase()));\n    }\n\n    private void refreshContent() {\n        content.view(view);\n        content.inbox(inbox);\n        content.source(source());\n        content.readonly(readonly);\n        content.refresh();\n    }\n\n    private TaskInboxDatasource source() {\n        if (source == null) source = new TaskInboxDatasource(box().unit(), session(), inbox);\n        return source;\n    }\n\n    private void refreshDownloadDialog() {\n        DownloadDialog.dialog.onTerminate(e -> DownloadDialog.close());\n        DownloadDialog.dialog.inbox(inbox.name().toLowerCase());\n        DownloadDialog.dialog.condition(java.util.Objects.requireNonNull(currentCollection()).condition());\n        DownloadDialog.dialog.filters(java.util.Objects.requireNonNull(currentCollection()).filters());\n        DownloadDialog.dialog.sorting(selectedSortingCode(), sortingsMode.selection().size() > 0 ? sortingsMode.selection().get(0) : \"Ascendente\");\n        DownloadDialog.dialog.columns(io.intino.goros.unit.util.TaskHelper.downloadColumns(language()));\n        DownloadDialog.dialog.refresh();\n    }\n\n    private void selectView(SelectionEvent e) {\n        content.view((String) e.selection().get(0));\n        content.refresh();\n    }\n\n    private static final java.util.Map<String, List<String>> sortingsMap = new java.util.HashMap<>() {{\n        put(\"table\", List.of(\"T\u00edtulo\", \"Fecha de creaci\u00f3n\", \"Fecha de actualizaci\u00f3n\"));\n        put(\"list\", List.of(\"T\u00edtulo\", \"Fecha de creaci\u00f3n\", \"Fecha de actualizaci\u00f3n\"));\n    }};\n    private static final java.util.Map<String, String> sortingsCodesMap = new java.util.HashMap<>() {{\n        put(\"table_T\u00edtulo\", \"label\");\n        put(\"table_Fecha de actualizaci\u00f3n\", \"update_date\");\n        put(\"table_Fecha de creaci\u00f3n\", \"create_date\");\n        put(\"list_T\u00edtulo\", \"label\");\n        put(\"list_Fecha de actualizaci\u00f3n\", \"update_date\");\n        put(\"list_Fecha de creaci\u00f3n\", \"create_date\");\n    }};\n    private void refreshSortings() {\n        if (content.tableView.isVisible()) refreshSortings(sortingsMap.get(\"table\"));\n        if (content.listView.isVisible()) refreshSortings(sortingsMap.get(\"list\"));\n    }\n\n    private void refreshSortings(List<String> sortingList) {\n        sortingsBlock.visible(sortingList.size() > 0);\n        sortings.clear();\n        sortingList.forEach(s -> sortings.add(s));\n        sortingsMode.select(defaultSortingMode());\n        sortings.select(defaultSorting());\n    }\n\n    private String defaultSorting() {\n        return sorting != null ? sorting : \"Fecha de creaci\u00f3n\";\n    }\n\n    private String defaultSortingMode() {\n        return sortingMode != null ? sortingMode : \"Descendente\";\n    }\n\n    private void selectSortingMode(SelectionEvent e) {\n        this.sorting = e.selection().size() > 0 ? (String) e.selection().get(0) : null;\n        this.sortingsMode.visible(sorting != null);\n        if (sortingsMode.selection().size() <= 0) sortingsMode.select(\"Ascendente\");\n        else selectSorting(sorting, sorting != null ? sortingsMode.selection().get(0) : null);\n    }\n\n    private void selectSorting(SelectionEvent e) {\n        sortingMode = (String) e.selection().get(0);\n        selectSorting(sorting, sortingMode);\n    }\n\n    private void selectSorting(String sorting, String mode) {\n        removeSorting.visible(sorting != null);\n        if (content.tableView.isVisible()) content.tableView.tableViewStamp.selectSorting(sortingsCodesMap.get(\"table_\"+sorting), mode);\n        if (content.listView.isVisible()) content.listView.listViewStamp.selectSorting(sortingsCodesMap.get(\"list_\"+sorting), mode);\n    }\n\n    private String selectedSortingCode() {\n        if (content.tableView.isVisible()) return sortingsCodesMap.get(\"table_\"+sorting);\n        if (content.listView.isVisible()) return sortingsCodesMap.get(\"list_\"+sorting);\n        return \"label\";\n    }\n\n    private void removeSorting(Event event) {\n        sortings.select();\n    }\n\n    private Collection currentCollection() {\n        return content.currentCollection();\n    }\n\n    private void toggleFilters(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        content.toggleFilters(state);\n    }\n\n    private void toggleView(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        content.toggleView(state);\n    }\n\n    private void refreshToggleFiltersButton(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        filters.state(state);\n    }\n\n    private void refreshToggleViewButton(io.intino.alexandria.ui.displays.events.actionable.ToggleEvent.State state) {\n        toggleView.state(state);\n    }\n\n}")), this.rule().condition(this.type("process"), this.trigger("init")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.onShow(e -> {\n    bindCurrentViewTo(currentCollection());\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.task(reloadSelected());\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.inbox(inbox);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.readonly(readonly);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onChange(this::refresh);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onAbort(e1 -> {\n        close();\n        refresh();\n    });\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.onShowCollection(node -> {\n        if (viewMode == io.intino.goros.unit.box.ui.ViewMode.Full) close();\n        showViews();\n    });\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showLabel(true);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.viewMode(viewMode);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n    if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.selectedView() == null) ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.selectDefaultView();\n});")), this.rule().condition(this.type("process"), this.trigger("hide")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.hide();")), this.rule().condition(this.type("process"), this.trigger("bind")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.isVisible()) ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.bindTo(collection);")), this.rule().condition(this.type("process"), this.trigger("enablecollapsecall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.isVisible()) {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.viewMode(!visible ? viewMode : null);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showCollectionVisibility();\n}")), this.rule().condition(this.type("process"), this.trigger("showcollectioncall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.isVisible()) {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.viewMode(ViewMode.Full);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showCollectionVisibility();\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n}")), this.rule().condition(this.type("process"), this.trigger("hidecollectioncall")).output(this.literal("if (")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.isVisible()) {\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.viewMode(null);\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.showCollectionVisibility();\n    ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View.")).output(this.mark("name", "firstLowerCase")).output(this.literal("Stamp.refresh();\n}")), this.rule().condition(this.type("process"), this.trigger("selectedview")).output(this.literal("if (selectedTask.getCode().equals(\"")).output(this.mark("code", new String[0])).output(this.literal("\")) return ")).output(this.mark("name", "firstLowerCase")).output(this.literal("View;")));
    }
}

