/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.monet.renderers.definition;

import io.intino.goros.modernizing.Modernization;
import io.intino.goros.modernizing.monet.Dictionary;
import io.intino.goros.modernizing.monet.renderers.Renderer;
import io.intino.itrules.FrameBuilder;
import org.monet.metamodel.BooleanFieldProperty;
import org.monet.metamodel.CheckFieldProperty;
import org.monet.metamodel.CompositeFieldProperty;
import org.monet.metamodel.CompositeFieldPropertyBase;
import org.monet.metamodel.DateFieldProperty;
import org.monet.metamodel.FieldProperty;
import org.monet.metamodel.FileFieldProperty;
import org.monet.metamodel.IndexDefinition;
import org.monet.metamodel.IndexDefinitionBase;
import org.monet.metamodel.LinkFieldProperty;
import org.monet.metamodel.MemoFieldProperty;
import org.monet.metamodel.MultipleableFieldProperty;
import org.monet.metamodel.NodeFieldProperty;
import org.monet.metamodel.NumberFieldProperty;
import org.monet.metamodel.PictureFieldProperty;
import org.monet.metamodel.SelectFieldProperty;
import org.monet.metamodel.SerialFieldProperty;
import org.monet.metamodel.SummationFieldProperty;
import org.monet.metamodel.TextFieldProperty;
import org.monet.metamodel.internal.Ref;

public class FieldRenderer
extends Renderer {
    private final FieldProperty fieldProperty;
    private CompositeFieldProperty parentProperty;

    public FieldRenderer(Dictionary dictionary, Modernization modernization, FieldProperty fieldProperty) {
        super(dictionary, modernization);
        this.fieldProperty = fieldProperty;
    }

    public FieldRenderer parent(CompositeFieldProperty composite) {
        this.parentProperty = composite;
        return this;
    }

    @Override
    public void write() {
    }

    protected FrameBuilder buildFrame() {
        FrameBuilder result = this.baseFrame().add("field");
        result.add("code", this.fieldProperty.getCode());
        result.add("name", this.fieldProperty.getName());
        result.add("label", this.clean(this.fieldProperty.getLabel()));
        result.add("type", this.type());
        result.add("readonly", this.fieldProperty.isReadonly() ? "true" : "readonly");
        result.add("univocal", this.baseFrame().add("univocal").add(this.fieldProperty.isUnivocal() ? "prototype" : ""));
        this.addTypes(result);
        this.addMultipleProperties(result);
        this.addTextProperties(result);
        this.addLinkProperties(result);
        this.addCompositeProperties(result);
        return result;
    }

    private void addTypes(FrameBuilder builder) {
        builder.add(this.type());
        if (this.fieldProperty.isMultiple()) {
            builder.add("multiple");
            FrameBuilder addProperties = this.addPropertiesFrame(this.fieldProperty);
            if (addProperties != null) {
                builder.add("addProperties", addProperties);
            }
        }
    }

    private FrameBuilder addPropertiesFrame(FieldProperty fieldProperty) {
        if (!(fieldProperty instanceof CompositeFieldProperty)) {
            return null;
        }
        CompositeFieldProperty compositeField = (CompositeFieldProperty)fieldProperty;
        CompositeFieldPropertyBase.ViewProperty view = compositeField.getView();
        if (view == null || view.getMode() != CompositeFieldPropertyBase.ViewProperty.ModeEnumeration.COMPACT) {
            return null;
        }
        FrameBuilder result = new FrameBuilder().add("addProperties");
        view.getSummary().getField().forEach(f -> result.add("add", this.addPropertiesItemFrame(((CompositeFieldProperty)fieldProperty).getField(f.getValue()))));
        return result;
    }

    private FrameBuilder addPropertiesItemFrame(FieldProperty fieldProperty) {
        FrameBuilder result = new FrameBuilder("addPropertiesItem").add(this.type(fieldProperty));
        result.add("label", fieldProperty.getLabel());
        result.add("type", this.type(fieldProperty));
        result.add("code", fieldProperty.getCode());
        return result;
    }

    private void addMultipleProperties(FrameBuilder builder) {
        if (!this.fieldProperty.isMultiple()) {
            return;
        }
        MultipleableFieldProperty multipleField = (MultipleableFieldProperty)this.fieldProperty;
        MultipleableFieldProperty.BoundaryProperty boundary = multipleField.getBoundary();
        builder.add("min", boundary != null ? boundary.getMin() : -1L);
        builder.add("max", boundary != null ? boundary.getMax() : -1L);
        builder.add("valueType", this.valueType(multipleField));
        builder.add("collapsed", this.collapsed(multipleField));
    }

    private String valueType(MultipleableFieldProperty field) {
        if (field instanceof TextFieldProperty || field instanceof MemoFieldProperty) {
            return "java.lang.String";
        }
        if (field instanceof NumberFieldProperty) {
            return "org.monet.bpi.types.Number";
        }
        if (field instanceof DateFieldProperty) {
            return "org.monet.bpi.types.Date";
        }
        if (field instanceof FileFieldProperty) {
            return "org.monet.bpi.types.File";
        }
        if (field instanceof PictureFieldProperty) {
            return "org.monet.bpi.types.Picture";
        }
        if (field instanceof LinkFieldProperty) {
            return "org.monet.bpi.types.Link";
        }
        if (field instanceof SelectFieldProperty) {
            return "org.monet.bpi.types.Term";
        }
        if (field instanceof NodeFieldProperty || field instanceof CompositeFieldProperty) {
            return "java.util.List<org.monet.bpi.Field<?>>";
        }
        return null;
    }

    private boolean collapsed(MultipleableFieldProperty field) {
        if (field instanceof CompositeFieldProperty) {
            CompositeFieldPropertyBase.ViewProperty view = ((CompositeFieldProperty)field).getView();
            return view != null && view.getMode() == CompositeFieldPropertyBase.ViewProperty.ModeEnumeration.COMPACT;
        }
        return false;
    }

    private void addTextProperties(FrameBuilder builder) {
        if (!this.fieldProperty.isText()) {
            return;
        }
        TextFieldProperty textField = (TextFieldProperty)this.fieldProperty;
        TextFieldProperty.EditionProperty edition = textField.getEdition();
        if (edition == null) {
            return;
        }
        TextFieldProperty.EditionProperty.ModeEnumeration mode = edition.getMode();
        if (mode == TextFieldProperty.EditionProperty.ModeEnumeration.UPPERCASE) {
            builder.add("textMode", "Uppercase");
        } else if (mode == TextFieldProperty.EditionProperty.ModeEnumeration.LOWERCASE) {
            builder.add("textMode", "Lowercase");
        } else if (mode == TextFieldProperty.EditionProperty.ModeEnumeration.TITLE) {
            builder.add("textMode", "Capitalize");
        }
    }

    private void addLinkProperties(FrameBuilder builder) {
        if (!this.fieldProperty.isLink()) {
            return;
        }
        LinkFieldProperty linkField = (LinkFieldProperty)this.fieldProperty;
        Ref index = linkField.getSource().getIndex();
        Ref view = linkField.getSource().getView();
        IndexDefinition definition = this.dictionary.getIndexDefinition(index.getValue());
        IndexDefinitionBase.IndexViewProperty viewProperty = view != null ? definition.getView(view.getValue()) : definition.getDefaultView();
        builder.add("index", this.nameOf(definition));
        builder.add("indexCode", definition.getCode());
        builder.add("indexView", this.indexView(definition, viewProperty));
    }

    private String indexView(IndexDefinition definition, IndexDefinitionBase.IndexViewProperty viewProperty) {
        if (viewProperty != null) {
            return this.nameOf(viewProperty);
        }
        IndexDefinitionBase.IndexViewProperty defaultView = definition.getDefaultView();
        if (defaultView != null) {
            return this.nameOf(defaultView);
        }
        return definition.getViewList().size() > 0 ? this.nameOf(definition.getViewList().iterator().next()) : "";
    }

    private void addCompositeProperties(FrameBuilder builder) {
        if (!this.fieldProperty.isComposite()) {
            return;
        }
        CompositeFieldProperty compositeField = (CompositeFieldProperty)this.fieldProperty;
        compositeField.getAllFieldPropertyList().forEach(f -> {
            FieldRenderer renderer = this.renderer((FieldProperty)f, compositeField);
            builder.add("field", renderer.buildFrame());
        });
    }

    private String type() {
        return this.type(this.fieldProperty);
    }

    private String type(FieldProperty fieldProperty) {
        if (fieldProperty instanceof TextFieldProperty) {
            return "text";
        }
        if (fieldProperty instanceof NumberFieldProperty) {
            return "number";
        }
        if (fieldProperty instanceof BooleanFieldProperty) {
            return "boolean";
        }
        if (fieldProperty instanceof DateFieldProperty) {
            return "date";
        }
        if (fieldProperty instanceof MemoFieldProperty) {
            return "memo";
        }
        if (fieldProperty instanceof SerialFieldProperty) {
            return "serial";
        }
        if (fieldProperty instanceof FileFieldProperty) {
            return "file";
        }
        if (fieldProperty instanceof PictureFieldProperty) {
            return "picture";
        }
        if (fieldProperty instanceof CheckFieldProperty) {
            return "check";
        }
        if (fieldProperty instanceof LinkFieldProperty) {
            return "link";
        }
        if (fieldProperty instanceof SelectFieldProperty) {
            return "select";
        }
        if (fieldProperty instanceof CompositeFieldProperty) {
            return "composite";
        }
        if (fieldProperty instanceof NodeFieldProperty) {
            return "node";
        }
        if (fieldProperty instanceof SummationFieldProperty) {
            return "summation";
        }
        return "";
    }
}

