/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.formatters.inflectors;

import io.intino.itrules.formatters.StringFormatters;

public class EnglishPluralInflector
extends StringFormatters.PluralInflector {
    @Override
    public String plural(String word) {
        if (this.isIrregular(word)) {
            return this.irregularPlural(word);
        }
        return this.doReplaces(word + "s");
    }

    @Override
    protected void setReplaces() {
        this.addReplace("sss", "sses");
        this.addReplace("ss", "ses");
        this.addReplace("shs", "shes");
        this.addReplace("chs", "ches");
        this.addReplace("xs", "xes");
        this.addReplace("zzs", "zzes");
        this.addReplace("zs", "zzes");
        this.addReplace("fes", "ves");
        this.addReplace("fs", "ves");
        this.addReplace("siss", "ses");
        this.setConsonantYReplaces();
    }

    private void setConsonantYReplaces() {
        for (char consonant : this.consonants()) {
            this.addReplace(consonant + "ys", consonant + "ies");
        }
    }

    @Override
    protected void setIrregulars() {
        this.addIrregular("man", "men");
        this.addIrregular("woman", "women");
        this.addIrregular("child", "children");
        this.addIrregular("foot", "feet");
        this.addIrregular("tooth", "teeth");
        this.addIrregular("goose", "geese");
        this.addIrregular("mouse", "mice");
        this.addIrregular("sheep", "sheep");
        this.addIrregular("deer", "deer");
        this.addIrregular("moose", "moose");
        this.addIrregular("aircraft", "aircraft");
        this.addIrregular("potato", "potatoes");
        this.addIrregular("tomato", "tomatoes");
        this.addIrregular("echo", "echoes");
        this.addIrregular("hero", "heroes");
        this.addIrregular("torpedo", "torpedoes");
        this.addIrregular("buffalo", "buffaloes");
    }
}

