/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.formatters;

import io.intino.itrules.Formatter;
import io.intino.itrules.formatters.inflectors.EnglishPluralInflector;
import io.intino.itrules.formatters.inflectors.SpanishPluralInflector;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class StringFormatters {
    public static Map<String, Formatter> get(Locale locale) {
        HashMap<String, Formatter> map = StringFormatters.map();
        map.put("UpperCase", StringFormatters.upperCase());
        map.put("LowerCase", StringFormatters.lowerCase());
        map.put("FirstUpperCase", StringFormatters.firstUpperCase());
        map.put("FirstLowerCase", StringFormatters.firstLowerCase());
        map.put("Camelcase", StringFormatters.camelCase());
        map.put("LowerCamelCase", StringFormatters.lowerCamelCase());
        map.put("SnakeCase", StringFormatters.snakeCase());
        map.put("Capitalize", StringFormatters.capitalize());
        map.put("Length", StringFormatters.length());
        map.put("OnlyDigits", StringFormatters.onlyDigits());
        map.put("OnlyLetters", StringFormatters.onlyLetters());
        map.put("OnlyDigitsAndLetters", StringFormatters.onlyDigitsAndLetters());
        map.put("Plural", StringFormatters.plural(locale));
        return map;
    }

    public static Formatter onlyDigitsAndLetters() {
        return value -> value.toString().replaceAll("[^0-9A-Za-z]", "");
    }

    public static Formatter onlyLetters() {
        return value -> value.toString().replaceAll("[^A-Za-z]", "");
    }

    public static Formatter onlyDigits() {
        return value -> value.toString().replaceAll("[^0-9]", "");
    }

    public static HashMap<String, Formatter> map() {
        return new HashMap<String, Formatter>(){

            @Override
            public Formatter put(String key, Formatter value) {
                return super.put(key.toLowerCase(), value);
            }
        };
    }

    public static Formatter upperCase() {
        return value -> value.toString().toUpperCase();
    }

    public static Formatter lowerCase() {
        return value -> value.toString().toLowerCase();
    }

    public static Formatter camelCase() {
        return value -> {
            String[] parts = value.toString().split(" ");
            String result = "";
            for (String part : parts) {
                result = result + StringFormatters.capitalize().format(part);
            }
            return result;
        };
    }

    public static Formatter lowerCamelCase() {
        return value -> {
            String[] parts = value.toString().split(" ");
            String result = "";
            for (String part : parts) {
                result = result + StringFormatters.capitalize().format(part);
            }
            return result.substring(0, 1).toLowerCase() + result.substring(1);
        };
    }

    public static Formatter snakeCase() {
        return value -> value.toString().toLowerCase().replaceAll(" ", "-");
    }

    public static Formatter firstUpperCase() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toUpperCase() + value.toString().substring(1);
    }

    public static Formatter firstLowerCase() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toLowerCase() + value.toString().substring(1);
    }

    public static Formatter capitalize() {
        return value -> value.toString().isEmpty() ? "" : value.toString().substring(0, 1).toUpperCase() + value.toString().substring(1).toLowerCase();
    }

    public static Formatter length() {
        return value -> String.valueOf(value.toString().length());
    }

    private static Formatter plural(Locale locale) {
        PluralInflector pluralInflector = locale.getLanguage().equals("es") ? new SpanishPluralInflector() : new EnglishPluralInflector();
        return value -> pluralInflector.plural(value.toString());
    }

    public static abstract class PluralInflector {
        private Map<String, String> irregulars = new HashMap<String, String>();
        private Map<String, String> replaces = new HashMap<String, String>();

        public PluralInflector() {
            this.setIrregulars();
            this.setReplaces();
        }

        public abstract String plural(String var1);

        protected abstract void setReplaces();

        protected abstract void setIrregulars();

        protected void addReplace(String from, String to) {
            this.replaces.put(from, to);
        }

        protected void addIrregular(String from, String to) {
            this.irregulars.put(from, to);
        }

        protected String doReplaces(String word) {
            for (String ending : this.replaces.keySet()) {
                if (!word.endsWith(ending)) continue;
                return this.replaceLast(word, ending);
            }
            return word;
        }

        protected char[] consonants() {
            return "bcdfghjklmnpqrstvwxyz".toCharArray();
        }

        protected boolean isIrregular(String word) {
            return this.irregulars.containsKey(word);
        }

        protected String irregularPlural(String word) {
            return this.irregulars.get(word);
        }

        private String replaceLast(String word, String ending) {
            return this.removeEnding(word, ending) + this.replaces.get(ending);
        }

        private String removeEnding(String word, String ending) {
            return word.substring(0, word.length() - ending.length());
        }
    }
}

