/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SetsTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("taskSet", "tasksummaryitem")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;\nimport io.intino.alexandria.ui.model.datasource.Group;\nimport io.intino.alexandria.ui.model.datasource.PageDatasource;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.ui.utils.Formatters;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.rows.TaskSummaryItemDetailsTableRow;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.InputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.time.Instant;\nimport java.util.ArrayList;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.stream.Collectors;\n\npublic class TaskSummaryItem extends AbstractTaskSummaryItem<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String _prefix;\n    private String _title;\n    private Map<TaskSetItem, String> affectedTasks;\n\n    public TaskSummaryItem(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void refresh(String prefix, String title, Map<TaskSetItem, String> lines) {\n        this._prefix = prefix;\n        this._title = title;\n        this.affectedTasks = lines;\n        refresh();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        taskSummaryItemDetailsTable.onAddItem(this::refreshDetailItem);\n        detailsDialog.onOpen(e -> refreshDetailsDialog());\n        download.onExecute(e -> downloadLines());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(_title);\n        countLink.value(Formatters.formattedNumber(affectedTasks.size(), language()));\n        details.visible(affectedTasks.size() > 0);\n    }\n\n    private UIFile downloadLines() {\n        return new UIFile() {\n            @Override\n            public String label() {\n                return _prefix + \"_\" + Formatters.downloadDate(Instant.now(), language(), \"tsv\");\n            }\n\n            @Override\n            public InputStream content() {\n                return new ByteArrayInputStream(String.join(\"\\n\", affectedTasks()).getBytes(StandardCharsets.UTF_8));\n            }\n\n            private List<String> affectedTasks() {\n                List<String> lines = affectedTasks.entrySet().stream().map(this::lineOf).collect(Collectors.toList());\n                lines.add(0, headerLine());\n                return lines;\n            }\n\n            private String headerLine() {\n                StringBuilder result = new StringBuilder();\n                result.append(\"Nombre\").append(\"\\t\");\n                result.append(\"Referencia\").append(\"\\t\");\n                result.append(\"Objeto relacionado\").append(\"\\t\");\n                result.append(\"Servicio web\").append(\"\\t\");\n                result.append(\"Creador\").append(\"\\t\");\n                result.append(\"Realizador\").append(\"\\t\");\n                result.append(\"Proceso\").append(\"\\t\");\n                result.append(\"Fecha de creaci\u00f3n\").append(\"\\t\");\n                result.append(\"Fecha de caducidad\").append(\"\\t\");\n                result.append(\"Fecha de aviso\").append(\"\\t\");\n                result.append(\"Fecha de realizaci\u00f3n\").append(\"\\t\");\n                result.append(\"Estado\").append(\"\\t\");\n                result.append(\"Repetida\").append(\"\\t\");\n                result.append(\"Dias restantes\").append(\"\\t\");\n                result.append(\"Observaciones\");\n                return result.toString();\n            }\n\n            private String lineOf(Map.Entry<TaskSetItem, String> info) {\n                StringBuilder result = new StringBuilder();\n                TaskSetItem item = info.getKey();\n                result.append(item.name()).append(\"\\t\");\n                result.append(item.reference() != null ? item.reference().name() : \"\").append(\"\\t\");\n                result.append(item.relatedObject() != null ? item.relatedObject().name() : \"\").append(\"\\t\");\n                result.append(emptyForNull(item.webService())).append(\"\\t\");\n                result.append(emptyForNull(item.createdBy())).append(\"\\t\");\n                result.append(emptyForNull(item.madeBy())).append(\"\\t\");\n                result.append(item.process() != null ? item.process().name() : \"\").append(\"\\t\");\n                result.append(emptyForNull(item.createDate())).append(\"\\t\");\n                result.append(emptyForNull(item.dueDate())).append(\"\\t\");\n                result.append(emptyForNull(item.adviseDate())).append(\"\\t\");\n                result.append(emptyForNull(item.madeDate())).append(\"\\t\");\n                result.append(item.state().title()).append(\"\\t\");\n                result.append(item.repeated() ? \"S\u00ed\" : \"No\").append(\"\\t\");\n                result.append(item.daysLeft()).append(\"\\t\");\n                result.append(info.getValue());\n                return result.toString();\n            }\n\n            private String emptyForNull(String value) {\n                return value != null ? value : \"\";\n            }\n\n            private String emptyForNull(Instant value) {\n                return value != null ? Formatters.dateTime(value, language(), w -> translate(w)) : \"\";\n            }\n        };\n    }\n\n    private void refreshDetailsDialog() {\n        taskSummaryItemDetailsTable.source(detailsSource());\n        taskSummaryItemDetailsTable.reload();\n    }\n\n    private PageDatasource<TaskSetItem> detailsSource() {\n        return new PageDatasource<>() {\n            @Override\n            public List<TaskSetItem> items(int start, int count, String condition, List list, List sortings) {\n                List<TaskSetItem> result = new ArrayList<>(affectedTasks.keySet());\n                int from = Math.min(start, result.size());\n                int end = Math.min(start + count, result.size());\n                return result.subList(from, end);\n            }\n\n            @Override\n            public long itemCount(String condition, List list) {\n                return affectedTasks.size();\n            }\n\n            @Override\n            public List<Group> groups(String key) {\n                return Collections.emptyList();\n            }\n        };\n    }\n\n    private void refreshDetailItem(AddCollectionItemEvent event) {\n        TaskSetItem item = event.item();\n        TaskSummaryItemDetailsTableRow row = event.component();\n        row.tsummaryidtNombreItem.nombre.value(item.name());\n        row.tsummaryidtReferenciaItem.referencia.value(item.reference() != null ? item.reference().name() : \"-\");\n        row.tsummaryidtCreadorItem.creador.value(item.createdBy());\n        row.tsummaryidtFechaCreacionItem.fechaCreacion.value(item.createDate());\n        row.tsummaryidtObservacionesItem.observaciones.value(affectedTasks.get(item));\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("taskSet", "taskadvise")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.model.TaskAdvise;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.entity.task.TGTaskStatus;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class TaskAdviseTemplate extends AbstractTaskAdviseTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGTask task;\n    private TaskAdvise advise;\n    private Consumer<TaskAdvise> removeListener;\n\n    public TaskAdviseTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public TaskAdviseTemplate task(TGTask task) {\n        this.task = task;\n        return this;\n    }\n\n    public TaskAdviseTemplate advise(TaskAdvise advise) {\n        this.advise = advise;\n        return this;\n    }\n\n    public TaskAdviseTemplate onRemove(Consumer<TaskAdvise> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        remove.onExecute(e -> removeListener.accept(advise));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        createDate.value(advise.date());\n        message.value(advise.message());\n        remove.visible(task.getStatus() != TGTaskStatus.tsFinished && task.getStatus() != TGTaskStatus.tsAborted);\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("taskSet", "task")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.Actionable;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.SignAction;\nimport io.intino.alexandria.ui.displays.components.addressable.Addressed;\nimport io.intino.alexandria.ui.displays.components.SignDocument.BeforeSignChecker;\nimport io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;\nimport io.intino.alexandria.ui.displays.events.actionable.OpenLayerEvent;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetItemDatasource;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetItemEvolutionDatasource;\nimport io.intino.goros.egeasy.box.ui.model.TaskAdvise;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.ui.model.TaskState;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.m3.entity.field.TGFieldApproval;\nimport io.intino.goros.egeasy.m3.file.FileContent;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.document.TGDocument;\nimport io.intino.goros.egeasy.m3.entity.field.TGField;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.entity.task.TGTaskStatus;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\nimport io.intino.goros.egeasy.m3.library.LibraryTask;\nimport io.intino.goros.egeasy.m3.utils.DefinitionUtils;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.items.TaskEvolutionItem;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.InputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\n\npublic class TaskTemplate extends AbstractTaskTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGRoom room;\n    private TGTask task;\n    private TGContainer taskTarget;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<TGTask> backListener;\n    private Consumer<TGTask> gotoTaskListener;\n    private Function<TGTask, ValidateResult> beforeFinishListener;\n    private Consumer<TGTask> beforeContinueWithWarnings;\n    private Consumer<ValidateResult> validationErrorsListener;\n    private TaskSetItemDatasource source;\n    private TaskSetItem selectedEvolutionTask;\n    private List<TaskSetItem> taskSelectorList;\n    private Mode mode = Mode.Full;\n    private ValidateResult warning;\n    private boolean ignoreWarnings = false;\n\n    public TaskTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public enum Mode { Full, Summary }\n\n    public void room(TGRoom room) {\n        this.room = room;\n    }\n\n    public void task(TGTask task) {\n        this.task = task;\n        this.taskTarget = task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty() ? (TGContainer) box().provider(session()).openResource(task.getTargetIdentifier().getERC(), task.getTargetIdentifier().getDRC()) : null;\n        this.source = new TaskSetItemDatasource(box().provider(session()), session(), task);\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n    }\n\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<TGTask> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    public void onGotoTask(Consumer<TGTask> listener) {\n        this.gotoTaskListener = listener;\n    }\n\n    public void onBeforeFinish(Function<TGTask, ValidateResult> listener) {\n        this.beforeFinishListener = listener;\n    }\n\n    public void onBeforeContinueWithWarnings(Consumer<TGTask> listener) {\n        this.beforeContinueWithWarnings = listener;\n    }\n\n    public void onValidationErrors(Consumer<ValidateResult> listener) {\n        this.validationErrorsListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        linkDomain.onExecute(e -> {\n            if (backListener == null) return;\n            backListener.accept(task);\n        });\n        start.onExecute(e -> start());\n        continueTask.onExecute(e -> continueTask());\n        assign.onExecute(e -> assign());\n        finish.onExecute(e -> finish());\n        finishWithSign.signFormat(SignAction.SignFormat.CAdES);\n        finishWithSign.onSign(e -> finishWithSign(e.signature()));\n        finishWithSign.beforeSignChecker(beforeSignChecker());\n        finishWithSign.documentProvider(this::signatureDocument);\n        release.onExecute(e -> release());\n        abort.onExecute(e -> abort());\n        addAdvise.onExecute(e -> addAdvise());\n        taskSelectorDialog.onOpen(e -> refreshTaskSelectorDialog());\n        taskSelector.onSelect(e -> openTask.readonly(e.selection().isEmpty()));\n        openTask.onExecute(e -> open(taskSelector.selection()));\n        addAdviseDialog.onOpen(e -> refreshAdviseDialog());\n        taskStarterStamp.onStarted(e -> refreshTaskStarted());\n        taskStarterStamp.onCancel(e -> start.readonly(false));\n        taskStarterStamp.onError(e -> start.readonly(false));\n        finishEditionSelector.onSelect(e -> finishEdition());\n        taskFormDialog.onOpen(e -> refreshTaskFormDialog());\n        taskFormDialog.onClose(e -> cancelTaskForm());\n        acceptTaskForm.onExecute(e -> saveTaskForm());\n        extraInfoBlock.onShow(e -> refreshExtraInfoBlock());\n        warningDialog.onOpen(e -> {\n            ignoreWarnings = false;\n            warningDialogMessage.value(DisplayHelper.errorMessage(warning));\n            continueTaskWithWarnings.readonly(warning.getValidateError() == null || !warning.getValidateError().isWarning());\n        });\n        continueTaskWithWarnings.onExecute(e -> continueTaskWithWarnings());\n        initTaskEvolution();\n    }\n\n    private BeforeSignChecker beforeSignChecker() {\n        return new BeforeSignChecker() {\n            OperationResult result;\n            @Override\n            public boolean check() {\n                if (taskTarget == null) return false;\n                TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n                if (signableField == null) return false;\n                finishWithSign.readonly(true);\n                ValidateResult validateResult = beforeFinishListener != null ? beforeFinishListener.apply(task) : null;\n                if (validateResult != null && !success(validateResult)) {\n                    if (validateResult.getValidateError().isWarning()) {\n                        warning = validateResult;\n                        warningDialog.open();\n                        notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n                    }\n                    else notifyUser(\"No se ha podido guardar el elemento antes de finalizar\", UserMessage.Type.Error);\n                    finishWithSign.readonly(false);\n                    return false;\n                }\n                result = box().provider(session()).checkAbilityToSign(taskTarget.getERC(), taskTarget.getDRC(), signableField.getDRC());\n                finishWithSign.readonly(false);\n                return result.isSuccess();\n            }\n\n            @Override\n            public String checkMessage() {\n                return result != null ? result.getMessage() : null;\n            }\n        };\n    }\n\n    private InputStream signatureDocument() {\n        finishWithSign.readonly(true);\n        ValidateResult result = beforeFinishListener != null ? beforeFinishListener.apply(task) : null;\n        if (result != null && !success(result)) {\n            notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            if (result != null && result.getValidateError() != null && !result.getValidateError().getFieldErrors().isEmpty() && validationErrorsListener != null) validationErrorsListener.accept(result);\n            warning = result;\n            warningDialog.open();\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return null;\n        }\n        TGDocument document = LibraryDocuments.getDocument(taskTarget);\n        String hash = box().provider(session()).loadDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC());\n        if (hash != null && !hash.isEmpty()) return new ByteArrayInputStream(hash.getBytes(StandardCharsets.UTF_8));\n        FileContent fileContent = box().provider(session()).openDocumentFile(taskTarget, document.getDRC(), false);\n        return fileContent != null ? fileContent.getContent() : null;\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        loadingBlock.visible(true);\n        icon.value(icon());\n        iconCopy.text(DisplayHelper.entityInfo(task));\n        title.value(task.getName() != null ? task.getName() : \"Tarea\");\n        linkDomain.title(backTitle);\n        if (backAddressResolver != null && linkDomain instanceof Addressed) ((Addressed<?>)linkDomain).address(backAddressResolver);\n        processBlock.visible(mode == Mode.Full && task.getDomainIdentifier().isEmpty());\n        taskBlock.visible(mode == Mode.Full && !task.getDomainIdentifier().isEmpty());\n        infoBlock.visible(mode == Mode.Full);\n        finishWithSign.refresh();\n        refreshProcessInfoBlock();\n        refreshRightPanel();\n        refreshReference();\n        refreshRelatedObject();\n        refreshState();\n        repeatedBlock.visible(task.isRecovered());\n        extraInfoBlock.visible(mode == Mode.Full && DefinitionUtils.hasTaskFields(task.getDefinition()) && task.getStatus() == TGTaskStatus.tsFinished);\n        refreshAdviseList();\n        refreshCommentBlock();\n        loadingBlock.visible(false);\n    }\n\n    private java.io.File icon() {\n        boolean isProcess = task.getDomainIdentifier() == null || task.getDomainIdentifier().isEmpty();\n        String icon = isProcess ? \"Process.ico\" : \"Task.ico\";\n        return new java.io.File(box().egeConfiguration().iconsDir() + \"/Sistema/\" + icon);\n    }\n\n    private void refreshRightPanel() {\n        rightPanelBlock.visible(mode == Mode.Full);\n        if (mode != Mode.Full) return;\n        refreshEvolution();\n    }\n\n    private void refreshProcessInfoBlock() {\n        TGIdentifier entity = task.getMainTaskIdentifier();\n        processInfoBlock.visible(mode == Mode.Full && entity != null && entity.getERC() != task.getERC());\n        if (entity == null || !processInfoBlock.isVisible()) return;\n        TaskSetItem task = TaskSetDatasourceHelper.itemOf(box().provider(session()).openResource(entity.getERC(), entity.getDRC()));\n        if (task == null) return;\n        TaskState state = task.state();\n        boolean currentTask = task.rrc() == this.task.getERC();\n        processTitle.visible(currentTask);\n        if (currentTask) processTitle.value(task.name());\n        processTitleLink.visible(!currentTask);\n        if (!currentTask) {\n            processTitleLink.title(task.name());\n            processTitleLink.onExecute(e -> open(task));\n        }\n        processCreateDate.visible(state != TaskState.Finished && state != TaskState.Aborted);\n        if (processCreateDate.isVisible()) processCreateDate.value(task.createDate());\n        processFinishedDate.visible(state == TaskState.Finished || state == TaskState.Aborted);\n        if (processFinishedDate.isVisible()) processFinishedDate.value(task.madeDate());\n    }\n\n    private void refreshEvolution() {\n        TGIdentifier entity = task.getMainTaskIdentifier();\n        if (entity == null) return;\n        taskEvolutionList.source(new TaskSetItemEvolutionDatasource(box().provider(session()), session(), task));\n    }\n\n    private void refreshReference() {\n        if (mode != Mode.Full) return;\n        TGIdentifier entity = task.getMainTargetIdentifier();\n        reference.visible(entity != null);\n        if (entity == null) return;\n        //reference.address(path -> path.replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC())));\n        reference.onExecute(e -> {\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> {\n                String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC()));\n                fillLayer(entity, l, entityLayerAddress);\n            });\n        });\n        reference.title(entity.getName());\n    }\n\n    private void refreshRelatedObject() {\n        relatedObjectBlock.visible(task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty());\n        if (mode != Mode.Full) return;\n        TGIdentifier entity = task.getTargetIdentifier();\n        relatedObject.visible(!entity.isEmpty());\n        //relatedObject.address(path -> path.replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC())));\n        relatedObject.onExecute(e -> {\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> {\n                String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(entity.getDRC())).replace(\":rrc\", String.valueOf(entity.getERC()));\n                fillLayer(entity, l, entityLayerAddress);\n            });\n        });\n        relatedObject.title(entity.getName());\n    }\n\n    private void refreshState() {\n        TaskState state = TaskState.from(task.getStatus());\n        refreshPending(state);\n        refreshStarted(state);\n        refreshFinished(state);\n    }\n\n    private void refreshPending(TaskState state) {\n        pendingBlock.visible(state == TaskState.NotWorking);\n        if (state != TaskState.NotWorking) return;\n        boolean isProcess = task.getDomainIdentifier() == null || task.getDomainIdentifier().isEmpty();\n        pendingTitle.value(state.title());\n        pendingTitle.backgroundColor(state.color());\n        pendingCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n        start.visible(!isProcess);\n    }\n\n    private void refreshStarted(TaskState state) {\n        startedBlock.visible(state == TaskState.Working);\n        if (state != TaskState.Working) return;\n        TGSessionInfo sessionInfo = box().provider(session()).sessionInfo();\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        boolean sameUser = sessionInfo != null && sessionInfo.getURC() == task.getWorkUserIdentifier().getERC();\n        boolean isProcess = task.getDomainIdentifier() == null || task.getDomainIdentifier().isEmpty();\n        startedTitle.value(state.title());\n        startedTitle.backgroundColor(state.color());\n        startedCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n        startedMadeDate.value(task.getWorkDate() != null ? task.getWorkDate().toInstant() : null);\n        TGIdentifier workUserIdentifier = task.getWorkUserIdentifier();\n        startedMadeUserBy.visible(!workUserIdentifier.isEmpty());\n        startedMadeUser.visible(!workUserIdentifier.isEmpty());\n        startedMadeUser.value(!workUserIdentifier.isEmpty() ? workUserIdentifier.getName() : null);\n        continueTask.visible(sameUser && mode == Mode.Full && !isProcess);\n        assign.visible(!sameUser && !isProcess);\n        finish.visible((sameUser || isProcess) && signableField == null);\n        if (finish.isVisible()) finish.highlight(mode == Mode.Summary ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);\n        finishWithSign.visible((sameUser || isProcess) && signableField != null);\n        if (finishWithSign.isVisible()) finishWithSign.highlight(mode == Mode.Summary ? Actionable.Highlight.Fill : Actionable.Highlight.Outline);\n        TGDocument document = taskTarget != null ? LibraryDocuments.getDocument(taskTarget) : null;\n        if (finishWithSign.isVisible() && document != null) {\n            String hash = box().provider(session()).loadDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC());\n            finishWithSign.signMode(hash != null && !hash.isEmpty() ? SignAction.SignMode.CounterSign : SignAction.SignMode.Sign);\n        }\n        release.visible(sameUser && !isProcess);\n        abort.visible(isProcess);\n    }\n\n    private void refreshFinished(TaskState state) {\n        finishedBlock.visible(state == TaskState.Finished || state == TaskState.Aborted);\n        if (state != TaskState.Finished && state != TaskState.Aborted) return;\n        finishedTitle.value(state.title());\n        finishedTitle.backgroundColor(state.color());\n        TGIdentifier workUserIdentifier = task.getWorkUserIdentifier();\n        finishedMadeDate.value(task.getWorkDate() != null ? task.getWorkDate().toInstant() : null);\n        finishedMadeUserBy.visible(!workUserIdentifier.isEmpty());\n        finishedMadeUser.visible(!workUserIdentifier.isEmpty());\n        finishedMadeUser.value(!workUserIdentifier.isEmpty() ? workUserIdentifier.getName() : null);\n        finishedCreateDate.value(task.getCreateDate() != null ? task.getCreateDate().toInstant() : null);\n    }\n\n    private void refreshAdviseList() {\n        adviseBlock.visible(false);\n        advises.clear();\n        source.advises(task).forEach(a -> fill(a, advises.add()));\n        adviseBlock.visible(true);\n        addAdviseTrigger.visible(task.getStatus() != TGTaskStatus.tsFinished && task.getStatus() != TGTaskStatus.tsAborted);\n    }\n\n    private void refreshCommentBlock() {\n        commentBlock.visible(task.getComment() != null && !task.getComment().isEmpty());\n        if (commentBlock.isVisible()) commentField.value(task.getComment());\n    }\n\n    private void refreshAdviseDialog() {\n        adviseDateField.min(java.time.Instant.now());\n        adviseDateField.value(null);\n        adviseMessageField.value(null);\n    }\n\n    private void fill(TaskAdvise advise, TaskAdviseTemplate display) {\n        display.task(task);\n        display.advise(advise);\n        display.onRemove(e -> removeAdvise(advise));\n        display.refresh();\n    }\n\n    private void fillLayer(io.intino.alexandria.ui.displays.components.Layer<?, ?> layer, String entityLayerAddress) {\n        fillLayer(task.getTargetIdentifier(), layer, entityLayerAddress);\n    }\n\n    private void fillLayer(TGIdentifier entity, io.intino.alexandria.ui.displays.components.Layer<?, ?> layer, String entityLayerAddress) {\n        RoomTemplate template = new RoomTemplate(box());\n        layer.title(entity.getName());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.onClose(e -> updateTask());\n        layer.template(template);\n        if (entityLayerAddress != null) box().routeManager().routeDispatcher().dispatch(soul(), entityLayerAddress);\n    }\n\n    private void start() {\n        start.readonly(true);\n        taskStarterStamp.task(task);\n        taskStarterStamp.start();\n    }\n\n    private void refreshTaskStarted() {\n        task = (TGTask) box().provider(session()).openResource(this.task.getERC(), this.task.getDRC());\n        if (soul().display(RoomTemplate.class).isEmbedded()) {\n            box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        }\n        else {\n            //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n            String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, entityLayerAddress));\n            updateTask();\n        }\n        start.readonly(false);\n    }\n\n    private void continueTask() {\n        int rrc = task.getTargetIdentifier().getERC();\n        if (!box().provider(session()).isEditingResource(rrc)) {\n            OperationResult operationResult = box().provider(session()).beginEditionResource(rrc);\n            if (!operationResult.isSuccess()) {\n                notifyUser(operationResult.getMessage(), io.intino.alexandria.ui.displays.UserMessage.Type.Error);\n                return;\n            }\n        }\n        if (soul().display(RoomTemplate.class).isEmbedded()) {\n            box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        }\n        else {\n            //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n            String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, entityLayerAddress));\n        }\n    }\n\n    private void assign() {\n        OperationResult operationResult = box().provider(session()).startWorkingTask(task.getERC(), task.getDRC(), false, false, null);\n        if (!operationResult.isSuccess()) {\n            notifyUser(operationResult.getMessage(), UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(\"Tarea apropiada\", UserMessage.Type.Success);\n        //entityLayerTrigger.address(path -> path.replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task));\n        String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getTargetIdentifier().getDRC())).replace(\":rrc\", String.valueOf(task.getTargetIdentifier().getERC())) + \"?context=\" + StringUtil.context(task);\n        ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, entityLayerAddress));\n        updateTask();\n    }\n\n    private void finishWithSign(String signature) {\n        finishWithSign.readonly(true);\n        TGDocument document = LibraryDocuments.getDocument(taskTarget);\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        if (!box().provider(session()).saveDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC(), signableField.getDRC(), signature)) {\n            notifyUser(\"No se ha podido finalizar la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        doFinish();\n    }\n\n    private void finish() {\n        finish.readonly(true);\n        ignoreWarnings = false;\n        ValidateResult result = beforeFinishListener != null ? beforeFinishListener.apply(task) : null;\n        if (result != null && !success(result)) {\n            if (result.getValidateError().isWarning()) {\n                warning = result;\n                warningDialog.open();\n                notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            }\n            else notifyUser(\"No se ha podido guardar el elemento antes de finalizar\", UserMessage.Type.Error);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        if (DefinitionUtils.hasTaskFields(task.getDefinition())) {\n            box().provider(session()).initializeTaskFields(task);\n            if (new io.intino.goros.egeasy.box.ui.datasources.TaskFormDatasource(box().provider(session()), session(), task, true).hasEditableFields()) {\n                taskFormDialog.open();\n                return;\n            }\n        }\n        doFinish();\n    }\n\n    private void doFinish() {\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        if (!saveDocumentApproval()) {\n            notifyUser(\"No se ha podido aprobar la tarea para su finalizaci\u00f3n\", UserMessage.Type.Info);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult validateResult = box().provider(session()).finishTask(task.getERC(), task.getDRC(), ignoreWarnings);\n        if (!success(validateResult)) {\n            notifyUser(\"Se necesita verificar los avisos pendientes\", UserMessage.Type.Info);\n            if (validateResult != null && validateResult.getValidateError() != null && !validateResult.getValidateError().getFieldErrors().isEmpty() && validationErrorsListener != null) validationErrorsListener.accept(validateResult);\n            warning = validateResult;\n            warningDialog.open();\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Tarea finalizada\", UserMessage.Type.Success);\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n        updateTask();\n        if (taskSelectorList.isEmpty() && soul().display(RoomTemplate.class).isEmbedded()) finishEditionDialog.open();\n        else if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n    }\n\n    private boolean saveDocumentApproval() {\n        TGFieldApproval approvalField = LibraryTask.findApprovalField(task, taskTarget);\n        if (approvalField == null) return true;\n        return box().provider(session()).saveDocumentApproval(taskTarget.getERC(), taskTarget.getDRC(), approvalField.getDRC());\n    }\n\n    private void continueTaskWithWarnings() {\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        warningDialog.close();\n        if (beforeContinueWithWarnings != null) beforeContinueWithWarnings.accept(task);\n        this.ignoreWarnings = true;\n        if (DefinitionUtils.hasTaskFields(task.getDefinition())) {\n            box().provider(session()).initializeTaskFields(task);\n            if (new io.intino.goros.egeasy.box.ui.datasources.TaskFormDatasource(box().provider(session()), session(), task, true).hasEditableFields()) {\n                taskFormDialog.open();\n                return;\n            }\n        }\n        doFinishWithWarnings();\n    }\n\n    private void doFinishWithWarnings() {\n        notifyUser(\"Finalizando tarea...\", UserMessage.Type.Loading);\n        io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult validateResult = box().provider(session()).finishTask(task.getERC(), task.getDRC(), true);\n        if (!success(validateResult)) {\n            notifyUser(validateResult.getMessage(), UserMessage.Type.Error);\n            if (validateResult != null && validateResult.getValidateError() != null && !validateResult.getValidateError().getFieldErrors().isEmpty() && validationErrorsListener != null) validationErrorsListener.accept(validateResult);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Tarea finalizada\", UserMessage.Type.Success);\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n        updateTask();\n        if (taskSelectorList.isEmpty() && soul().display(RoomTemplate.class).isEmbedded()) finishEditionDialog.open();\n        else if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n    }\n\n    private void open(List<String> selection) {\n        if (selection.isEmpty()) return;\n        open(taskSelectorList.stream().filter(t -> t.name().equals(selection.get(0))).findFirst().orElse(null));\n    }\n\n    private void open(TaskSetItem taskItem) {\n        open((TGTask) box().provider(session()).openResource(taskItem.rrc(), taskItem.drc()));\n    }\n\n    private void open(TGTask task) {\n        taskSelectorDialog.close();\n        gotoTask(task);\n    }\n\n    private void refreshRecoverTaskDialog() {\n        recoverMessage.value(\"Se va a retroceder a la tarea \" + selectedEvolutionTask.name());\n    }\n\n    private void refreshTaskSelectorDialog() {\n        taskSelector.clear();\n        taskSelector.select();\n        taskSelector.addAll(taskSelectorList.stream().map(TaskSetItem::name).collect(Collectors.toList()));\n    }\n\n    private void refreshExtraInfoBlock() {\n        extraInfoBlock.extraInformationStamp.entity(task);\n        extraInfoBlock.extraInformationStamp.view(\"form\");\n        extraInfoBlock.extraInformationStamp.readonly(true);\n        extraInfoBlock.extraInformationStamp.refresh();\n    }\n\n    private String labelOf(TGTask task) {\n        return task.getName();\n    }\n\n    private void release() {\n        RoomTemplate roomTemplate = soul().display(RoomTemplate.class);\n        boolean result = roomTemplate.checkDirty(e -> doRelease());\n        if (result) {\n            doRelease();\n            roomTemplate.entities.readonly(true);\n            roomTemplate.entities.refresh();\n        }\n    }\n\n    private void doRelease() {\n        if (!box().provider(session()).stopWorkingTask(task.getERC(), task.getDRC())) {\n            notifyUser(\"No se ha podido abandonar la tarea\", UserMessage.Type.Error);\n            return;\n        }\n        if (soul().currentLayer() != null) soul().currentLayer().close();\n        notifyUser(\"Tarea abandonada\", UserMessage.Type.Success);\n        updateTask();\n    }\n\n    private void abort() {\n        if (!box().provider(session()).abortTask(task.getERC(), task.getDRC())) {\n            notifyUser(\"No se ha podido abortar el proceso\", UserMessage.Type.Error);\n            return;\n        }\n        if (soul().currentLayer() != null) soul().currentLayer().close();\n        notifyUser(\"Tarea abortada\", UserMessage.Type.Success);\n        updateTask();\n    }\n\n    private void updateTask() {\n        task = (TGTask) box().provider(session()).openResource(task.getERC(), task.getDRC());\n        refresh();\n    }\n\n    private void addAdvise() {\n        if (!checkAdviseDialog()) return;\n        addAdviseDialog.close();\n        TaskAdvise advise = new TaskAdvise();\n        advise.date(adviseDateField.value());\n        advise.message(adviseMessageField.value());\n        source.add(task, advise);\n        refreshAdviseList();\n    }\n\n    private boolean checkAdviseDialog() {\n        adviseMessageField.error(null);\n        if (adviseDateField.value() == null) {\n            notifyUser(\"Indique una fecha\", UserMessage.Type.Error);\n            return false;\n        }\n        if (adviseMessageField.value() == null || adviseMessageField.value().isEmpty()) {\n            adviseMessageField.error(\"Indique un mensaje\");\n            return false;\n        }\n        return true;\n    }\n\n    private void removeAdvise(TaskAdvise advise) {\n        source.delete(task, advise);\n        refreshAdviseList();\n    }\n\n    private void initTaskEvolution() {\n        taskEvolutionList.onAddItem(this::refreshEvolutionItem);\n        taskEvolutionList.onSelect(e -> refreshEvolutionToolbar(e.selection()));\n        recoverTaskDialog.onOpen(e -> refreshRecoverTaskDialog());\n        recoverTask.onExecute(e -> recoverTask());\n    }\n\n    private void recoverTask() {\n        recoverTaskDialog.close();\n        notifyUser(\"Retrocediendo la tarea...\", UserMessage.Type.Loading);\n        boolean recovered = box().provider(session()).recoverTask(selectedEvolutionTask.rrc(), selectedEvolutionTask.drc(), \"\");\n        if (!recovered) {\n            notifyUser(\"No se ha podido retroceder a la tarea \" + selectedEvolutionTask.name(), UserMessage.Type.Error);\n            return;\n        }\n        TGTaskSet set = box().provider(session()).loadAvailableTasks(task.getMainTaskIdentifier().getERC());\n        taskSelectorList = set != null ? io.intino.goros.egeasy.box.ui.datasources.TaskSetDatasource.itemsOf(set) : java.util.Collections.emptyList();\n        notifyUser(\"Se ha retrocedido la tarea\", UserMessage.Type.Success);\n        if (taskSelectorList.size() > 1) taskSelectorDialog.open();\n        else if (taskSelectorList.size() == 1) open(taskSelectorList.get(0));\n        else updateTask();\n    }\n\n    private void refreshEvolutionToolbar(List<TaskSetItem> selection) {\n        selectedEvolutionTask = !selection.isEmpty() ? selection.get(0) : null;\n        recoverTaskTrigger.readonly(selectedEvolutionTask == null || selectedEvolutionTask.isProcess());\n    }\n\n    private void refreshEvolutionItem(AddCollectionItemEvent event) {\n        TaskSetItem task = event.item();\n        TaskState state = task.state();\n        boolean currentTask = task.rrc() == this.task.getERC();\n        TaskEvolutionItem display = event.component();\n        display.state.value(task.state() != null ? task.state().title() : null);\n        display.state.backgroundColor(task.state() != null ? task.state().color() : \"transparent\");\n        display.title.visible(currentTask);\n        if (currentTask) display.title.value(task.name());\n        display.titleLink.visible(!currentTask);\n        if (!currentTask) {\n            display.titleLink.title(task.name());\n            display.titleLink.onExecute(e -> open(task));\n        }\n        display.createDate.visible(state != TaskState.Finished && state != TaskState.Aborted);\n        if (display.createDate.isVisible()) display.createDate.value(task.createDate());\n        display.finishedDate.visible(state == TaskState.Finished || state == TaskState.Aborted);\n        if (display.finishedDate.isVisible()) display.finishedDate.value(task.madeDate());\n    }\n\n    private void gotoTask(TGTask task) {\n        if (gotoTaskListener != null) {\n            gotoTaskListener.accept(task);\n            return;\n        }\n        box().routeManager().routeDispatcher().dispatch(soul(), \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(task.getDRC())).replace(\":rrc\", String.valueOf(task.getERC())));\n    }\n\n    private void finishEdition() {\n        List<String> selection = finishEditionSelector.selection();\n        if (selection.isEmpty()) return;\n        if (!selection.get(0).equals(\"closeOption\")) return;\n        soul().currentLayer().close();\n    }\n\n    private void refreshTaskFormDialog() {\n        taskFormDialog.title(task.getName() != null ? task.getName() : \"Tarea\");\n        entitiesStamp.entity(task);\n        entitiesStamp.view(\"form\");\n        entitiesStamp.readonly(false);\n        entitiesStamp.refresh();\n    }\n\n    private void cancelTaskForm() {\n        finish.readonly(false);\n        finishWithSign.readonly(false);\n    }\n\n    private void saveTaskForm() {\n        taskFormDialog.close();\n        ValidateResult result = entitiesStamp.save();\n        if (!success(result)) {\n            notifyUser(\"Ha habido un problema al finalizar\", UserMessage.Type.Error);\n            finish.readonly(false);\n            finishWithSign.readonly(false);\n            return;\n        }\n        if (ignoreWarnings) doFinishWithWarnings();\n        else doFinish();\n    }\n\n    private boolean success(ValidateResult result) {\n        return result != null && result.success() && (result.getValidateError() == null || result.getValidateError().getMessage().isEmpty());\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("taskSet", "catalog")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.Asset;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.components.SignAction;\nimport io.intino.alexandria.ui.displays.components.SignDocument;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.goros.egeasy.box.ui.ItemContainer;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.TaskSetGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport io.intino.goros.egeasy.box.ui.model.TaskState;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.m3.entity.TGEntity;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.document.TGDocument;\nimport io.intino.goros.egeasy.m3.entity.field.TGField;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.file.FileContent;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\nimport io.intino.goros.egeasy.m3.library.LibraryTask;\nimport io.intino.goros.egeasy.provider.Provider;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.net.URISyntaxException;\nimport java.net.MalformedURLException;\nimport java.net.URI;\nimport java.net.URL;\nimport java.io.InputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.util.*;\nimport java.util.function.BiConsumer;\n\nimport static java.util.stream.Collectors.toList;\nimport static ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates.TaskSetCatalogTemplate.OpenMode.Link;\n\npublic class TaskSetCatalogTemplate extends AbstractTaskSetCatalogTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGRoom room;\n    private String roomName;\n    private String section;\n    private TGEntity entity;\n    private ItemContainer<?> entityContainer;\n    private TaskSetItem selectedTask;\n    private String taskSetName;\n    private OpenMode openMode = Link;\n    private Set<String> visibleColumns;\n    private TaskSetCatalogTemplate.FinishSummary finishSummary = null;\n    private List<TaskSetItem> tasksToFinish;\n    private int tasksToFinishIndex;\n\n    public enum OpenMode { Link, Layer };\n\n    public TaskSetCatalogTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n    }\n\n    public void section(String section) {\n        this.section = section;\n    }\n\n    public void entity(TGEntity entity) {\n        this.entity = entity;\n    }\n\n    public void entityContainer(ItemContainer<?> container) {\n        this.entityContainer = container;\n    }\n\n    public void openMode(OpenMode mode) {\n        this.openMode = mode;\n    }\n\n    public void taskSetName(String name) {\n        this.taskSetName = name;\n    }\n\n    public void visibleColumns(Set<String> visibleColumns) {\n        this.visibleColumns = visibleColumns;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        refresh.onExecute(e -> refreshGrid());\n        finishSelection.onExecute(this::finishSelection);\n        initGrid();\n        finishSummaryDialog.onOpen(e -> refreshFinishSummaryDialog());\n        initFilters();\n        initExport();\n    }\n\n    private void initFilters() {\n        filterListEditor.onAdd(this::addFilter);\n        filterListEditor.onRemove(this::removeFilter);\n        filterListEditor.onFilter(this::applyFilter);\n    }\n\n    private void addFilter(SetFilter filter) {\n        box().provider(session()).saveFilter(room.getERC(), entity.getDRC(), filter.title(), filter.expression());\n    }\n\n    private void removeFilter(SetFilter filter) {\n        box().provider(session()).removeFilter(room.getERC(), entity.getDRC(), filter.title());\n    }\n\n    private void applyFilter(SetFilter filter) {\n        taskGrid.<TaskSetGridDatasource>source().filter(filter != null ? filter.expression() : null);\n        taskGrid.reload();\n    }\n\n    private void initGrid() {\n        taskGrid.onSelect(this::refreshSelection);\n        removeSelection.onExecute(e -> taskGrid.selection(Collections.emptyList()));\n        taskGrid.onSortColumn(event -> {\n            GridColumn<TaskSetItem> column = event.column();\n            SortColumnEvent.Mode mode = event.mode();\n            taskGrid.sortings(mode != SortColumnEvent.Mode.None ? List.of(column.label() + \"=\" + (mode == SortColumnEvent.Mode.Ascendant ? \"A\" : \"D\")) : Collections.emptyList());\n        });\n        taskGrid.onClickCell(e -> {\n            TaskSetItem item = e.item();\n            if (item == null || !item.hasReference()) return;\n            open(item);\n        });\n        taskGrid.itemResolver(new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(TaskSetItem item) {\n                GridItem result = new GridItem();\n                result.selectable(item.hasReference());\n                result.add(stateIconOf(item), stateColorOf(item));\n                result.add(typeIconOf(item));\n                result.add(item.name());\n                result.add(item.reference() != null ? item.reference().name() : \"\");\n                result.add(item.relatedObject() != null ? item.relatedObject().name() : \"\");\n                result.add(item.webService());\n                result.add(item.createdBy());\n                result.add(item.madeBy());\n                result.add(item.process() != null ? item.process().name() : \"\");\n                result.add(item.createDate());\n                result.add(item.dueDate());\n                result.add(item.adviseDate());\n                result.add(item.madeDate());\n                result.add(item.state().title());\n                result.add(item.repeated() ? \"S\u00ed\" : \"No\");\n                result.add(item.daysLeft());\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<TaskSetItem> column, TaskSetItem item) {\n                if (column.type() != GridColumn.Type.Link) return null;\n                if (!item.hasReference()) return null;\n                if (column.address() == null) return null;\n                return session().browser().basePath() + column.address().replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", section).replace(\":location\", taskSetName).replace(\":drc\", String.valueOf(item.drc())).replace(\":rrc\", String.valueOf(item.rrc())).replace(\":view\", \"default\");\n            }\n\n            private String stateIconOf(TaskSetItem item) {\n                if (item.state() == TaskState.Finished) return \"Check\";\n                if (item.state() == TaskState.Aborted) return \"Close\";\n                if (item.repeated()) return \"Replay\";\n                return null;\n            }\n\n            private String stateColorOf(TaskSetItem item) {\n                return item.state().color();\n            }\n\n            private String typeIconOf(TaskSetItem item) {\n                String icon = \"/icons/\" + (item.isProcess() ? \"Process.ico\" : \"Task.ico\");\n                return Asset.toResource(baseAssetUrl(), icon).toUrl().toString();\n            }\n\n            private URL baseAssetUrl() {\n                try {\n                    return new URI(session().browser().baseAssetUrl()).toURL();\n                } catch (URISyntaxException | MalformedURLException e) {\n                    return null;\n                }\n            }\n\n        });\n        taskGrid.onRefreshItemCount(this::refreshCount);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        TaskSetGridDatasource source = new TaskSetGridDatasource(box().provider(session()), session(), entity);\n        source.filter(filterListEditor.selected() != null ? filterListEditor.selected().expression() : null);\n        taskGrid.source(source);\n        refreshCount(taskGrid.itemCount());\n        refreshFilters();\n        refreshExport();\n        refreshVisibleColumns();\n    }\n\n    private void refreshSelection(SelectionEvent event) {\n        exportWizard.mode(event.selection().isEmpty() ? ExportWizard.Mode.Set : ExportWizard.Mode.File);\n        count.visible(event.selection().isEmpty());\n        selectionBlock.visible(!event.selection().isEmpty());\n        selectionCount.value(DisplayHelper.countMessage(event.selection().size(), \"tarea seleccionada\", \"tareas seleccionadas\"));\n    }\n\n    private void initExport() {\n        exportWizard.onExportFile(mode -> box().provider(session()).exportTaskDocuments(DisplayHelper.tasksIdentifiersOf(taskGrid.selectedItems()).toArray(new TGIdentifier[0])));\n        exportWizard.onExportSet(mode -> ((TaskSetGridDatasource)taskGrid.source()).export(mode, taskGrid.visibleColumns().stream().map(io.intino.alexandria.ui.model.datasource.grid.GridColumn::label).filter(c -> !c.isEmpty()).collect(java.util.stream.Collectors.toList())));\n    }\n\n    private void refreshVisibleColumns() {\n        taskGrid.visibleColumns(taskGrid.columns().stream().peek(c -> c.visible(visibleColumns == null || visibleColumns.contains(c.name()))).collect(toList()));\n    }\n\n    private void refreshFinishSummaryDialog() {\n        if (finishSummary == null) return;\n        totalCount.value(finishSummary.count());\n        finishedSummaryItem.refresh(\"finished\", translate(\"finalizadas\"), finishSummary.finished);\n        notFinishedSummaryItem.refresh(\"not-finished\", translate(\"no finalizadas\"), finishSummary.notFinished);\n    }\n\n    private void refreshGrid() {\n        taskGrid.reload();\n    }\n\n    private void finishSelection(SelectionEvent event) {\n        finishSelection.readonly(true);\n        notifyUser(\"Finalizando tareas\", UserMessage.Type.Loading);\n        tasksToFinish = event.selection();\n        tasksToFinishIndex = 0;\n        finishSummary = new FinishSummary();\n        finishTask(tasksToFinishIndex);\n    }\n\n    private void finishTask(int index) {\n        if (index >= tasksToFinish.size()) showFinishResults();\n        else finishTask(tasksToFinish.get(index), finishTaskCallback());\n    }\n\n    private BiConsumer<TaskSetItem, ValidateResult> finishTaskCallback() {\n        return (item, validateResult) -> {\n            if (validateResult.success()) finishSummary.finished.put(item, validateResult.getMessage());\n            else finishSummary.notFinished.put(item, validateResult.getMessage());\n            tasksToFinishIndex++;\n            finishTask(tasksToFinishIndex);\n        };\n    }\n\n    private void showFinishResults() {\n        finishSelection.readonly(false);\n        notifyUser(\"Tareas finalizadas\", UserMessage.Type.Success);\n        finishSummaryDialog.open();\n        taskGrid.selection(Collections.emptyList());\n        taskGrid.reload();\n    }\n\n    private void finishTask(TaskSetItem t, BiConsumer<TaskSetItem, ValidateResult> callback) {\n        Provider provider = box().provider(session());\n        TGTask task = (TGTask) provider.openResource(t.rrc(), t.drc());\n        TGContainer taskTarget = task != null && task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty() ? (TGContainer) box().provider(session()).openResource(task.getTargetIdentifier().getERC(), task.getTargetIdentifier().getDRC()) : null;\n\n        if (taskTarget == null) {\n            callback.accept(t, ValidateResult.failure(\"No se ha podido obtener los datos de la tarea\"));\n            return;\n        }\n\n        TGField signableField = LibraryTask.findSignableField(task, taskTarget);\n        TGField approvalField = LibraryTask.findApprovalField(task, taskTarget);\n\n        if (signableField == null && approvalField == null) {\n            callback.accept(t, provider.finishTask(t.rrc(), t.drc(), false));\n            return;\n        }\n\n        if (approvalField != null) {\n            finishTaskWithApproval(t, taskTarget, approvalField, callback);\n            return;\n        }\n\n        TGDocument document = LibraryDocuments.getDocument(taskTarget);\n        if (document == null) {\n            callback.accept(t, ValidateResult.failure(\"No se ha podido obtener el documento a firmar\"));\n            return;\n        }\n\n        String hash = box().provider(session()).loadDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC());\n        InputStream content = loadContentToSign(taskTarget, document, hash);\n        if (content == null) {\n            callback.accept(t, ValidateResult.failure(\"No se ha podido obtener el documento a firmar\"));\n            return;\n        }\n\n        OperationResult checkSign = box().provider(session()).checkAbilityToSign(taskTarget.getERC(), taskTarget.getDRC(), signableField.getDRC());\n        if (!checkSign.isSuccess()) {\n            callback.accept(t, ValidateResult.failure(checkSign.getMessage()));\n            return;\n        }\n\n        signer.signFormat(SignAction.SignFormat.CAdES);\n        signer.signMode(hash != null && !hash.isEmpty() ? SignAction.SignMode.CounterSign : SignAction.SignMode.Sign);\n        signer.signSuccessMessage(\"Firma realizada para \" + t.name() + (t.reference() != null ? \". \" + t.reference().name() : \"\"));\n        signer.onSign(e -> finishTaskWithSign(t, taskTarget, signableField, document, e.signature(), callback));\n        signer.beforeSignChecker(beforeSignChecker(signableField, taskTarget));\n        signer.documentProvider(() -> content);\n        signer.execute();\n    }\n\n    private InputStream loadContentToSign(TGContainer taskTarget, TGDocument document, String hash) {\n        if (hash != null && !hash.isEmpty()) return new ByteArrayInputStream(hash.getBytes(StandardCharsets.UTF_8));\n        FileContent fileContent = document != null ? box().provider(session()).openDocumentFile(taskTarget, document.getDRC(), false) : null;\n        return fileContent != null ? fileContent.getContent() : null;\n    }\n\n    private void finishTaskWithApproval(TaskSetItem item, TGContainer taskTarget, TGField approvalField, BiConsumer<TaskSetItem, ValidateResult> callback) {\n        Provider provider = box().provider(session());\n\n        if (!box().provider(session()).saveDocumentApproval(taskTarget.getERC(), taskTarget.getDRC(), approvalField.getDRC())) {\n            callback.accept(item, ValidateResult.failure(\"No se ha podido aprobar la tarea para su finalizaci\u00f3n\"));\n            return;\n        }\n\n        callback.accept(item, provider.finishTask(item.rrc(), item.drc(), false));\n    }\n\n    private void finishTaskWithSign(TaskSetItem item, TGContainer taskTarget, TGField signableField, TGDocument document, String signature, BiConsumer<TaskSetItem, ValidateResult> callback) {\n        Provider provider = box().provider(session());\n\n        if (!box().provider(session()).saveDocumentSign(taskTarget.getERC(), taskTarget.getDRC(), document.getDRC(), signableField.getDRC(), signature)) {\n            callback.accept(item, ValidateResult.failure(\"No se ha podido guardar el documento firmado\"));\n            return;\n        }\n\n        callback.accept(item, provider.finishTask(item.rrc(), item.drc(), false));\n    }\n\n    private SignDocument.BeforeSignChecker beforeSignChecker(TGField signableField, TGContainer taskTarget) {\n        return new SignDocument.BeforeSignChecker() {\n            OperationResult result;\n            @Override\n            public boolean check() {\n                if (signableField == null) return false;\n                result = box().provider(session()).checkAbilityToSign(taskTarget.getERC(), taskTarget.getDRC(), signableField.getDRC());\n                return result.isSuccess();\n            }\n\n            @Override\n            public String checkMessage() {\n                return result != null ? result.getMessage() : null;\n            }\n        };\n    }\n\n    private void refreshCount(RefreshCountEvent event) {\n        refreshCount(event.count());\n    }\n\n    private void refreshCount(long count) {\n        this.count.value(DisplayHelper.countMessage(count, \"tarea\", \"tareas\"));\n    }\n\n    private void refreshExport() {\n        exportWizard.filename(entity.getName() + \" \" + DisplayHelper.downloadDate());\n        exportWizard.mode(ExportWizard.Mode.Set);\n        exportWizard.entity(entity);\n        exportWizard.refresh();\n    }\n\n    private void refreshFilters() {\n        if (room == null) return;\n        filterListEditor.taskColumns(taskGrid.columns());\n        filterListEditor.filters(DatasourceHelper.filters(box().provider(session()), room, entity));\n        filterListEditor.refresh();\n    }\n\n    private static class FinishSummary {\n        public Map<TaskSetItem, String> finished = new LinkedHashMap<>();\n        public Map<TaskSetItem, String> notFinished = new LinkedHashMap<>();\n\n        public int count() {\n            return finished.size() + notFinished.size();\n        }\n    }\n\n    private void open(TaskSetItem task) {\n        if (task == null) return;\n        selectedTask = task;\n        if (openMode == Link) {\n            taskLinkTrigger.address(path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", section).replace(\":location\", taskSetName).replace(\":drc\", String.valueOf(task.drc())).replace(\":rrc\", String.valueOf(task.rrc())).replace(\":view\", \"default\"));\n            taskLinkTrigger.launch();\n        } else {\n            //taskLayerTrigger.address(path -> path.replace(\":rrc\", String.valueOf(task.rrc())).replace(\":drc\", String.valueOf(task.drc())));\n            String taskLayerAddress = \"/entidad/:rrc/:drc\".replace(\":rrc\", String.valueOf(task.rrc())).replace(\":drc\", String.valueOf(task.drc()));\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, taskLayerAddress), entityContainer);\n        }\n    }\n\n    private void fillLayer(Layer<?, ?> layer, String taskLayerAddress) {\n        RoomTemplate template = new RoomTemplate(box());\n        template.readonly(true);\n        template.onRemove(e -> {\n            soul().currentLayer().close();\n            refreshGrid();\n        });\n        layer.title(selectedTask.name());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.template(template);\n        box().routeManager().routeDispatcher().dispatch(soul(), taskLayerAddress);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("taskSet", "starter")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.Event;\nimport io.intino.goros.egeasy.m3.definition.base.Definition;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport io.intino.goros.egeasy.m3.library.LibraryEntity;\nimport io.intino.goros.egeasy.provider.Provider;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class TaskStarterTemplate extends AbstractTaskStarterTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGTask task;\n    private Consumer<TGTask> startedListener;\n    private Consumer<TGTask> cancelListener;\n    private Consumer<TGTask> errorListener;\n    private boolean reuseTarget = false;\n    private boolean copySignedTarget = false;\n    private Definition selectedContainerType = null;\n    private TaskQuery taskQuery = null;\n    private String taskQueryMessage = null;\n    private TaskResponse taskResponse = null;\n\n    public TaskStarterTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public enum TaskQuery {\n        CreateNew(\"Ya existe contenedor '%s'. \u00bfDesea crear uno nuevo?\"),\n        CreateCopy(\"El documento ya est\u00e1 %s. \u00bfDesea crear una copia?\");\n        private String title;\n        TaskQuery(String title) {\n            this.title = title;\n        }\n        public String title() {\n            return title;\n        }\n    }\n    public enum TaskResponse { No, Yes }\n\n    @Override\n    public void init() {\n        super.init();\n        queryDialogResponseNo.onExecute(e -> checkStartResponse(TaskResponse.No));\n        queryDialogResponseYes.onExecute(e -> checkStartResponse(TaskResponse.Yes));\n        containerTypeSelector.onSelect(e -> selectContainerType.readonly(e.selection().isEmpty()));\n        containerTypeSelectorDialog.onOpen(e -> refreshContainerTypeSelectorDialog());\n        containerTypeSelectorDialog.onClose(e -> notifyCancel());\n        selectContainerType.onExecute(this::updateSelectedContainerType);\n        queryDialog.onOpen(e -> queryDialogMessage.value(taskQueryMessage));\n    }\n\n    public void task(TGTask task) {\n        this.task = task;\n        this.reuseTarget = false;\n        this.copySignedTarget = false;\n        this.selectedContainerType = null;\n    }\n\n    public void onStarted(Consumer<TGTask> listener) {\n        this.startedListener = listener;\n    }\n\n    public void onCancel(Consumer<TGTask> listener) {\n        this.cancelListener = listener;\n    }\n\n    public void onError(Consumer<TGTask> listener) {\n        this.errorListener = listener;\n    }\n\n    public void start() {\n        if (!canStart()) return;\n        doStart();\n    }\n\n    private boolean canStart() {\n        if (task.getTargetIdentifier() != null && !task.getTargetIdentifier().isEmpty()) return true;\n        if (!task.isRecovered()) {\n            selectContainerType();\n            return false;\n        }\n        TGTask recoveredTask = (TGTask) box().provider(session()).openResource(task.getRecoveredTaskIdentifier().getERC(), task.getRecoveredTaskIdentifier().getDRC());\n        if (recoveredTask.getTargetIdentifier() == null || recoveredTask.getTargetIdentifier().isEmpty()) {\n            selectContainerType();\n            return false;\n        }\n        requestCreateNewTarget(recoveredTask.getTargetIdentifier());\n        return false;\n    }\n\n    private void selectContainerType() {\n        List<Definition> types = containerTypes();\n        if (types.size() == 0) {\n            notifyUser(\"No se han definido tipos de contenedor\", UserMessage.Type.Error);\n            return;\n        }\n        if (types.size() == 1) {\n            selectedContainerType = types.get(0);\n            doStart();\n            return;\n        }\n        containerTypeSelectorDialog.open();\n    }\n\n    private void requestCreateNewTarget(TGIdentifier container) {\n        taskQuery = TaskQuery.CreateNew;\n        taskQueryMessage = TaskQuery.CreateNew.title().replace(\"%s\", container.getName());\n        queryDialog.open();\n    }\n\n    private void checkStartResponse(TaskResponse response) {\n        queryDialog.close();\n        if (taskQuery == TaskQuery.CreateNew) {\n            reuseTarget = response == TaskResponse.No;\n            if (reuseTarget) requestCreateCopy();\n            else selectContainerType();\n        }\n        else if (taskQuery == TaskQuery.CreateCopy) {\n            copySignedTarget = response == TaskResponse.Yes;\n            doStart();\n        }\n    }\n\n    private void requestCreateCopy() {\n        Provider provider = box().provider(session());\n        TGTask recoveredTask = (TGTask) provider.openResource(task.getRecoveredTaskIdentifier().getERC(), task.getRecoveredTaskIdentifier().getDRC());\n        TGResource resource = provider.openResource(recoveredTask.getTargetIdentifier().getERC(), recoveredTask.getTargetIdentifier().getDRC());\n        if (LibraryEntity.isSigned(resource) || LibraryEntity.isApproved(resource)) {\n            taskQuery = TaskQuery.CreateCopy;\n            taskQueryMessage = TaskQuery.CreateCopy.title().replace(\"%s\", LibraryEntity.isSigned(resource) ? \"firmado\" : \"validado\");\n            queryDialog.open();\n            return;\n        }\n        copySignedTarget = false;\n        doStart();\n    }\n\n    private void doStart() {\n        int rrc = task.getTargetIdentifier().getERC();\n        if (!task.getTargetIdentifier().isEmpty() && !box().provider(session()).isEditingResource(rrc)) {\n            io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult operationResult = box().provider(session()).beginEditionResource(rrc);\n            if (!operationResult.isSuccess()) {\n                notifyUser(operationResult.getMessage(), io.intino.alexandria.ui.displays.UserMessage.Type.Error);\n                errorListener.accept(task);\n                return;\n            }\n        }\n        io.intino.goros.egeasy.driver.driversystem.server.model.OperationResult operationResult = box().provider(session()).startWorkingTask(task.getERC(), task.getDRC(), reuseTarget, copySignedTarget, selectedContainerType);\n        if (!operationResult.isSuccess()) {\n            notifyUser(operationResult.getMessage(), UserMessage.Type.Error);\n            errorListener.accept(task);\n            return;\n        }\n        this.startedListener.accept(task);\n    }\n\n    private void refreshContainerTypeSelectorDialog() {\n        containerTypeSelector.clear();\n        containerTypeSelector.addAll(containerTypes().stream().map(this::labelOf).collect(Collectors.toList()));\n        containerTypeSelector.select();\n    }\n\n    private String labelOf(Definition definition) {\n        String result = definition.getCaption();\n        List<String> attributeValues = definition.getAttributes().findAttribute(\"DESCRIPCION\");\n        String description = !attributeValues.isEmpty() ? (String)attributeValues.get(0) : null;\n        return result + (description != null ? \". \" + description : \"\");\n    }\n\n    private Definition selectedContainerType() {\n        List<String> selection = containerTypeSelector.selection();\n        if (selection.isEmpty()) return null;\n        String selected = selection.get(0);\n        return containerTypes().stream().filter(d -> labelOf(d).equals(selected)).findFirst().orElse(null);\n    }\n\n    private void updateSelectedContainerType(Event e) {\n        selectContainerType.readonly(true);\n        selectedContainerType = selectedContainerType();\n        if (selectedContainerType == null) {\n            notifyUser(\"Debe seleccionar un tipo de contenedor para la tarea\", UserMessage.Type.Warning);\n            selectContainerType.readonly(false);\n            return;\n        }\n        selectContainerType.readonly(false);\n        containerTypeSelectorDialog.close();\n        doStart();\n    }\n\n    private List<Definition> containerTypes() {\n        return box().provider(session()).loadAvailableTargets(task.getERC(), task.getDRC());\n    }\n\n    private void notifyCancel() {\n        if (cancelListener == null) return;\n        cancelListener.accept(task);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("taskSet")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.RoomLocationContainer;\nimport io.intino.goros.egeasy.box.ui.model.Section;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport io.intino.goros.egeasy.m3.entity.room.TGLocation;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.entity.task.TGTask;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.Set;\nimport java.util.function.Consumer;\n\npublic class TaskSetTemplate extends AbstractTaskSetTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> implements RoomLocationContainer {\n    private String label;\n    private int rrc;\n    private TGRoom room;\n    private String roomName;\n    private TGTaskSet taskSet;\n    private String taskSetName;\n    private TGTask selectedTask;\n\n    public TaskSetTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public TaskSetTemplate label(String label) {\n        this.label = label;\n        return this;\n    }\n\n    public TaskSetTemplate rrc(int rrc) {\n        this.rrc = rrc;\n        return this;\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n        taskSetCatalogStamp.searchBox.condition(null);\n    }\n\n    @Override\n    public void section(Section section) {\n    }\n\n    @Override\n    public void location(TGLocation location, String name) {\n    }\n\n    @Override\n    public void open(int drc, int rrc, String view) {\n        loadingContent.show();\n        open((TGTask) box().provider(session()).openResource(rrc, drc));\n        loadingContent.hide();\n    }\n\n    @Override\n    public void back() {\n        showTasksBlock();\n        taskSetCatalogStamp.refresh();\n    }\n\n    @Override\n    public boolean checkDirty(Consumer<Boolean> saveListener) {\n        return true;\n    }\n\n    public TaskSetTemplate taskSet(TGTaskSet taskSet, String name) {\n        this.taskSet = taskSet;\n        this.taskSetName = name;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        taskBlock.onShow(e -> refreshTaskBlock());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        if (taskSet == null) return;\n        icon.value(new java.io.File(box().egeConfiguration().iconsDir() + \"/Sistema/TaskTray.ico\"));\n        title.value(label);\n        showTasksBlock();\n        refreshCatalog();\n    }\n\n    private void refreshCatalog() {\n        taskSetCatalogStamp.room(room, roomName);\n        taskSetCatalogStamp.section(\"Tareas\");\n        taskSetCatalogStamp.entity(taskSet);\n        taskSetCatalogStamp.taskSetName(taskSetName);\n        taskSetCatalogStamp.visibleColumns(visibleColumns());\n        taskSetCatalogStamp.refresh();\n    }\n\n    private static final Map<Integer, Set<String>> VisibleColumns = new HashMap<>() {{\n        /* all tasks */put(22, Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"madeBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"madeDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* my tasks */put(24, Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* processes */put(25, Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"createdBy\", \"createDate\", \"state\"));\n        /* wait tasks */put(26, Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"process\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n        /* signatures */put(31, Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"webService\", \"createdBy\", \"createDate\", \"dueDate\", \"adviseDate\", \"state\", \"repeated\", \"daysLeft\"));\n    }};\n    private Set<String> visibleColumns() {\n        return VisibleColumns.get(taskSet.getERC());\n    }\n\n    private void showTasksBlock() {\n        taskSetBlock.show();\n        taskBlock.hide();\n    }\n\n    private void showTaskBlock() {\n        taskSetBlock.hide();\n        taskBlock.show();\n    }\n\n    private void open(TGTask item) {\n        this.selectedTask = item;\n        showTaskBlock();\n    }\n\n    private void refreshTaskBlock() {\n        taskBlock.taskStamp.backInfo(label, path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", \"Tareas\").replace(\":location\", StringUtil.encode(taskSetName)), null);\n        taskBlock.taskStamp.onGotoTask(this::open);\n        taskBlock.taskStamp.room(room);\n        taskBlock.taskStamp.task(selectedTask);\n        taskBlock.taskStamp.refresh();\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("relationSet")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.goros.egeasy.box.ui.ItemContainer;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.RelationSetGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.RelationSetItem;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.m3.entity.TGEntity;\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.net.MalformedURLException;\nimport java.net.URL;\nimport java.io.InputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.util.*;\nimport java.util.function.BiConsumer;\n\nimport static java.util.stream.Collectors.toList;\nimport static ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates.RelationSetCatalogTemplate.OpenMode.Link;\n\npublic class RelationSetCatalogTemplate extends AbstractRelationSetCatalogTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGRoom room;\n    private String roomName;\n    private String section;\n    private TGEntity entity;\n    private ItemContainer<?> entityContainer;\n    private RelationSetItem selectedEntity;\n    private OpenMode openMode = Link;\n    private Set<String> visibleColumns;\n\n    public enum OpenMode { Link, Layer };\n\n    public RelationSetCatalogTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void room(TGRoom room, String name) {\n        this.room = room;\n        this.roomName = name;\n    }\n\n    public void section(String section) {\n        this.section = section;\n    }\n\n    public void entity(TGEntity entity) {\n        this.entity = entity;\n    }\n\n    public void entityContainer(ItemContainer<?> container) {\n        this.entityContainer = container;\n    }\n\n    public void openMode(OpenMode mode) {\n        this.openMode = mode;\n    }\n\n    public void visibleColumns(Set<String> visibleColumns) {\n        this.visibleColumns = visibleColumns;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        refresh.onExecute(e -> refreshGrid());\n        initGrid();\n        initFilters();\n    }\n\n    private void initFilters() {\n        filterListEditor.onAdd(this::addFilter);\n        filterListEditor.onRemove(this::removeFilter);\n        filterListEditor.onFilter(this::applyFilter);\n    }\n\n    private void addFilter(SetFilter filter) {\n        box().provider(session()).saveFilter(room.getERC(), entity.getDRC(), filter.title(), filter.expression());\n    }\n\n    private void removeFilter(SetFilter filter) {\n        box().provider(session()).removeFilter(room.getERC(), entity.getDRC(), filter.title());\n    }\n\n    private void applyFilter(SetFilter filter) {\n        relationGrid.<RelationSetGridDatasource>source().filter(filter != null ? filter.expression() : null);\n        relationGrid.reload();\n    }\n\n    private void initGrid() {\n        relationGrid.onSortColumn(event -> {\n            GridColumn<RelationSetItem> column = event.column();\n            SortColumnEvent.Mode mode = event.mode();\n            relationGrid.sortings(mode != SortColumnEvent.Mode.None ? List.of(column.label() + \"=\" + (mode == SortColumnEvent.Mode.Ascendant ? \"A\" : \"D\")) : Collections.emptyList());\n        });\n        relationGrid.onClickCell(e -> {\n            RelationSetItem item = e.item();\n            if (item == null || !item.hasReference()) return;\n            open(item);\n        });\n        relationGrid.itemResolver(new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(RelationSetItem item) {\n                GridItem result = new GridItem();\n                result.selectable(item.hasReference());\n                result.add(item.source().name());\n                result.add(item.relation().asString());\n                result.add(item.target().name());\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<RelationSetItem> column, RelationSetItem item) {\n                if (column.type() != GridColumn.Type.Link) return null;\n                if (!item.hasReference()) return null;\n                if (column.address() == null) return null;\n                EntitySetItem reference = item.reference(entity);\n                return session().browser().basePath() + column.address().replace(\":drc\", String.valueOf(reference.drc())).replace(\":rrc\", String.valueOf(reference.rrc())).replace(\":view\", \"default\");\n            }\n        });\n        relationGrid.onRefreshItemCount(this::refreshCount);\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        RelationSetGridDatasource source = new RelationSetGridDatasource(box().provider(session()), session(), entity);\n        source.filter(filterListEditor.selected() != null ? filterListEditor.selected().expression() : null);\n        relationGrid.source(source);\n        refreshCount(relationGrid.itemCount());\n        refreshFilters();\n        refreshVisibleColumns();\n    }\n\n    private void refreshVisibleColumns() {\n        relationGrid.visibleColumns(relationGrid.columns().stream().peek(c -> c.visible(visibleColumns == null || visibleColumns.contains(c.name()))).collect(toList()));\n    }\n\n    private void refreshGrid() {\n        relationGrid.reload();\n    }\n\n    private void refreshCount(RefreshCountEvent event) {\n        refreshCount(event.count());\n    }\n\n    private void refreshCount(long count) {\n        this.count.value(DisplayHelper.countMessage(count, \"relaci\u00f3n\", \"relaciones\"));\n    }\n\n    private void refreshFilters() {\n        if (room == null) return;\n        filterListEditor.relationColumns(relationGrid.columns());\n        filterListEditor.filters(DatasourceHelper.filters(box().provider(session()), room, entity));\n        filterListEditor.refresh();\n    }\n\n    private void open(RelationSetItem entity) {\n        if (entity == null) return;\n        selectedEntity = entity;\n        EntitySetItem reference = entity.reference(this.entity);\n        if (openMode == Link) {\n            entityLinkTrigger.address(path -> path.replace(\":drc\", String.valueOf(reference.drc())).replace(\":rrc\", String.valueOf(reference.rrc())).replace(\":view\", \"default\"));\n            entityLinkTrigger.launch();\n        } else {\n            String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":drc\", String.valueOf(reference.drc())).replace(\":rrc\", String.valueOf(reference.rrc()));\n            ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, entityLayerAddress), entityContainer);\n        }\n    }\n\n    private void fillLayer(Layer<?, ?> layer, String entityLayerAddress) {\n        RoomTemplate template = new RoomTemplate(box());\n        template.readonly(true);\n        template.onRemove(e -> {\n            soul().currentLayer().close();\n            refreshGrid();\n        });\n        layer.title(selectedEntity.reference(this.entity).name());\n        layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n        layer.template(template);\n        box().routeManager().routeDispatcher().dispatch(soul(), entityLayerAddress);\n    }\n\n}")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

