/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContainerTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("definition")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.Soul;\nimport io.intino.alexandria.ui.displays.Component;\nimport io.intino.alexandria.ui.displays.components.BlockConditional;\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.alexandria.ui.displays.components.Layer;\nimport io.intino.alexandria.ui.displays.events.collection.SortColumnEvent;\nimport io.intino.alexandria.ui.displays.components.addressable.Addressed;\nimport io.intino.alexandria.ui.displays.UserMessage;\n\nimport io.intino.goros.egeasy.box.ProviderHelper;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.DatasourceHelper;\nimport io.intino.goros.egeasy.box.ui.datasources.InventoryGridDatasource;\nimport io.intino.goros.egeasy.box.ui.datasources.EntitySetGridDatasource;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.box.util.StringUtil;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.InventoryItem;\nimport io.intino.goros.egeasy.box.ui.model.ClassifierItem;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.ui.containers.EntitySetItemContainer;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.BeginEditionOperationResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport io.intino.goros.egeasy.m3.definition.base.Definition;\nimport io.intino.goros.egeasy.m3.entity.TGIdentifier;\nimport io.intino.goros.egeasy.m3.entity.TGSessionInfo;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.component.TGForm;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\n\nimport io.intino.goros.egeasy.m3.entity.room.TGRoom;\nimport io.intino.goros.egeasy.m3.library.LibraryDefinitions;\nimport io.intino.goros.egeasy.m3.library.LibraryDefinitions;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\n\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates.EntitiesTemplate;\n\nimport java.io.File;\nimport java.util.ArrayList;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\nimport java.util.stream.Collectors;\nimport java.util.HashMap;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Set;\nimport java.util.Map;\n\npublic class ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template extends Abstract")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> implements EntitySetItemContainer {\n    private TGRoom room;\n    private String roomName;\n    private String section;\n    private String location;\n    private EntitySetItem entity;\n    private boolean embedded = false;\n    private TGResource entityContainer;\n    private TGResource selectedResource;\n    private boolean selectedResourceReadonly = true;\n    private Consumer<Boolean> showListener;\n    private Consumer<Boolean> finishEditionListener;\n    private String backTitle;\n    private Function<String, String> backAddressResolver;\n    private Consumer<EntitySetItem> backListener;\n    private Consumer<EntitySetItem> removeListener;\n    private Consumer<Boolean> dirtyListener;\n    private String selectedView;\n    private boolean readonly = true;\n    private ValidateResult validateResult;\n    private String adviseMessage;\n    private BeginEditionOperationResult requestEditionResult;\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("content", "declaration"))).output(Outputs.literal("\n    private TGIdentifier selectedDomain;\n\n    public ")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Template(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    @Override\n    public void room(TGRoom room, String roomName) {\n        this.room = room;\n        this.roomName = roomName;\n    }\n\n    @Override\n    public void section(String section) {\n        this.section = section;\n    }\n\n    @Override\n    public void location(String location) {\n        this.location = location;\n    }\n\n    @Override\n    public EntitySetItem entity() {\n        return entity;\n    }\n\n    @Override\n    public void embedded(boolean value) {\n        this.embedded = value;\n    }\n\n    @Override\n    public void entity(EntitySetItem entity) {\n        this.entity = entity;\n        resetContainer();\n        validateResult = null;\n        reset();\n    }\n\n    @Override\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    @Override\n    public void selectView(String view) {\n        if (selectedView != null && selectedView.equals(view)) return;\n        view(view);\n        viewSelector.select(selectedView);\n    }\n\n    @Override\n    public void view(String view) {\n        this.selectedView = view;\n    }\n\n    public void onShow(Consumer<Boolean> listener) {\n        this.showListener = listener;\n    }\n\n    @Override\n    public void backInfo(String title, Function<String, String> addressResolver, Consumer<EntitySetItem> listener) {\n        this.backTitle = title;\n        this.backAddressResolver = addressResolver;\n        this.backListener = listener;\n    }\n\n    @Override\n    public void onRemove(Consumer<EntitySetItem> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void onDirty(Consumer<Boolean> listener) {\n        this.dirtyListener = listener;\n    }\n\n    private void notifyDirty(boolean value) {\n        if (save.isVisible()) save.readonly(!value);\n        if (dirtyListener != null) dirtyListener.accept(value);\n    }\n\n    ")).output(Outputs.expression(new Output[0]).output(Outputs.placeholder("content", new String[0]))).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("content"), (LogicalExpression)Predicates.trigger("declaration"))).output(Outputs.placeholder("view", "declaration").multiple("\n")));
        rules.add(this.rule().condition(Predicates.allTypes("content")).output(Outputs.literal("@Override\npublic void init() {\n    super.init();\n    linkDomain.onExecute(e -> {\n        if (!readonly) updateEdition(true);\n        if (backListener != null) backListener.accept(entity);\n    });\n    domain.onExecute(e -> open(selectedDomain));\n    viewSelector.onSelect(e -> selectedView = e.selection().isEmpty() ? null : (String) e.selection().get(0));\n    save.onExecute(e -> save());\n    remove.onExecute(e -> removeElement());\n    edit.onExecute(e -> updateEdition(false));\n    titleEditor.onChange(e -> saveTitle());\n    titleEditor.onEnterPress(e -> saveTitle());\n    requestEditionDialog.onOpen(e -> refreshRequestEdition());\n    requestEdition.onExecute(e -> requestEdition());\n    freeEdition.onExecute(e -> freeEdition());\n    finishEdition.onExecute(e -> {\n        if (dirty()) {\n            finishEditionDialog.open();\n            return;\n        }\n        updateEdition(true);\n    });\n    finishEditionSelector.onSelect(e -> finishEdition());\n    addProcess.onExecute(e -> addProcess(e.option()));\n    validationResultBlock.onShow(e -> refreshValidationResult());\n    validationResultStamp.onSelect(this::focusValidationResultError);\n    validationResultStamp.onClose(e -> validationResultBlock.hide());\n    ")).output(Outputs.placeholder("view", "init").multiple("\n")).output(Outputs.literal("\n    verificationBlock.onShow(e -> refreshVerificationBlock());\n    tasksBlock.onShow(e -> refreshTasksBlock());\n    relationsBlock.onShow(e -> refreshRelationsBlock());\n    continueWithAdvises.onExecute(e -> forceSave());\n    adviseDialog.onClose(e -> validateResult = null);\n    adviseDialog.onOpen(e -> {\n        notifyUser(\"Hay que verificar avisos pendientes\", UserMessage.Type.Info);\n        adviseDialogMessage.value(adviseMessage);\n    });\n}\n\npublic boolean dirty() {\n    ")).output(Outputs.placeholder("view", "dirtyCall").multiple("\n")).output(Outputs.literal("\n    return false;\n}\n\npublic void endEdition() {\n    io.intino.goros.egeasy.provider.Provider provider = box().provider(session());\n    if (!provider.isEditingResource(entity.rrc())) return;\n    provider.endEditionResource(entity.rrc());\n}\n\npublic void openSaveDialog(Consumer<Boolean> listener) {\n    finishEditionListener = listener;\n    finishEditionDialog.open();\n}\n\n@Override\npublic void refresh() {\n    super.refresh();\n    TGContainer container = (TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc());\n    icon.value(")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(");\n    iconCopy.text(DisplayHelper.entityInfo(entity));\n    title.value(container.getName() != null ? container.getName() : \"Sin nombre\");\n    refreshDomain(container);\n    refreshState(container);\n    refreshViewSelector(container);\n}\n\nprivate void refreshViewSelector(TGContainer container) {\n    if (DisplayHelper.isVerificationVisible(container, box().provider(session()))) viewSelector.showOption(\"verification\");\n    else viewSelector.hideOption(\"verification\");\n    if (roomName != null) viewSelector.address(path -> path.replace(\":name\", StringUtil.encode(roomName)).replace(\":section\", section).replace(\":location\", location).replace(\":drc\", String.valueOf(entity.drc())).replace(\":rrc\", String.valueOf(entity.rrc())));\n    if (viewSelector.selection().isEmpty() && (selectedView == null || selectedView.equals(\"default\"))) viewSelector.select(\"")).output(Outputs.placeholder("defaultView", "firstLowerCase")).output(Outputs.literal("\");\n    else if (!viewSelector.selection().isEmpty() || selectedView != null) viewSelector.select(selectedView);\n    else {\n        if (verificationBlock.isVisible()) refreshVerificationBlock();\n        ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n    }\n}\n\nprivate void openTitleEditor() {\n    title.visible(false);\n    titleEditor.value(title.value());\n    titleEditor.visible(true);\n}\n\nprivate void closeTitleEditor() {\n    title.visible(true);\n    titleEditor.visible(false);\n}\n\nprivate void saveTitle() {\n    String value = titleEditor.value();\n    ")).output(Outputs.placeholder("view", "saveTitleCall").multiple("\n")).output(Outputs.literal("\n    title.value(value);\n}\n\nprivate TGResource loadContainer() {\n    if (entityContainer == null) entityContainer = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    box().registerEdition(entityContainer);\n    return entityContainer;\n}\n\nprivate void resetContainer() {\n    if (entityContainer == null) return;\n    box().unRegisterEdition(entityContainer.getERC());\n    entityContainer = null;\n}\n\nprivate void refreshDomain(TGContainer container) {\n    linkDomain.title(backTitle);\n    if (backAddressResolver != null) linkDomain.address(backAddressResolver);\n    if (backTitle != null) {\n        domain.visible(false);\n        return;\n    }\n    TGIdentifier identifier = box().provider(session()).createIdentifier(container.getDomainIdentifier().getERC());\n    domain.title(identifier != null ? identifier.getName() : null);\n    domain.visible(identifier != null && EntitiesTemplate.Entities.contains(identifier.getDRC()));\n    selectedDomain = identifier;\n}\n\n")).output(Outputs.placeholder("view", "initMethod").multiple("\n")).output(Outputs.literal("\n")).output(Outputs.placeholder("view", "refreshMethod").multiple("\n")).output(Outputs.literal("\n")).output(Outputs.placeholder("view", "focusMethod").multiple("\n")).output(Outputs.literal("\n\npublic void refreshVerificationBlock() {\n    TGResource container = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    verificationStamp.entity(container);\n    verificationStamp.refresh();\n}\n\npublic void refreshTasksBlock() {\n    TGResource container = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    tasksStamp.openMode(TaskSetCatalogTemplate.OpenMode.Layer);\n    tasksStamp.room(room, roomName);\n    tasksStamp.entity(container);\n    tasksStamp.entityContainer(this);\n    tasksStamp.taskSetName(\"tareas\");\n    tasksStamp.visibleColumns(Set.of(\"stateIcon\", \"typeIcon\", \"name\", \"reference\", \"relatedObject\", \"createdBy\", \"madeBy\", \"process\", \"createDate\", \"madeDate\", \"state\", \"repeated\"));\n    tasksStamp.refresh();\n}\n\npublic void refreshRelationsBlock() {\n    TGResource container = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    relationsStamp.openMode(RelationSetCatalogTemplate.OpenMode.Layer);\n    relationsStamp.room(room, roomName);\n    relationsStamp.entity(container);\n    relationsStamp.entityContainer(this);\n    relationsStamp.refresh();\n}\n\npublic boolean saveSuccessfully() {\n    ValidateResult result = save();\n    return result == null || result.success() || result.getValidateError().getMessage().isEmpty();\n}\n\npublic io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult silentSave() {\n    return save(false);\n}\n\npublic io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult save() {\n    return save(true);\n}\n\nprivate io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult save(boolean showAdviseDialog) {\n    if (showAdviseDialog) notifyUser(\"Guardando...\", io.intino.alexandria.ui.displays.UserMessage.Type.Loading);\n    ValidateResult result = ValidateResult.empty();\n    ")).output(Outputs.placeholder("view", "saveCall").multiple("\n")).output(Outputs.literal("\n    reset();\n    if (showAdviseDialog) notifyUser(\"Se ha guardado correctamente\", io.intino.alexandria.ui.displays.UserMessage.Type.Success);\n    refresh();\n    return result;\n}\n\npublic void forceSave() {\n    adviseDialog.close();\n    validationResultBlock.hide();\n    ")).output(Outputs.placeholder("view", "forceSaveCall").multiple("\n")).output(Outputs.literal("\n    reset();\n    notifyUser(\"Se ha guardado correctamente\", io.intino.alexandria.ui.displays.UserMessage.Type.Success);\n    refresh();\n}\n\npublic void showValidationErrors(ValidateResult result) {\n    this.validateResult = result;\n    validationResultBlock.show();\n}\n\nprivate void finishEdition() {\n    List<String> selection = finishEditionSelector.selection();\n    if (selection.isEmpty() || selection.get(0).equals(\"cancelOption\")) return;\n    if (selection.get(0).equals(\"saveOption\")) {\n        if (validateResult != null && !validateResult.getValidateError().getMessage().isEmpty()) {\n            notifyUser(\"Debe revisar los campos con error o advertencia\", UserMessage.Type.Error);\n            return;\n        }\n        ValidateResult result = save();\n        if (!result.success() || !result.getValidateError().getMessage().isEmpty()) {\n            validateResult = null;\n            return;\n        }\n    }\n    else reset();\n    updateEdition(true);\n}\n\nprivate void refreshState() {\n    refreshState((TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc()));\n}\n\nprivate void refreshState(TGContainer container) {\n    boolean editing = box().provider(session()).isEditingResource(entity.rrc());\n    edit.readonly(editing);\n    edit.visible(readonly);\n    if (!readonly && LibraryDefinitions.isLabelEditable(container.getDefinition())) openTitleEditor();\n    else closeTitleEditor();\n    finishEdition.visible(!embedded && !readonly);\n    save.visible(!readonly);\n    remove.visible(readonly);\n    List<String> options = ProviderHelper.newProcessDefinitionsOptions(room, container);\n    addProcess.options(options);\n    addProcess.visible(readonly && !options.isEmpty());\n    remove.readonly(!io.intino.goros.egeasy.m3.library.LibraryResource.canDeleteResource(container));\n}\n\nprivate void reset() {\n    resetContainer();\n    ")).output(Outputs.placeholder("view", "resetCall").multiple("\n")).output(Outputs.literal("\n}\n\nprivate void refreshValidationResult() {\n    if (this.validateResult == null) return;\n    validationResultStamp.result(validateResult);\n    validationResultStamp.refresh();\n}\n\nprivate void focusValidationResultError(TGFieldError error) {\n    ")).output(Outputs.placeholder("view", "focusCall").multiple("\n")).output(Outputs.literal("\n}\n\nprivate void removeElement() {\n    io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult result = box().provider(session()).deleteResource(entity.rrc(), entity.drc());\n    if (!result.success()) {\n        notifyUser(result.getMessage(), UserMessage.Type.Error);\n        return;\n    }\n    notifyUser(\"Elemento eliminado\", UserMessage.Type.Success);\n    if (removeListener != null) removeListener.accept(entity);\n}\n\nprivate void open(EntitySetItem entity) {\n    if (entity == null) return;\n    selectedResource = box().provider(session()).openResource(entity.rrc(), entity.drc());\n    String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":rrc\", String.valueOf(entity.rrc())).replace(\":drc\", String.valueOf(entity.drc()));\n    ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(layer -> fillLayer(layer, entityLayerAddress), this);\n}\n\nprivate void open(TGResource resource) {\n    if (resource == null) return;\n    //entityLayerTrigger.address(path -> path.replace(\":rrc\", String.valueOf(resource.getERC())).replace(\":drc\", String.valueOf(resource.getDRC())));\n    String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":rrc\", String.valueOf(selectedResource.getERC())).replace(\":drc\", String.valueOf(selectedResource.getDRC()));\n    ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(layer -> fillLayer(layer, entityLayerAddress), this);\n}\n\nprivate void open(TGIdentifier identifier) {\n    if (identifier == null) return;\n    selectedResource = box().provider(session()).openResource(identifier.getERC(), identifier.getDRC());\n    String entityLayerAddress = \"/entidad/:rrc/:drc\".replace(\":rrc\", String.valueOf(identifier.getERC())).replace(\":drc\", String.valueOf(identifier.getDRC()));\n    ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).openLayer(l -> fillLayer(l, entityLayerAddress), this);\n}\n\nprivate void fillLayer(Layer<?, ?> layer, String entityLayerAddress) {\n    RoomTemplate template = new RoomTemplate(box());\n    template.readonly(selectedResourceReadonly);\n    template.onRemove(e -> {\n        soul().currentLayer().close();\n        ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n    });\n    layer.title(selectedResource.getIdentifier().getName());\n    layer.onBeforeClose(e -> template.checkDirty(e1 -> layer.close()));\n    layer.onClose(e -> {\n        ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n    });\n    layer.template(template);\n    box().routeManager().routeDispatcher().dispatch(soul(), entityLayerAddress);\n}\n\nprivate void updateEdition(boolean readonly) {\n    if (readonly) box().provider(session()).endEditionResource(entity.rrc());\n    else {\n        requestEditionResult = box().provider(session()).beginEditionResource(entity.rrc());\n        if (!box().provider(session()).isEditingResource(entity.rrc()) && !requestEditionResult.isSuccess()) {\n            requestEditionDialog.open();\n            return;\n        }\n    }\n    this.readonly = readonly;\n    resetContainer();\n    refreshState();\n    if (finishEditionListener != null) {\n        finishEditionListener.accept(true);\n        finishEditionListener = null;\n    }\n    ")).output(Outputs.placeholder("view", "refreshCall").multiple("\n")).output(Outputs.literal("\n    validationResultBlock.hide();\n    validateResult = null;\n}\n\nprivate void refreshRequestEdition() {\n    TGIdentifier owner = requestEditionResult.currentEditor();\n    List<Soul> ownerSouls = box().souls().stream().filter(s -> {\n        TGSessionInfo info = box().provider(s.session()).sessionInfo();\n        return info != null && owner != null && info.getURC() == owner.getERC();\n    }).collect(Collectors.toList());\n    requestEditionDialog.title(!requestEditionResult.hasPermissions() ? \"Error al poner en edici\u00f3n el elemento\" : \"El elemento ya se est\u00e1 editando\");\n    requestEdition.visible(ownerSouls.size() > 0);\n    freeEdition.visible(ownerSouls.size() == 0 && requestEditionResult.hasPermissions());\n    String message = requestEditionResult.hasPermissions() ? String.format(\"%s tiene bloqueado el elemento. \", owner != null ? owner.getName() : \"Alguien\") + (ownerSouls.isEmpty() ? \"Actualmente no est\u00e1 conectado al sistema. Haga click en liberar para comenzar la edici\u00f3n.\" : \"Haga click en solicitar para iniciar el proceso de solicitud.\") : requestEditionResult.getMessage();\n    requestEditionMessage.value(message);\n}\n\nprivate void requestEdition() {\n    requestEdition.title(\"Solicitando...\");\n    requestEdition.readonly(true);\n    TGIdentifier owner = requestEditionResult.currentEditor();\n    List<Soul> ownerSouls = box().souls().stream().filter(s -> {\n        TGSessionInfo info = box().provider(s.session()).sessionInfo();\n        return info != null && info.getURC() == owner.getERC();\n    }).collect(Collectors.toList());\n    ownerSouls.forEach(s ->\n        s.currentLayer(RoomTemplate.class).requestEdition(entity, user(), accepted -> {\n            notifyUser(accepted ? \"Solicitud aceptada\" : \"Solicitud rechazada\", accepted ? UserMessage.Type.Success : UserMessage.Type.Error);\n            requestEditionDialog.close();\n            if (accepted) updateEdition(false);\n        })\n    );\n}\n\nprivate void freeEdition() {\n    freeEdition.title(\"Liberando...\");\n    freeEdition.readonly(true);\n    boolean free = box().provider(session()).endEditionResource(entity.rrc());\n    notifyUser(free ? \"Elemento liberado\" : \"No se puede liberar el elemento\", free ? UserMessage.Type.Success : UserMessage.Type.Error);\n    if (free) requestEditionDialog.close();\n    updateEdition(false);\n}\n\nprivate void addProcess(String option) {\n    Definition definition = ProviderHelper.newProcessDefinition(room, (TGContainer) box().provider(session()).openResource(entity.rrc(), entity.drc()), option);\n    if (definition == null) {\n        notifyUser(\"No se ha podido iniciar el proceso\", UserMessage.Type.Error);\n        return;\n    }\n    ((RoomTemplate)soul().get(DisplayHelper.RoomTemplate)).addProcess(definition.getCaption(), definition.getDRC(), entity.rrc(), null);\n}\n")));
        rules.add(this.rule().condition(Predicates.allTypes("icon", "defined")).output(Outputs.literal("io.intino.goros.egeasy.box.ui.DisplayHelper.iconUrlOf(box().egeConfiguration().iconsDir() + \"/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        rules.add(this.rule().condition(Predicates.allTypes("icon")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.model.Model.class.getResource(\"/icons/")).output(Outputs.placeholder("icon", new String[0])).output(Outputs.literal(".ico\")")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("declaration"))).output(Outputs.placeholder("declarationJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("init"))).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.onInit(e -> init")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block());\n")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.onShow(e -> refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block());")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("initmethod"))).output(Outputs.literal("public void init")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    ")).output(Outputs.placeholder("initJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("public void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null && ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.dirty()) {\n        ")).output(Outputs.placeholder("refreshComponentJavaContent", new String[0])).output(Outputs.literal("\n        return;\n    }\n    ")).output(Outputs.placeholder("refreshJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("refreshmethod"))).output(Outputs.literal("public void refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block() {\n    ")).output(Outputs.placeholder("refreshJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("focusmethod"))).output(Outputs.literal("public void focus")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block(TGFieldError error) {\n    int drc = error.getDrc();\n    ")).output(Outputs.placeholder("focusJavaContent", new String[0])).output(Outputs.literal("\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("focusmethod"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("refreshcall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.isVisible()) refresh")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("focuscall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Block.isVisible()) focus")).output(Outputs.placeholder("name", "firstUpperCase")).output(Outputs.literal("Block(error);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("focuscall"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("dirtycall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null && ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.dirty()) return true;\n")).output(Outputs.placeholder("dirtyJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("dirtycall"))).output(Outputs.placeholder("dirtyJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("resetcall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.reset();\n")).output(Outputs.placeholder("resetJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("resetcall"))).output(Outputs.placeholder("resetJavaContent", new String[0])));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("savetitlecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.setContainerTitle(value);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("savetitlecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.setContainerTitle(value);")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("savecall"))).output(Outputs.literal("result = ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null && ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.dirty() ? ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.save() : ValidateResult.empty();\nvalidationResultBlock.hide();\nif (!result.success()) {\n    notifyUser(result.getMessage(), UserMessage.Type.Error);\n    return result;\n}\nif (!result.getValidateError().getMessage().isEmpty()) {\n    if (showAdviseDialog && result.getValidateError().isWarning()) {\n        adviseMessage = DisplayHelper.errorMessage(result);\n        adviseDialog.open();\n        showValidationErrors(result);\n        return result;\n    }\n    notifyUser(\"No se ha podido guardar\", UserMessage.Type.Warning);\n    showValidationErrors(result);\n    return result;\n}")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("savecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.save();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("savecall"))));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "form"), (LogicalExpression)Predicates.trigger("forcesavecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Source.forceSave();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view", "document"), (LogicalExpression)Predicates.trigger("forcesavecall"))).output(Outputs.literal("if (")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp != null) ")).output(Outputs.placeholder("name", "firstLowerCase")).output(Outputs.literal("Stamp.save();")));
        rules.add(this.rule().condition(Predicates.all((LogicalExpression)Predicates.allTypes("view"), (LogicalExpression)Predicates.trigger("forcesavecall"))));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

