/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.DefInstance;
import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import io.intino.goros.egeasy.m3.model.MatrixColumn;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.definition.SetRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.InventoryTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.util.List;

public class InventoryRenderer
extends SetRenderer {
    public InventoryRenderer(TreeNodeResource dictionary, Modernization modernization, Definition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public FrameBuilder buildFrame() throws Exception {
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("content", this.contentFrame());
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.konos.InventoryTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new InventoryTemplate();
    }

    private FrameBuilder contentFrame() throws Exception {
        FrameBuilder result = this.baseFrame().add("content");
        Object definition = this.definition();
        Definition parent = this.parent();
        result.add("name", this.nameOf((Definition)definition));
        result.add("shortName", this.shortNameOf((Definition)definition));
        result.add("parent", this.shortNameOf(parent));
        result.add("drc", ((Definition)definition).getDRC());
        this.addAddress(result);
        this.addEntityTypes((Definition)definition, result);
        this.addRun((DefInstance)definition, this.definitionLocated(this.parent()), result);
        this.addSet(result, (DefInstance)definition, (Definition)definition, (Definition)definition);
        this.addLabelColumn(result, (Definition)definition);
        return result;
    }

    private void addLabelColumn(FrameBuilder result, Definition definition) throws Exception {
        List<MatrixColumn> columns = this.columns(definition);
        result.add("labelColumn", columns.isEmpty() ? "label()" : String.format("value(\"%s\").asString()", columns.get(0).getTitle()));
    }

    @Override
    protected List<MatrixColumn> columns(Definition setDefinition) throws Exception {
        List<MatrixColumn> collectionColumns = LibraryDefinitions.getInventoryColumns(setDefinition);
        return collectionColumns.isEmpty() ? this.defaultColumns() : collectionColumns;
    }
}

