/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.entity;

import io.intino.goros.egeasy.m3.entity.TGCurrencyType;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;

public class TGCurrency {
    private static final String currencySeparator = ":";
    private TGCurrencyType type;
    private BigDecimal value;
    private boolean empty;
    private DecimalFormat decimalFormat;

    private void configureStringFormatter() {
        this.decimalFormat = new DecimalFormat("#,##0.00");
        this.decimalFormat.setMaximumFractionDigits(2);
        this.decimalFormat.setMinimumFractionDigits(2);
        this.decimalFormat.setGroupingUsed(true);
        DecimalFormatSymbols dfs = this.decimalFormat.getDecimalFormatSymbols();
        dfs.setGroupingSeparator('.');
        dfs.setDecimalSeparator(',');
        this.decimalFormat.setDecimalFormatSymbols(dfs);
    }

    public TGCurrency() {
        this.configureStringFormatter();
        this.type = TGCurrencyType.ctEuro;
        this.value = new BigDecimal(0);
        this.empty = true;
    }

    public TGCurrency(TGCurrencyType type, BigDecimal value) {
        this.configureStringFormatter();
        this.type = type;
        this.value = value;
        this.empty = false;
    }

    public void clear() {
        this.empty = true;
        this.type = TGCurrencyType.ctEuro;
        this.value = new BigDecimal(0);
    }

    public TGCurrencyType getType() {
        return this.type;
    }

    public void setType(TGCurrencyType type) {
        this.type = type;
        this.empty = false;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
        this.empty = false;
    }

    public void assignValue(TGCurrency value) {
        this.type = value.getType();
        this.value = value.getValue();
        this.empty = false;
    }

    private BigDecimal convertToBigDecimal(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        return BigDecimal.valueOf(number.doubleValue());
    }

    public void fromString(String str) {
        if (str == null || str.isEmpty()) {
            this.clear();
            return;
        }
        int ipos = str.indexOf(currencySeparator);
        if (ipos < 0) {
            this.type = TGCurrencyType.ctEuro;
        } else {
            this.type = this.strToCurrencyType(str.substring(ipos + 1));
            str = str.substring(0, ipos);
        }
        try {
            this.value = this.convertToBigDecimal(this.decimalFormat.parse(str));
        }
        catch (ParseException e) {
            this.clear();
        }
    }

    public String toString() {
        if (this.empty) {
            return "";
        }
        return this.decimalFormat.format(this.value) + currencySeparator + this.currencyTypeToStr(this.type);
    }

    private String currencyTypeToStr(TGCurrencyType type) {
        switch (type) {
            case ctEuro: {
                return "euros";
            }
            case ctPeseta: {
                return "ptas";
            }
        }
        return "";
    }

    private TGCurrencyType strToCurrencyType(String value) {
        if (value == null) {
            return TGCurrencyType.ctEuro;
        }
        if (value.equals("euros")) {
            return TGCurrencyType.ctEuro;
        }
        if (value.equals("ptas")) {
            return TGCurrencyType.ctPeseta;
        }
        return TGCurrencyType.ctUnknown;
    }
}

