/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.egeasy.m3.library;

import io.intino.goros.egeasy.m3.entity.TGEntity;
import io.intino.goros.egeasy.m3.entity.TGListComponents;
import io.intino.goros.egeasy.m3.entity.component.TGComponent;
import io.intino.goros.egeasy.m3.entity.component.TGForm;
import io.intino.goros.egeasy.m3.entity.component.TGSection;
import io.intino.goros.egeasy.m3.entity.document.TGDocument;
import io.intino.goros.egeasy.m3.entity.field.TGField;
import io.intino.goros.egeasy.m3.entity.field.TGFieldApproval;
import io.intino.goros.egeasy.m3.entity.field.TGFieldSignature;
import io.intino.goros.egeasy.m3.entity.field.TGFieldTable;
import io.intino.goros.egeasy.m3.entity.resource.TGContainer;
import io.intino.goros.egeasy.m3.entity.resource.TGResource;
import io.intino.goros.egeasy.m3.library.LibraryDefinitions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class LibraryEntity {
    public static String containerRelationsUEL(int ERC) {
        return ERC + "\\" + 45;
    }

    public static String containerTasksUEL(int ERC) {
        return ERC + "\\" + 46;
    }

    public static TGListComponents getComponents(TGEntity entity) {
        if (entity instanceof TGResource) {
            return ((TGResource)entity).getComponents();
        }
        if (entity instanceof TGComponent) {
            return ((TGComponent)entity).getComponents();
        }
        return null;
    }

    private static void fillFields(List<TGField> listfields, TGComponent component) {
        if (component instanceof TGField) {
            listfields.add((TGField)component);
        } else if (component instanceof TGForm) {
            LibraryEntity.fillFields(listfields, component.getComponents());
        } else if (component instanceof TGSection) {
            LibraryEntity.fillFields(listfields, component.getComponents());
        }
    }

    private static void fillFields(List<TGField> listfields, TGListComponents components) {
        for (TGComponent component : components.getAComponents()) {
            LibraryEntity.fillFields(listfields, component);
        }
    }

    public static List<TGField> getFields(TGEntity entity) {
        ArrayList<TGField> fieldList = new ArrayList<TGField>();
        if (entity instanceof TGResource) {
            LibraryEntity.fillFields(fieldList, ((TGResource)entity).getComponents());
        } else if (entity instanceof TGComponent) {
            LibraryEntity.fillFields(fieldList, (TGComponent)entity);
        }
        return fieldList;
    }

    public static List<TGField> getFields(TGListComponents components) {
        ArrayList<TGField> fieldList = new ArrayList<TGField>();
        LibraryEntity.fillFields(fieldList, components);
        return fieldList;
    }

    public static TGEntity findEntity(TGListComponents components, String name) {
        return LibraryEntity.findEntity(components, name, null);
    }

    public static TGEntity findEntity(TGListComponents components, String name, Integer rowIndex) {
        if (components == null) {
            return null;
        }
        for (TGComponent component : components.getAComponents()) {
            TGEntity foundEntity = component.getName().equals(name) ? component : LibraryEntity.findEntity((TGEntity)component, name, rowIndex);
            if (foundEntity == null) continue;
            return foundEntity;
        }
        return null;
    }

    public static TGEntity findEntity(TGListComponents components, int DRC) {
        return LibraryEntity.findEntity(components, null, (Integer)DRC);
    }

    public static TGEntity findEntity(TGListComponents components, int DRC, Integer rowIndex) {
        if (components == null) {
            return null;
        }
        for (TGComponent component : components.getAComponents()) {
            TGEntity foundEntity = component.getDRC() == DRC ? component : LibraryEntity.findEntity((TGEntity)component, DRC, rowIndex);
            if (foundEntity == null) continue;
            return foundEntity;
        }
        return null;
    }

    public static TGEntity findEntity(TGEntity context, int DRC, Integer row) {
        if (context instanceof TGFieldTable) {
            if (row == null) {
                return null;
            }
            TGFieldTable fieldTable = (TGFieldTable)context;
            if (fieldTable.getARows().size() <= row) {
                return null;
            }
            return LibraryEntity.findEntity(fieldTable.getARows().get(row), DRC, null);
        }
        return LibraryEntity.findEntity(LibraryEntity.getComponents(context), DRC, row);
    }

    public static TGEntity findEntity(TGEntity context, int DRC) {
        return LibraryEntity.findEntity(context, DRC, null);
    }

    public static TGEntity findEntity(TGEntity context, String name, Integer row) {
        if (context instanceof TGFieldTable) {
            if (row == null) {
                return null;
            }
            TGFieldTable fieldTable = (TGFieldTable)context;
            if (fieldTable.getARows().size() <= row) {
                return null;
            }
            return LibraryEntity.findEntity(fieldTable.getARows().get(row), name, null);
        }
        return LibraryEntity.findEntity(LibraryEntity.getComponents(context), name, row);
    }

    public static TGEntity findEntity(TGEntity context, String name) {
        return LibraryEntity.findEntity(context, name, null);
    }

    public static boolean isSigned(TGResource resource) {
        List<TGField> fields = LibraryEntity.getFields(resource);
        List signatureFields = fields.stream().filter(component -> component instanceof TGFieldSignature).collect(Collectors.toList());
        return signatureFields.stream().filter(field -> !((TGFieldSignature)field).isEmpty()).count() > 0L;
    }

    public static boolean isApproved(TGResource resource) {
        List<TGField> fields = LibraryEntity.getFields(resource);
        List signatureFields = fields.stream().filter(component -> component instanceof TGFieldApproval).collect(Collectors.toList());
        return signatureFields.stream().filter(field -> !((TGFieldApproval)field).isEmpty()).count() > 0L;
    }

    public TGContainer getContainer(TGEntity entity) {
        for (TGEntity entityInt = entity; entityInt != null; entityInt = entityInt.getDomain()) {
            if (!(entityInt instanceof TGContainer)) continue;
            return (TGContainer)entityInt;
        }
        return null;
    }

    public TGDocument getDocument(TGContainer container) {
        Optional<TGComponent> optional = container.getComponents().getAComponents().stream().filter(item -> item instanceof TGDocument).findFirst();
        return optional.isPresent() ? (TGDocument)optional.get() : null;
    }

    public static boolean isEditionSuggestion(TGField field) {
        return LibraryDefinitions.isEditionSuggestion(field.getDefinition());
    }

    public static boolean isEditionReference(TGField field) {
        return LibraryDefinitions.isEditionReference(field.getDefinition());
    }

    public static boolean isEditionCopy(TGField field) {
        return LibraryDefinitions.isEditionCopy(field.getDefinition());
    }
}

