/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.Formatters;
import io.intino.goros.modernizing.egeasy.renderers.Renderer;
import io.intino.goros.modernizing.egeasy.util.StringUtil;
import io.intino.itrules.Engine;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class DefinitionRenderer<D extends Definition>
extends Renderer {
    private final D definition;
    private final Set<String> addedDisplays = new HashSet<String>();
    private Definition root = null;
    private Definition parent = null;
    private Definition owner;
    private boolean forTable = false;
    private String context = null;
    protected List<String> types = new ArrayList<String>();
    public static final Set<Integer> DefinitionSet = new HashSet<Integer>();

    public DefinitionRenderer(TreeNodeResource dictionary, Modernization modernization, D definition) {
        super(dictionary, modernization);
        this.definition = definition;
        DefinitionSet.add(((Definition)definition).getDRC());
    }

    public String context() {
        return this.context;
    }

    public DefinitionRenderer<D> context(String context) {
        this.context = context;
        return this;
    }

    public D definition() {
        return this.definition;
    }

    public Definition root() {
        return this.root;
    }

    public <T extends DefinitionRenderer<?>> T root(Definition root) {
        this.root = root;
        return (T)this;
    }

    public Definition parent() {
        return this.parent;
    }

    public <T extends DefinitionRenderer<?>> T parent(Definition definition) {
        this.parent = definition;
        return (T)this;
    }

    public Definition owner() {
        return this.owner;
    }

    public <T extends DefinitionRenderer<?>> T owner(Definition definition) {
        this.owner = definition;
        return (T)this;
    }

    public boolean forTable() {
        return this.forTable;
    }

    public <T extends DefinitionRenderer<?>> T forTable(boolean value) {
        this.forTable = value;
        return (T)this;
    }

    public <T extends DefinitionRenderer<?>> T types(String ... types) {
        this.types = Arrays.asList(types);
        return (T)this;
    }

    @Override
    public void write() throws Exception {
        this.write(this.buildFrame());
    }

    public String konosContent() throws Exception {
        FrameBuilder builder = this.buildFrame();
        return new Engine(this.konosTemplate()).addAll(Formatters.all).render(builder.toFrame());
    }

    public String javaContent() throws Exception {
        FrameBuilder builder = this.buildFrame();
        return new Engine(this.javaTemplate()).addAll(Formatters.all).render(builder.toFrame());
    }

    public abstract FrameBuilder buildFrame() throws Exception;

    protected abstract Template konosTemplate();

    protected abstract Template javaTemplate();

    protected void write(FrameBuilder builder) {
        this.writeJava(builder);
        this.writeKonos(builder);
    }

    protected void resetAddedDisplays() {
        this.addedDisplays.clear();
    }

    protected FrameBuilder iconFrameOf(Definition definition) {
        FrameBuilder result = this.baseFrame().add("icon");
        String icon = definition.getAttributes().findAttribute("ICONO").stream().findFirst().orElse(null);
        if (icon != null) {
            result.add("defined");
        }
        result.add("icon", icon != null ? StringUtil.firstUpperCase(icon) : "Default");
        return result;
    }

    protected FrameBuilder baseDefinitionFrame() {
        return this.baseDefinitionFrame((Definition)this.definition);
    }

    protected FrameBuilder baseDefinitionFrame(Definition definition) {
        FrameBuilder result = super.baseFrame();
        result.add("definition");
        this.types.forEach(result::add);
        this.addParentProperties(result);
        result.add("name", this.nameOf(definition));
        result.add("definitionName", definition.getName());
        result.add("drc", definition.getDRC());
        result.add("code", definition.getName());
        result.add("label", this.labelOf(definition));
        return result;
    }

    private void addParentProperties(FrameBuilder result) {
        if (this.parent == null) {
            return;
        }
        result.add("embedded");
        result.add("parent", this.nameOf(this.parent));
    }

    protected void writeJava(FrameBuilder builder) {
        File file = new File(this.javaPackage() + StringUtil.firstUpperCase(this.nameOf((Definition)this.definition)) + "Template.java");
        this.writeFrame(file, new Engine(this.javaTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }

    protected void writeKonos(FrameBuilder builder) {
        File file = new File(this.konosPackage() + StringUtil.firstUpperCase(this.nameOf((Definition)this.definition)) + ".konos");
        this.writeFrame(file, new Engine(this.konosTemplate()).addAll(Formatters.all).render(builder.toFrame()));
    }
}

