/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.definition;

import io.intino.goros.egeasy.m3.definition.base.Definition;
import io.intino.goros.egeasy.m3.definition.metamodel.Metamodel;
import io.intino.goros.egeasy.m3.utils.DefinitionUtils;
import io.intino.goros.modernizing.egeasy.Modernization;
import io.intino.goros.modernizing.egeasy.model.TreeNodeResource;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRenderer;
import io.intino.goros.modernizing.egeasy.renderers.DefinitionRendererFactory;
import io.intino.goros.modernizing.egeasy.renderers.definition.EntitySetItemRenderer;
import io.intino.goros.modernizing.egeasy.renderers.templates.java.ContainerTemplate;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import java.util.List;

public class ContainerRenderer
extends EntitySetItemRenderer<Definition> {
    private DefinitionRendererFactory factory = new DefinitionRendererFactory();

    public ContainerRenderer(TreeNodeResource dictionary, Modernization modernization, Definition definition) {
        super(dictionary, modernization, definition);
    }

    @Override
    public FrameBuilder buildFrame() throws Exception {
        FrameBuilder result = this.baseDefinitionFrame();
        result.add("content", this.contentFrame());
        return result;
    }

    private FrameBuilder contentFrame() throws Exception {
        Object definition = this.definition();
        FrameBuilder result = this.baseFrame().add("content");
        result.add("name", this.nameOf((Definition)definition));
        result.add("label", this.labelOf((Definition)definition));
        result.add("icon", this.iconFrameOf((Definition)definition));
        List<Definition> definitions = DefinitionUtils.sortedUiComponentDefinitions(((Definition)this.definition()).getDefinitions());
        for (Definition d : definitions) {
            result.add("view", this.viewFrame(d));
        }
        if (!definitions.isEmpty()) {
            result.add("defaultView", this.nameOf(definitions.get(0)));
        }
        return result;
    }

    private FrameBuilder viewFrame(Definition definition) throws Exception {
        FrameBuilder result = this.baseFrame().add("view");
        result.add("name", this.nameOf(definition));
        result.add("label", this.labelOf(definition));
        if (definition.getTypeValue() == Metamodel.getInstance().DTCollection.getTypeValue()) {
            result.add("collection");
        }
        if (definition.getTypeValue() == Metamodel.getInstance().DTForm.getTypeValue()) {
            result.add("form");
        }
        if (definition.getTypeValue() == Metamodel.getInstance().DTDocument.getTypeValue()) {
            result.add("document");
        }
        result.add("konosContent", ((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).konosContent());
        result.add("konosToolbarContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("toolbar")).owner(definition)).konosContent());
        result.add("useKonosContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("use")).owner(definition)).konosContent());
        result.add("dirtyJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("dirty")).owner(definition)).javaContent());
        result.add("resetJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("reset")).owner(definition)).javaContent());
        result.add("declarationJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("declaration")).owner(definition)).javaContent());
        result.add("initJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("init")).owner(definition)).javaContent());
        result.add("refreshComponentJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("refreshComponent")).owner(definition)).javaContent());
        result.add("refreshJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("refresh")).owner(definition)).javaContent());
        result.add("focusJavaContent", ((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)((DefinitionRenderer)this.factory.renderer(this.dictionary, this.modernization, definition).root(this.root())).parent((Definition)this.definition())).types("focus")).owner(definition)).javaContent());
        return result;
    }

    @Override
    protected Template konosTemplate() {
        return new io.intino.goros.modernizing.egeasy.renderers.templates.konos.ContainerTemplate();
    }

    @Override
    protected Template javaTemplate() {
        return new ContainerTemplate();
    }
}

