/*
 * Decompiled with CFR 0.152.
 */
package io.intino.goros.modernizing.egeasy.renderers.templates.java;

import io.intino.itrules.Engine;
import io.intino.itrules.Formatter;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.condition.predicates.Predicates;
import io.intino.itrules.template.outputs.Outputs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EditorsTemplate
extends Template {
    @Override
    public List<Rule> ruleSet() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(this.rule().condition(Predicates.allTypes("ui", "fileEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.m3.file.File;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.function.Consumer;\n\npublic class FileEditor extends AbstractFileEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private Integer fileId;\n    private String title;\n    private File file;\n    private Consumer<Object> changeListener;\n\n    public FileEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void file(Integer fileId, String title) {\n        this.fileId = fileId;\n        this.title = title;\n    }\n\n    public void file(File file) {\n        this.file = file;\n    }\n\n    public void focus() {\n        if (localFileBlock.isVisible()) localFileBlock.localFile.focus();\n        if (ndeBlock.isVisible()) ndeBlock.nde.focus();\n    }\n\n    public void onChange(Consumer<Object> listener) {\n        this.changeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        initBlocks();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        originSelector.select(\"fromLocalFile\");\n    }\n\n    private void initBlocks() {\n        localFileBlock.onInit(e -> initLocalFileBlock());\n        localFileBlock.onShow(e -> refreshLocalFileBlock());\n        ndeBlock.onInit(e -> initNdeBlock());\n        ndeBlock.onShow(e -> refreshNdeBlock());\n    }\n\n    private void initLocalFileBlock() {\n        localFileBlock.localFile.onChange(e -> changeListener.accept(e.value()));\n        localFileBlock.localFile.onDownloadStarted(e -> notifyUser(\"Preparando descarga...\", UserMessage.Type.Loading));\n        localFileBlock.localFile.onDownloadFinished(e -> hideUserNotification());\n        localFileBlock.downloadLocalFileWithoutSign.onExecute(e -> downloadFileWithoutSign());\n    }\n\n    private void refreshLocalFileBlock() {\n        loadFile();\n        localFileBlock.localFile.value(FileHelper.uiFileOf(file, true, session()));\n        localFileBlock.downloadLocalFileWithoutSign.visible(file != null);\n    }\n\n    private void loadFile() {\n        if (file != null) return;\n        file = null; // TODO Nacho. Cargar el fichero usando provider\n    }\n\n    private void initNdeBlock() {\n        ndeBlock.nde.onChange(e -> changeListener.accept(e.value()));\n    }\n\n    private void refreshNdeBlock() {\n        ndeBlock.nde.value(file != null ? file.getPlatinoNDE() : null);\n    }\n\n    private UIFile downloadFileWithoutSign() {\n        io.intino.alexandria.ui.File result = FileHelper.uiFileOf(file, false, session());\n        return new UIFile() {\n            @Override\n            public String label() {\n                return result.filename();\n            }\n\n            @Override\n            public InputStream content() {\n                try {\n\t\t\t\t\tnotifyUser(\"Preparando descarga...\", UserMessage.Type.Loading);\n                    InputStream stream = result.value().openStream();\n                    hideUserNotification();\n                    return stream;\n                } catch (IOException e) {\n                    Logger.error(e);\n                    return new ByteArrayInputStream(new byte[0]);\n                }\n            }\n        };\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "fileFieldEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.m3.file.File;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.ByteArrayInputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.function.Consumer;\n\npublic class FileFieldEditor extends AbstractFileFieldEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String title;\n    private Consumer<Object> changeListener;\n    private boolean readonly = true;\n    private Field field;\n    private File value;\n\n    public FileFieldEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public FileFieldEditor title(String title) {\n        this.title = title;\n        return this;\n    }\n\n    public FileFieldEditor field(Field field) {\n        this.field = field;\n        return this;\n    }\n\n    public FileFieldEditor value(File value) {\n        this.value = value;\n        return this;\n    }\n\n    public FileFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public FileFieldEditor focus() {\n        fileEditor.focus();\n        return this;\n    }\n\n    public FileFieldEditor onChange(Consumer<Object> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        downloadFileWithoutSign.onExecute(e -> downloadFileWithoutSign());\n        editionBlock.fileEditor.onChange(e -> changeListener.accept(e));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshReadonlyBlock();\n        refreshEditionBlock();\n    }\n\n    private void refreshReadonlyBlock() {\n        titleReadonly.value(this.title);\n        readonlyBlock.visible(readonly);\n        file.value(FileHelper.uiFileOf(value, true, session()));\n        file.readonly(true);\n        downloadFileWithoutSign.visible(value != null);\n    }\n\n    private void refreshEditionBlock() {\n        titleEdition.value(this.title);\n        editionBlock.visible(!readonly);\n        editionBlock.fileEditor.file(value);\n        editionBlock.fileEditor.refresh();\n    }\n\n    private UIFile downloadFileWithoutSign() {\n        io.intino.alexandria.ui.File result = FileHelper.uiFileOf(value, false, session());\n        return new UIFile() {\n            @Override\n            public String label() {\n                return result.filename();\n            }\n\n            @Override\n            public InputStream content() {\n                try {\n                    notifyUser(\"Preparando descarga...\", UserMessage.Type.Loading);\n                    InputStream stream = result.value().openStream();\n                    hideUserNotification();\n                    return stream;\n                } catch (IOException e) {\n                    Logger.error(e);\n                    return new ByteArrayInputStream(new byte[0]);\n                }\n            }\n        };\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "signFieldEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.SignDocument.BeforeSignChecker;\nimport io.intino.alexandria.ui.displays.events.AddCollectionItemEvent;\nimport io.intino.alexandria.ui.services.push.User;\nimport io.intino.goros.egeasy.box.ui.datasources.CandidateListDatasource;\nimport io.intino.goros.egeasy.box.ui.model.Candidate;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.box.ui.model.Signature;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.rows.CandidateSelectorListRow;\n\nimport java.io.InputStream;\nimport java.util.ArrayList;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class SignFieldEditor extends AbstractSignFieldEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String _title;\n    private Field field;\n    private List<Candidate> candidateList;\n    private Consumer<Signature> changeListener;\n    private Consumer<String> signListener;\n    private boolean readonly = true;\n    private boolean allowSign = true;\n    private Function<Field, InputStream> documentProvider;\n    private BeforeSignChecker beforeSignChecker;\n    private Signature signature;\n    private Candidate candidate;\n\n    public SignFieldEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public SignFieldEditor title(String title) {\n        this._title = title;\n        return this;\n    }\n\n    public SignFieldEditor field(Field field) {\n        this.field = field;\n        return this;\n    }\n\n    public SignFieldEditor beforeSignChecker(BeforeSignChecker checker) {\n        this.beforeSignChecker = checker;\n        return this;\n    }\n\n    public SignFieldEditor documentProvider(Function<Field, InputStream> documentProvider) {\n        this.documentProvider = documentProvider;\n        return this;\n    }\n\n    public SignFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public SignFieldEditor focus() {\n        candidateSelector.focus();\n        return this;\n    }\n\n    public SignFieldEditor candidates(List<Candidate> candidateList) {\n        this.candidateList = candidateList;\n        return this;\n    }\n\n    public SignFieldEditor onChange(Consumer<Signature> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    public SignFieldEditor onSign(Consumer<String> listener) {\n        this.signListener = listener;\n        return this;\n    }\n\n    public SignFieldEditor allowSign(boolean value) {\n        this.allowSign = value;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        candidateSelector.onSelect(e -> updateCandidate(e.selection()));\n        candidateSelector.valueProvider(candidate -> candidate instanceof String ? (String)candidate : ((Candidate)candidate).fullName());\n        candidateSelector.candidateSelectorList.onAddItem(this::refreshCandidateListItem);\n        footerSelectorDialog.onOpen(e -> refreshFooterSelector());\n        footerSelectorDialog.onSelect(e -> selectFooter());\n        sign.beforeSignChecker(beforeSignChecker);\n        sign.onSign(e -> signListener.accept(e.signature()));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(this._title);\n        Signature signature = field != null ? field.asSignature() : null;\n        refreshSignedBlock(signature);\n        refreshNotSignedBlock(signature);\n    }\n\n    private void refreshSignedBlock(Signature signature) {\n        boolean signed = isSigned(signature);\n        signedBlock.visible(signed);\n        if (!signed) return;\n        signer.value(signature.signer());\n        signDate.value(signature.signDate());\n    }\n\n    private void refreshNotSignedBlock(Signature signature) {\n        boolean signed = isSigned(signature);\n        String id = signature != null ? signature.id() : null;\n        notSignedBlock.visible(signature == null || !signature.isSigned());\n        if (signed) return;\n        candidateSelector.source(new CandidateListDatasource(box().provider(session()), session(), candidateList));\n        if (signature != null && signature.candidate() != null) candidateSelector.selection(labelOf(signature.candidate()));\n        else candidateSelector.selection(new ArrayList<>());\n        candidateSelector.readonly(readonly || field.readonly());\n        refreshSignButton(signature);\n    }\n\n    private void refreshSignButton(Signature signature) {\n        String id = signature != null ? signature.id() : null;\n        User candidate = signature != null ? signature.candidate() : null;\n        if (id != null) sign.documentProvider(() -> documentProvider.apply(field));\n        sign.readonly(readonly || field.readonly());\n        sign.visible(false/*allowSign && id != null && candidate != null && DisplayHelper.canSign(candidate, session())*/);\n    }\n\n    private String labelOf(User user) {\n        return user.fullName() + \" (\" + user.username() + \")\";\n    }\n\n    private boolean isSigned(Signature signature) {\n        return signature != null && signature.isSigned();\n    }\n\n    private void updateCandidate(List<Candidate> selection) {\n        Signature signature = field.asSignature();\n        refreshSignButton(signature);\n        if (signature == null) return;\n        Candidate candidate = !selection.isEmpty() ? selection.get(0) : null;\n        signature.candidate(candidate);\n        signature.position(candidate != null ? candidate.position() : null);\n        signature.department(candidate != null ? candidate.department() : null);\n        if (candidate != null && candidate.footers().size() > 1) {\n            openFooterSelector(signature, candidate);\n            return;\n        }\n        signature.delegation(candidate != null && !candidate.footers().isEmpty() ? candidate.footers().get(0) : null);\n        changeListener.accept(signature);\n    }\n\n    private void openFooterSelector(Signature signature, Candidate candidate) {\n        this.signature = signature;\n        this.candidate = candidate;\n        footerSelectorDialog.open();\n    }\n\n    private void refreshFooterSelector() {\n        footerSelector.clear();\n        footerSelector.addAll(candidate.footers());\n    }\n\n    private void selectFooter() {\n        if (footerSelector.selection().isEmpty()) {\n            notifyUser(\"Seleccione el pie a utilizar en la firma\", UserMessage.Type.Warning);\n            return;\n        }\n        signature.delegation(footerSelector.selection().get(0));\n        footerSelectorDialog.close();\n        changeListener.accept(signature);\n    }\n\n    private void refreshCandidateListItem(AddCollectionItemEvent event) {\n        Candidate candidate = event.item();\n        CandidateSelectorListRow row = event.component();\n        row.candidateSelectorListFullNameView.fullName.value(candidate.fullName());\n        row.candidateSelectorListUsernameView.username.value(candidate.username());\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "checkTableFieldEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.editable.Editable;\nimport io.intino.alexandria.ui.displays.events.ChangeEvent;\nimport io.intino.alexandria.ui.displays.events.ChangeListener;\nimport io.intino.alexandria.ui.displays.events.ReadonlyListener;\nimport io.intino.alexandria.ui.displays.notifiers.DisplayNotifier;\nimport io.intino.goros.egeasy.box.ui.datasources.CheckTableDatasource;\nimport io.intino.goros.egeasy.box.ui.model.Field;\nimport io.intino.goros.egeasy.m3.entity.component.TGForm;\nimport io.intino.goros.egeasy.m3.entity.field.TGCheckItem;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class CheckTableFieldEditor extends AbstractCheckTableFieldEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> implements Editable<DisplayNotifier, ")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String _title;\n    private TGForm form;\n    private Field field;\n    private CheckTableDatasource source;\n    private boolean readonly;\n    private ChangeListener changeListener;\n    private Consumer<Field> suggestListener;\n\n    public CheckTableFieldEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void title(String title) {\n        this._title = title;\n    }\n\n    public void form(TGForm form) {\n        this.form = form;\n        reloadSource();\n    }\n\n    public void field(Field field) {\n        this.field = field;\n        reloadSource();\n    }\n\n    @Override\n    public boolean readonly() {\n        return readonly;\n    }\n\n    public CheckTableFieldEditor readonly(boolean readonly) {\n        this.readonly = readonly;\n        refresh();\n        return this;\n    }\n\n    @Override\n    public CheckTableFieldEditor onChange(ChangeListener listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    @Override\n    public CheckTableFieldEditor onReadonly(ReadonlyListener listener) {\n        return this;\n    }\n\n    public CheckTableFieldEditor onSuggest(Consumer<Field> listener) {\n        this.suggestListener = listener;\n        return this;\n    }\n\n    @Override\n    public void reload() {\n        refresh();\n    }\n\n    @Override\n    public CheckTableFieldEditor focus() {\n        optionField.focus();\n        return this;\n    }\n\n    public boolean dirty() {\n        return source.dirty();\n    }\n\n    public void reset() {\n        source.reset();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        optionField.onEnterPress(e -> {\n            String value = e.value();\n            if (value != null && !value.isEmpty()) addOption();\n        });\n        optionField.onChange(e -> addOption.visible(e.value() != null && !((String)e.value()).isEmpty()));\n        suggest.onExecute(e -> suggestListener.accept(field));\n        addOption.onExecute(e -> addOption());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(_title);\n        List<TGCheckItem> items = source.items();\n        optionField.readonly(readonly);\n        addOption.readonly(readonly);\n        suggest.visible(suggestListener != null);\n        if (suggest.visible()) suggest.readonly(readonly);\n        options.clear();\n        items.forEach(i -> fill(i, options.add()));\n    }\n\n    private void fill(TGCheckItem checkItem, CheckTableFieldItemEditor display) {\n        display.check(checkItem);\n        display.readonly(readonly);\n        display.onChange(e -> changeListener.accept(new ChangeEvent(this, field.asCheckTable())));\n        display.onRemove(e -> {\n            source.remove(checkItem);\n            changeListener.accept(new ChangeEvent(this, field.asCheckTable()));\n            refresh();\n        });\n        display.refresh();\n    }\n\n    private void reloadSource() {\n        if (form == null || field == null) return;\n        source = new CheckTableDatasource(box().provider(session()), session(), form, field.asCheckTable());\n    }\n\n    private void addOption() {\n        TGCheckItem item = new TGCheckItem();\n        item.setChecked(true);\n        item.setSubject(optionField.value());\n        source.add(item);\n        changeListener.accept(new ChangeEvent(this, field.asCheckTable()));\n        optionField.value(null);\n        refresh();\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "checkTableFieldItemEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.m3.entity.field.TGCheckItem;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class CheckTableFieldItemEditor extends AbstractCheckTableFieldItemEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGCheckItem check;\n    private Consumer<TGCheckItem> changeListener;\n    private Consumer<TGCheckItem> removeListener;\n    private boolean readonly;\n\n    public CheckTableFieldItemEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void check(TGCheckItem check) {\n        this.check = check;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onChange(Consumer<TGCheckItem> listener) {\n        this.changeListener = listener;\n    }\n\n    public void onRemove(Consumer<TGCheckItem> listener) {\n        this.removeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        optionSelector.onSelect(e -> updateChecked(e.selection()));\n        removeOption.onExecute(e -> removeListener.accept(check));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        optionSelector.readonly(readonly);\n        removeOption.readonly(readonly);\n        optionSelector.clear();\n        optionSelector.add(check.getSubject());\n        optionSelector.selection(check.isChecked() && check.getSubject() != null ? List.of(check.getSubject()) : Collections.emptyList());\n    }\n\n    private void updateChecked(List<String> selection) {\n        check.setChecked(!selection.isEmpty());\n        changeListener.accept(check);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "containerDocument")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.MimeTypes;\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.File;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.components.documenteditor.DocumentManager;\nimport io.intino.alexandria.ui.displays.events.actionable.ToggleEvent;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.util.FileHelper;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.CreateFileFromTemplateResult;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.SaveFileResult;\nimport io.intino.goros.egeasy.m3.entity.component.TGComponent;\nimport io.intino.goros.egeasy.m3.entity.document.TGDocument;\nimport io.intino.goros.egeasy.m3.entity.resource.TGContainer;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport io.intino.goros.egeasy.m3.file.FileContent;\nimport io.intino.goros.egeasy.m3.library.LibraryDocuments;\nimport org.apache.commons.io.FilenameUtils;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.UUID;\n\npublic class ContainerDocumentTemplate extends AbstractContainerDocumentTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGResource container;\n    private TGComponent component;\n    private boolean readonly = true;\n    private boolean dirty = false;\n    private final String defaultFilename;\n\n    public ContainerDocumentTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n        defaultFilename = UUID.randomUUID() + \".odt\";\n    }\n\n    public ContainerDocumentTemplate container(TGResource container) {\n        this.container = container;\n        return this;\n    }\n\n    public ContainerDocumentTemplate component(TGComponent component) {\n        this.component = component;\n        return this;\n    }\n\n    public ContainerDocumentTemplate readonly(boolean readonly) {\n        this.readonly = readonly;\n        return this;\n    }\n\n    public boolean dirty() {\n        return this.dirty;\n    }\n\n    public void setContainerTitle(String value) {\n        container.setName(value);\n        dirty = true;\n    }\n\n    public void save() {\n        if (!dirty) return;\n        box().provider(session()).saveResource(container, false);\n        dirty = false;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        editDocumentWizard.onDownload(v -> downloadDocument());\n        editDocumentWizard.onSave(this::replaceDocument);\n        editDocumentWizard.triggerLabel(\"Editar documento\");\n        editDocumentWizard.mode(DocumentWizard.Mode.Icon);\n        addDocumentWizard.onDownload(v -> downloadDocument());\n        addDocumentWizard.onSave(this::replaceDocument);\n        addDocumentWizard.triggerLabel(\"[a\u00f1adir]\");\n        addDocumentWizard.mode(DocumentWizard.Mode.Link);\n        createDocumentFromTemplate.onExecute(e -> restoreTemplate());\n        restoreTemplate.onExecute(e -> restoreTemplate());\n        openWorkDocument.onExecute(e -> openWorkDocument());\n        certifyCopy.beforeSignChecker(() -> true);\n        certifyCopy.onSign(e -> certifyCopy(e.signature()));\n        signatureBoxSwitch.state(ToggleEvent.State.On);\n        signatureBoxSwitch.onToggle(e -> refreshPreview(file()));\n        editor.editorUrl(box().configuration().documentEditorUrl());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        File file = file();\n        editDocumentWizard.readonly(readonly || !LibraryDocuments.isEditableDocument((TGContainer) container));\n        editDocumentWizard.triggerLabel(\"Editar documento\");\n        editDocumentWizard.visible(file != null);\n        editDocumentWizard.refresh();\n        addDocumentWizard.readonly(readonly || !LibraryDocuments.isEditableDocument((TGContainer) container));\n        addDocumentWizard.triggerLabel(\"[a\u00f1adir]\");\n        addDocumentWizard.visible(file != null);\n        addDocumentWizard.refresh();\n        createDocumentFromTemplate.readonly(readonly || !LibraryDocuments.canCreateFromTemplate((TGContainer) container));\n        openWorkDocument.readonly(component == null || !LibraryDocuments.isOpenableWorkDocument((TGContainer) container));\n        restoreTemplate.readonly(!DisplayHelper.isOdt(file));\n        certifyCopy.document(file != null ? file.value() : null);\n        certifyCopy.readonly(!LibraryDocuments.canSaveEE03Signature((TGContainer) container));\n        toggleDocumentDialog();\n        refreshPreview(file);\n    }\n\n    private DocumentManager documentManager(File file) {\n        return new DocumentManager() {\n            @Override\n            public DocumentInfo info(String id) {\n                String filename = editorFileId();\n                return new DocumentInfo(filename, filename, clean(username()), readonly || !LibraryDocuments.isEditableDocument((TGContainer) container));\n            }\n\n            @Override\n            public InputStream load(String id) {\n                FileContent fileContent = box().provider(session()).openDocumentFile(container, component.getDRC(), signatureBoxSwitch.state() == ToggleEvent.State.On);\n                return fileContent != null ? fileContent.getContent() : null;\n            }\n\n            @Override\n            public void save(String id, InputStream content) {\n                SaveFileResult result = box().provider(session()).saveDocumentFile(container.getERC(), container.getDRC(), component.getDRC(), file.filename(), content);\n                if (!result.isSuccess()) {\n                    notifyUser(\"No se pudo guardar el documento\", UserMessage.Type.Error);\n                    return;\n                }\n                io.intino.goros.egeasy.box.ui.utils.ComponentUtils.updateFileInfo(result.getFile(), component);\n            }\n\n        };\n    }\n\n    private String editorFileId() {\n        TGDocument document = (TGDocument) component;\n        if (document == null) return null;\n        String extension = DisplayHelper.extensionOf(filename());\n        int idFile = document.getIdFile();\n        return clean(box().configuration().port() + (idFile != -1 ? idFile : UUID.randomUUID().toString()) + \".\" + extension);\n    }\n\n    private String clean(String value) {\n        return value.replace(\"\\\\\", \"\\\\\\\\\");\n    }\n\n    private void toggleDocumentDialog() {\n        if (readonly && editDocumentWizard.isVisible()) editDocumentWizard.close();\n        else if (!readonly && !editDocumentWizard.isVisible()) editDocumentWizard.open();\n    }\n\n    private UIFile downloadDocument() {\n        FileContent fileContent = box().provider(session()).openDocumentFile(container, component.getDRC(), signatureBoxSwitch.state() == ToggleEvent.State.On);\n        return new UIFile() {\n            @Override\n            public String label() {\n                return fileContent.getFilename();\n            }\n\n            @Override\n            public InputStream content() {\n                return fileContent.getContent();\n            }\n        };\n    }\n\n    private SaveFileResult replaceDocument(Resource document) {\n        try {\n            SaveFileResult result = box().provider(session()).saveDocumentFile(container.getERC(), container.getDRC(), component.getDRC(), document.name(), document.stream());\n            if (!result.isSuccess()) return result;\n            io.intino.goros.egeasy.box.ui.utils.ComponentUtils.updateFileInfo(result.getFile(), component);\n            refresh();\n            return result;\n        } catch (IOException e) {\n            Logger.error(e);\n            return null;\n        }\n    }\n\n    private void refreshPreview(File file) {\n        String documentEditorUrl = box().configuration().documentEditorUrl();\n        boolean showPreview = documentEditorUrl == null || documentEditorUrl.isEmpty() || (!DisplayHelper.isOdt(file) && !DisplayHelper.isRtf(file));\n        loadingBlock.visible(true);\n        previewBlock.visible(false);\n        documentEditorBlock.visible(false);\n        noPreviewBlock.visible(false);\n        preview.value(file);\n        loadingBlock.visible(false);\n        previewBlock.visible(file != null && showPreview);\n        documentEditorBlock.visible(file != null && !showPreview);\n        if (file != null && documentEditorBlock.isVisible()) {\n            editor.document(editorFileId());\n            editor.documentManager(documentManager(file));\n            editor.refresh();\n        }\n        noPreviewBlock.visible(file == null);\n    }\n\n    private File file() {\n        TGDocument document = (TGDocument) component;\n        if (document == null) return null;\n        String filename = filename();\n        int fileId = document.getIdFile();\n        return new File().filename(filename).value(FileHelper.urlOf(container.getERC(), container.getDRC(), component.getDRC(), -1, fileId, io.intino.goros.egeasy.m3.file.File.Type.Document, filename, signatureBoxSwitch.state() == ToggleEvent.State.On, session())).mimeType(MimeTypes.contentTypeOf(DisplayHelper.extensionOf(filename)));\n    }\n\n    private String filename() {\n        String filename = ((TGDocument)component).getFileName();\n        return filename != null && !filename.isEmpty() ? filename : defaultFilename;\n    }\n\n    private void restoreTemplate() {\n        notifyUser(\"Restaurando plantilla. Por favor, espere...\", UserMessage.Type.Loading);\n        CreateFileFromTemplateResult result = box().provider(session()).createFileFromTemplate(container.getERC(), container.getDRC(), component.getDRC());\n        if (!result.isSuccess()) {\n            notifyUser(\"No se pudo restaurar la plantilla\", UserMessage.Type.Error);\n            return;\n        }\n        updateDocument(result.getFilename(), result.getFileId());\n        notifyUser(\"Plantilla restaurada\", UserMessage.Type.Success);\n        refresh();\n    }\n\n    private void updateDocument(String filename, int fileId) {\n        TGDocument document = (TGDocument) component;\n        document.setFileName(filename);\n        document.setIdFile(fileId);\n        dirty = true;\n    }\n\n    private UIFile openWorkDocument() {\n        InputStream inputStream = box().provider(session()).openWorkDocumentFile(container.getERC(), container.getDRC(), component.getDRC());\n        return DisplayHelper.uiFileOf(component.getERC() + \".odt\", inputStream);\n    }\n\n    private void certifyCopy(String signature) {\n        if (!box().provider(session()).saveDocumentCopyEE03(container.getERC(), container.getDRC(), component.getDRC(), signature)) {\n            notifyUser(\"No se ha podido certificar la copia aut\u00e9ntica\", UserMessage.Type.Error);\n            return;\n        }\n        notifyUser(\"Copia aut\u00e9ntica certificada\", UserMessage.Type.Success);\n        refreshPreview(file());\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "documentWizard")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.Resource;\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.SaveFileResult;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class DocumentWizard extends AbstractDocumentWizard<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String triggerLabel;\n    private Mode mode;\n    private boolean readonly;\n    private Resource newDocumentResource = null;\n    private Function<Resource, SaveFileResult> saveListener;\n    private Function<Boolean, UIFile> downloadListener;\n\n    public enum Mode { Icon, Link, Button }\n\n    public DocumentWizard(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void triggerLabel(String label) {\n        this.triggerLabel = label;\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n    }\n\n    public boolean readonly() {\n        return readonly;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    public void onDownload(Function<Boolean, UIFile> listener) {\n        this.downloadListener = listener;\n    }\n\n    public void onSave(Function<Resource, SaveFileResult> listener) {\n        this.saveListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        uploadDialog.onOpen(e -> {\n            save.readonly(true);\n            newDocumentResource = null;\n        });\n        downloadIconTrigger.onExecute( e-> downloadDocument());\n        downloadLinkTrigger.onExecute( e-> downloadDocument());\n        downloadButtonTrigger.onExecute( e-> downloadDocument());\n        newDocument.onChange(e -> updateNewDocument(e.value()));\n        save.onExecute(e -> save());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        iconTrigger.visible(mode == Mode.Icon && !readonly);\n        if (iconTrigger.isVisible()) iconTrigger.title(triggerLabel);\n        linkTrigger.visible(mode == Mode.Link && !readonly);\n        if (linkTrigger.isVisible()) linkTrigger.title(triggerLabel);\n        buttonTrigger.visible(mode == Mode.Button && !readonly);\n        if (buttonTrigger.isVisible()) buttonTrigger.title(triggerLabel);\n        downloadIconTrigger.visible(mode == Mode.Icon);\n        if (downloadIconTrigger.isVisible()) downloadIconTrigger.title(\"Descargar\");\n        downloadLinkTrigger.visible(mode == Mode.Link);\n        if (downloadLinkTrigger.isVisible()) downloadLinkTrigger.title(\"Descargar\");\n        downloadButtonTrigger.visible(mode == Mode.Button);\n        if (downloadButtonTrigger.isVisible()) downloadButtonTrigger.title(\"Descargar\");\n    }\n\n    @Override\n    public boolean isVisible() {\n        return uploadDialog.isVisible();\n    }\n\n    public void open() {\n        uploadDialog.open();\n    }\n\n    public void close() {\n        uploadDialog.close();\n    }\n\n    private UIFile downloadDocument() {\n        if (!readonly && !uploadDialog.isVisible()) open();\n        return downloadListener.apply(true);\n    }\n\n    private void updateNewDocument(Resource value) {\n        this.newDocumentResource = value;\n        save.readonly(false);\n    }\n\n    private void save() {\n        uploadDialog.close();\n        SaveFileResult result = saveListener.apply(newDocumentResource);\n        if (result != null && result.isSuccess()) uploadDialog.notifyUser(translate(\"Document saved successfully\"), UserMessage.Type.Success);\n        else uploadDialog.notifyUser(translate(result.getMessage()), UserMessage.Type.Error);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "setFilterListEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.displays.events.SelectionEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.model.EntitySetItem;\nimport io.intino.goros.egeasy.box.ui.model.InventoryItem;\nimport io.intino.goros.egeasy.box.ui.model.RelationSetItem;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport io.intino.goros.egeasy.box.ui.model.TaskSetItem;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class SetFilterListEditor extends AbstractSetFilterListEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private List<GridColumn<?>> columns;\n    private Map<String, SetFilter> filters = new HashMap<>();\n    private Consumer<SetFilter> addListener;\n    private Consumer<SetFilter> removeListener;\n    private Consumer<SetFilter> filterListener;\n    private SetFilter selectedFilter;\n\n    private static final String NoFilters = \"Todos los elementos\";\n    private static final String EditFilter = \"Filtrar elementos...\";\n    private static final String EditFilters = \"Editar filtros...\";\n\n    public SetFilterListEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public SetFilter selected() {\n        return selectedFilter;\n    }\n\n    public SetFilterListEditor taskColumns(List<GridColumn<TaskSetItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor entityColumns(List<GridColumn<EntitySetItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor relationColumns(List<GridColumn<RelationSetItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor inventoryColumns(List<GridColumn<InventoryItem>> columns) {\n        return columns(columns.stream().map(c -> (GridColumn<?>)c).collect(Collectors.toList()));\n    }\n\n    public SetFilterListEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        filterEditor.columns(columns);\n        return this;\n    }\n\n    public SetFilterListEditor filters(Map<String, SetFilter> filters) {\n        this.filters = filters;\n        return this;\n    }\n\n    public SetFilterListEditor onAdd(Consumer<SetFilter> listener) {\n        this.addListener = listener;\n        return this;\n    }\n\n    public SetFilterListEditor onRemove(Consumer<SetFilter> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    public SetFilterListEditor onFilter(Consumer<SetFilter> listener) {\n        this.filterListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        filterSelector.onSelect(this::filter);\n        initAddFilterDialog();\n        initEditFiltersDialog();\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        refreshFilterSelector();\n    }\n\n    private void initAddFilterDialog() {\n        saveFilter.onExecute(e -> saveFilter());\n        editFilterDialog.onOpen(e -> refreshEditFilterDialog());\n    }\n\n    private void refreshEditFilterDialog() {\n        SetFilter filter = selectedFilter != null ? selectedFilter : new SetFilter().title(DisplayHelper.proposeTitle(filters.values()));\n        filterEditor.filter(filter);\n        filterEditor.refresh();\n    }\n\n    private void initEditFiltersDialog() {\n        editFiltersDialog.onOpen(e -> refreshEditFiltersDialog());\n        editFiltersDialog.onClose(e -> refreshFilterSelector());\n    }\n\n    private void refreshEditFiltersDialog() {\n        refreshFilterList();\n    }\n\n    private void refreshFilterSelector() {\n        filterSelector.clear();\n        filterSelector.add(NoFilters);\n        filterSelector.add(EditFilter);\n        if (!filters.isEmpty()) filterSelector.add(EditFilters);\n        filterSelector.addAll(filters.values().stream().map(DisplayHelper::titleOf).collect(Collectors.toList()));\n        if (selectedFilter != null) filterSelector.selection(DisplayHelper.titleOf(selectedFilter));\n        else filterSelector.selection(NoFilters);\n    }\n\n    private void refreshFilterList() {\n        filterList.clear();\n        filters.values().forEach(f -> fill(f, filterList.add()));\n    }\n\n    private void fill(SetFilter filter, SetFilterItem display) {\n        display.columns(columns);\n        display.filter(filter);\n        display.onChange(f -> saveFilter(filter, f));\n        display.onRemove(f -> removeFilter(filter));\n        display.refresh();\n    }\n\n    private void saveFilter(SetFilter filter, SetFilter newFilter) {\n        addListener.accept(newFilter);\n        filters.put(newFilter.title(), newFilter);\n        if (filter.title().equals(newFilter.title())) return;\n        removeFilter(filter);\n        refreshFilterSelector();\n    }\n\n    private void saveFilter() {\n        SetFilter filter = filterEditor.filter();\n        if (filter == null || filter.title() == null || filter.title().isEmpty()) {\n            notifyUser(\"Indique un nombre para el filtro\", UserMessage.Type.Warning);\n            return;\n        }\n        if (!filter.valid()) {\n            notifyUser(\"Indique una expresi\u00f3n v\u00e1lida\", UserMessage.Type.Warning);\n            return;\n        }\n        editFilterDialog.close();\n        addListener.accept(filter);\n        filters.put(filter.title(), filter);\n        filter(filter);\n        refreshFilterSelector();\n    }\n\n    private void removeFilter(SetFilter filter) {\n        removeListener.accept(filter);\n        filters.remove(filter.title());\n        if (selectedFilter != null && filter.title().equals(selectedFilter.title())) filter((String) null);\n        refreshFilterList();\n    }\n\n    private void filter(SelectionEvent e) {\n        List<String> selection = e.selection();\n        String filterName = !selection.isEmpty() ? selection.get(0) : null;\n        if (EditFilter.equals(filterName)) editFilterDialog.open();\n        else if (EditFilters.equals(filterName)) editFiltersDialog.open();\n        else if (NoFilters.equals(filterName)) doNotFilter();\n        else filter(filterName);\n    }\n\n    private void filter(String filterName) {\n        filter(filterName != null ? filterOf(filterName) : null);\n    }\n\n    private void filter(SetFilter filter) {\n        selectedFilter = filter;\n        filterListener.accept(filter);\n    }\n\n    private void doNotFilter() {\n        filter((String) null);\n    }\n\n    private SetFilter filterOf(String filter) {\n        return filters.values().stream().filter(f -> DisplayHelper.titleOf(f).equalsIgnoreCase(filter)).findFirst().orElse(null);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "setFilterItem")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.UserMessage;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class SetFilterItem extends AbstractSetFilterItem<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private List<GridColumn<?>> columns;\n    private SetFilter filter;\n    private Consumer<SetFilter> changeListener;\n    private Consumer<SetFilter> removeListener;\n\n    public SetFilterItem(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n    }\n\n    public SetFilter filter() {\n        return this.filter;\n    }\n\n    public SetFilterItem filter(SetFilter filter) {\n        this.filter = filter;\n        return this;\n    }\n\n    public SetFilterItem onChange(Consumer<SetFilter> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    public SetFilterItem onRemove(Consumer<SetFilter> listener) {\n        this.removeListener = listener;\n        return this;\n    }\n\n    public void openEdition() {\n        editFilterDialog.open();\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        remove.onExecute(e -> removeListener.accept(filter));\n        editFilterDialog.onOpen(e -> refreshEditFilterDialog());\n        saveFilter.onExecute(e -> saveFilter());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        name.value(filter.title());\n        expression.value(filter.expression());\n    }\n\n    private void refreshEditFilterDialog() {\n        editFilterDialog.title(\"Editar \" + DisplayHelper.titleOf(filter));\n        filterEditor.columns(columns);\n        filterEditor.filter(new SetFilter().title(filter.title()).expression(filter.expression()));\n        filterEditor.refresh();\n    }\n\n    private void saveFilter() {\n        filter = filterEditor.filter();\n        if (filter == null || filter.title() == null || filter.title().isEmpty()) {\n            notifyUser(\"Indique un nombre para el filtro\", UserMessage.Type.Warning);\n            return;\n        }\n        if (!filter.valid()) {\n            notifyUser(\"Indique una expresi\u00f3n v\u00e1lida\", UserMessage.Type.Warning);\n            return;\n        }\n        refresh();\n        editFilterDialog.close();\n        changeListener.accept(filter);\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("setFilterEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.Sentence;\nimport io.intino.goros.egeasy.box.ui.model.SetFilter;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.List;\n\npublic class SetFilterEditor extends AbstractSetFilterEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private SetFilter filter;\n    private List<GridColumn<?>> columns;\n\n    public SetFilterEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public SetFilterEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        return this;\n    }\n\n    public SetFilter filter() {\n        if (!simpleEditor.isVisible() || !filter.isAdvanced()) return filter;\n        filter.expression(simpleEditor.simpleSentenceEditor.sentence().toString());\n        return filter;\n    }\n\n    public SetFilterEditor filter(SetFilter filter) {\n        this.filter = filter;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        title.onChange(e -> filter.title(e.value()));\n        title.onEnterPress(e -> filter.title(e.value()));\n        simpleEditor.onInit(e -> initSimpleEditor());\n        simpleEditor.onShow(e -> refreshSimpleEditor());\n        advancedEditor.onInit(e -> initAdvancedEditor());\n        advancedEditor.onShow(e -> refreshAdvancedEditor());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        title.value(filter.title());\n        if (filter.isAdvanced()) filterTypeSelector.select(\"advancedOption\");\n        else filterTypeSelector.select(\"simpleOption\");\n    }\n\n    private void initSimpleEditor() {\n        simpleSentenceEditor.onChange(this::updateExpressionFromSimple);\n    }\n\n    private void refreshSimpleEditor() {\n        simpleSentenceEditor.sentence(filter.simpleSentence());\n        simpleSentenceEditor.columns(columns);\n        simpleSentenceEditor.refresh();\n    }\n\n    private void initAdvancedEditor() {\n        advancedEditor.expression.onChange(e -> updateExpressionFromAdvanced());\n        advancedEditor.expression.onEnterPress(e -> updateExpressionFromAdvanced());\n        advancedSentenceEditor.onChange(sentence -> insertSentence.readonly(sentence == null));\n        insertSentence.onExecute(e -> addSentence());\n    }\n\n    private void refreshAdvancedEditor() {\n        advancedEditor.expression.value(filter.expression());\n        advancedSentenceEditor.sentence(null);\n        advancedSentenceEditor.columns(columns);\n        advancedSentenceEditor.refresh();\n    }\n\n    private void updateExpressionFromSimple(Sentence sentence) {\n        filter.expression(sentence != null ? sentence.toString() : null);\n    }\n\n    private void updateExpressionFromAdvanced() {\n        String value = advancedEditor.expression.value();\n        if (value == null || value.isEmpty()) value = null;\n        filter.expression(value);\n    }\n\n    private void addSentence() {\n        Sentence sentence = advancedSentenceEditor.sentence();\n        String expression = filter.expression();\n        if (expression != null && !expression.isEmpty()) expression += \" Y \";\n        filter.expression((expression != null ? expression : \"\") + sentence.toString());\n        refreshAdvancedEditor();\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("setFilterSentenceEditor")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.goros.egeasy.box.ui.model.Sentence;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.Arrays;\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class SetFilterSentenceEditor extends AbstractSetFilterSentenceEditor<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private Sentence sentence;\n    private List<GridColumn<?>> columns;\n    private Consumer<Sentence> changeListener;\n\n    public SetFilterSentenceEditor(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public Sentence sentence() {\n        return sentence;\n    }\n\n    public SetFilterSentenceEditor sentence(Sentence sentence) {\n        this.sentence = sentence;\n        return this;\n    }\n\n    public SetFilterSentenceEditor columns(List<GridColumn<?>> columns) {\n        this.columns = columns;\n        columnSelector.clear();\n        columnSelector.addAll(columns.stream().map(GridColumn::label).filter(c -> !c.isEmpty()).collect(Collectors.toList()));\n        columnSelector.selection(Collections.emptyList());\n        return this;\n    }\n\n    public SetFilterSentenceEditor onChange(Consumer<Sentence> listener) {\n        this.changeListener = listener;\n        return this;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        columnSelector.onSelect(e -> notifyChange());\n        operatorSelector.addAll(Arrays.stream(Sentence.Operator.values()).map(Sentence.Operator::label).collect(Collectors.toList()));\n        operatorSelector.onSelect(e -> notifyChange());\n        valueField.onChange(e -> notifyChange());\n        valueField.onEnterPress(e -> notifyChange());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        if (sentence != null) columnSelector.selection(sentence.column());\n        else columnSelector.selection();\n        if (sentence != null) operatorSelector.selection(sentence.operator().label());\n        else operatorSelector.selection(Sentence.Operator.Contains.label());\n        valueField.value(sentence != null ? sentence.value() : null);\n    }\n\n    private void notifyChange() {\n        boolean empty = columnSelector.selection().isEmpty() || operatorSelector.selection().isEmpty();\n        updateSentence(!empty ? new Sentence(column().label(), operator(), value()) : null);\n    }\n\n    private void updateSentence(Sentence sentence) {\n        this.sentence = sentence;\n        if (changeListener != null) changeListener.accept(sentence);\n    }\n\n    private GridColumn<?> column() {\n        String column = columnSelector.selection().get(0);\n        return columns.stream().filter(c -> c.name().equals(column) || c.label().equals(column)).findFirst().orElse(null);\n    }\n\n    private Sentence.Operator operator() {\n        return Sentence.Operator.from(operatorSelector.selection().get(0));\n    }\n\n    private String value() {\n        String value = valueField.value();\n        return value != null ? value : \"\";\n    }\n\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "exportWizard")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.ui.server.UIFile;\nimport io.intino.alexandria.ui.utils.DelayerUtil;\nimport io.intino.goros.egeasy.box.ui.DisplayHelper;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.EntitysetExportMode;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ExportFilesResult;\nimport io.intino.goros.egeasy.m3.entity.TGEntity;\nimport io.intino.goros.egeasy.m3.entity.component.TGTaskSet;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.io.IOException;\nimport java.io.InputStream;\nimport java.util.function.Function;\n\npublic class ExportWizard extends AbstractExportWizard<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private String filename;\n    private TGEntity entity;\n    private Mode mode;\n    private Operation operation;\n    private Function<String, ExportFilesResult> exportFileListener;\n    private Function<EntitysetExportMode, InputStream> exportSetListener;\n    private boolean readonly;\n    private UIFile file;\n\n    public enum Mode { Set, File }\n    public enum Operation { Set, File }\n\n    private static final String ExportSetTypeOption = \"csvSemicolonOption\";\n\n    public ExportWizard(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void filename(String filename) {\n        this.filename = filename;\n    }\n\n    public void entity(TGEntity entity) {\n        this.entity = entity;\n    }\n\n    public void mode(Mode mode) {\n        this.mode = mode;\n        refresh();\n    }\n\n    public void onExportFile(Function<String, ExportFilesResult> listener) {\n        this.exportFileListener = listener;\n    }\n\n    public void onExportSet(Function<EntitysetExportMode, InputStream> listener) {\n        this.exportSetListener = listener;\n    }\n\n    public void readonly(boolean readonly) {\n        this.readonly = readonly;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        exportListTrigger.onOpen(e -> refreshExportDialog(Operation.Set));\n        exportContentTrigger.onOpen(e -> {\n            refreshExportDialog(Operation.File);\n            export();\n        });\n        export.onExecute(e -> export());\n        download.onExecute(e -> download());\n        exportDialog.onOpen(e -> refreshExportDialog());\n        exportSetTypeSelector.onSelect(e -> clearDownload());\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        exportListTrigger.readonly(mode != Mode.Set);\n        exportContentTrigger.readonly(mode != Mode.File);\n    }\n\n    private void refreshExportDialog(Operation operation) {\n        this.operation = operation;\n        refreshExportDialog();\n    }\n\n    private void refreshExportDialog() {\n        if (operation == null) return;\n        clearDownload();\n        exportSetTypeSelector.visible(operation == Operation.Set);\n        exportSetTypeSelector.selection(ExportSetTypeOption);\n        export.readonly(readonly);\n    }\n\n    private void export() {\n        export.title(\"Exportando...\");\n        export.readonly(true);\n        showGeneratingFile();\n        DelayerUtil.execute(this, e -> {\n            file = operation == Operation.File ? exportFile() : exportSet();\n            showFileGenerated();\n            export.title(\"Volver a exportar\");\n            export.readonly(false);\n        });\n    }\n\n    private UIFile download() {\n        try {\n            file.content().reset();\n            return file;\n        } catch (IOException e) {\n            Logger.error(e);\n            return file;\n        }\n    }\n\n    private void clearDownload() {\n        file = null;\n        generatingBlock.visible(false);\n        generatedBlock.visible(false);\n        errorBlock.visible(false);\n        closeTrigger.title(\"Cerrar\");\n    }\n\n    private void showGeneratingFile() {\n        generatingBlock.visible(true);\n        generatedBlock.visible(false);\n        errorBlock.visible(false);\n        closeTrigger.title(\"Cancelar\");\n    }\n\n    private void showFileGenerated() {\n        generatingBlock.visible(false);\n        generatedBlock.visible(file != null);\n        errorBlock.visible(file == null);\n        closeTrigger.title(\"Cerrar\");\n    }\n\n    private UIFile exportFile() {\n        ExportFilesResult result = exportFileListener.apply(filename + exportFileExtension());\n        if (result == null || result.getFileCount() == 0) return null;\n        return DisplayHelper.uiFileOf(filename + exportFileExtension(), result.getContent());\n    }\n\n    private UIFile exportSet() {\n        String selectedType = !exportSetTypeSelector.selection().isEmpty() ? exportSetTypeSelector.selection().get(0) : ExportSetTypeOption;\n        InputStream result = exportSetListener.apply(exportMode(selectedType));\n        return result != null ? DisplayHelper.uiFileOf(filename + exportSetExtension(), result) : null;\n    }\n\n    private EntitysetExportMode exportMode(String selectedType) {\n        if (selectedType.equals(\"csvSemicolonOption\")) return EntitysetExportMode.SEMICOLON_SEPARATED;\n        if (selectedType.equals(\"csvCommaOption\")) return EntitysetExportMode.COMMA_SEPARATED;\n        return null;\n    }\n\n    private String exportFileExtension() {\n        if (entity instanceof TGTaskSet) return \".pdf\";\n        return \".zip\";\n    }\n\n    private String exportSetExtension() {\n        return \".csv\";\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "validationResult")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.ValidateResult;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class ValidationResultTemplate extends AbstractValidationResultTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private ValidateResult result;\n    private Consumer<TGFieldError> selectListener;\n    private Consumer<Boolean> closeListener;\n\n    public ValidationResultTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void result(ValidateResult result) {\n        this.result = result;\n    }\n\n    public void onSelect(Consumer<TGFieldError> listener) {\n        this.selectListener = listener;\n    }\n\n    public void onClose(Consumer<Boolean> listener) {\n        this.closeListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        close.onExecute(e -> closeListener.accept(true));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        errors.clear();\n        if (result.getValidateError() == null) return;\n        result.getValidateError().getFieldErrors().forEach(e -> fill(e, errors.add()));\n    }\n\n    private void fill(TGFieldError error, FieldResultErrorTemplate display) {\n        display.error(error);\n        display.onSelect(e -> selectListener.accept(error));\n        display.refresh();\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "validationResultError")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.goros.egeasy.box.ui.utils.Formatters;\nimport io.intino.goros.egeasy.driver.driversystem.server.model.TGFieldError;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.function.Consumer;\n\npublic class FieldResultErrorTemplate extends AbstractFieldResultErrorTemplate<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGFieldError error;\n    private Consumer<TGFieldError> selectListener;\n\n    public FieldResultErrorTemplate(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void error(TGFieldError error) {\n        this.error = error;\n    }\n\n    public void onSelect(Consumer<TGFieldError> listener) {\n        this.selectListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        target.onExecute(e -> selectListener.accept(error));\n    }\n\n    @Override\n    public void refresh() {\n        super.refresh();\n        warningIcon.visible(error.getType() == TGFieldError.ValidateErrorType.Warning);\n        errorIcon.visible(error.getType() == TGFieldError.ValidateErrorType.Error);\n        target.title(error.getErrorname() + \". \" + Formatters.firstUpperCase(error.getMessage()));\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "fieldOptionSelectorWizard")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.events.collection.CellClickEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.goros.egeasy.box.ui.datasources.OptionDatasource;\nimport io.intino.goros.egeasy.box.ui.model.OptionItem;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.Map;\nimport java.util.function.Consumer;\nimport java.util.stream.Collectors;\n\npublic class FieldOptionSelectorWizard extends AbstractFieldOptionSelectorWizard<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGResource container;\n    private int drc;\n    private Integer rowIndex;\n    private Consumer<String> selectListener;\n\n    public FieldOptionSelectorWizard(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void container(TGResource container) {\n        this.container = container;\n    }\n\n    public void field(int drc) {\n        field(drc, null);\n    }\n\n    public void field(int drc, Integer rowIndex) {\n        this.drc = drc;\n        this.rowIndex = rowIndex;\n    }\n\n    public void readonly(boolean readonly) {\n        dialogTrigger.readonly(readonly);\n    }\n\n    public void onSelect(Consumer<String> listener) {\n        this.selectListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        fieldOptionSelectorGrid.itemResolver(itemResolver());\n        fieldOptionSelectorGrid.onClickCell(this::select);\n        fieldOptionSelectorDialog.onOpen(e -> prepareGrid());\n    }\n\n    private Grid.ItemResolver<OptionItem> itemResolver() {\n        return new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(OptionItem option) {\n                GridItem result = new GridItem();\n                Map<String, String> values = option.values();\n                values.forEach((key, value) -> result.add(value));\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<OptionItem> column, OptionItem entity) {\n                return null;\n            }\n        };\n    }\n\n    private void select(CellClickEvent event) {\n        fieldOptionSelectorDialog.close();\n        selectListener.accept(((OptionItem)event.item()).code());\n    }\n\n    private void prepareGrid() {\n        OptionDatasource source = new OptionDatasource(box().provider(session()), session(), container, drc, rowIndex);\n        fieldOptionSelectorGrid.columns(source.columns().stream().map(this::columnOf).collect(Collectors.toList()));\n        fieldOptionSelectorGrid.source(source);\n    }\n\n    private io.intino.alexandria.ui.model.datasource.grid.GridColumn<OptionItem> columnOf(String column) {\n        return new GridColumn<OptionItem>().name(column).label(column).type(GridColumn.Type.Text);\n    }\n}")));
        rules.add(this.rule().condition(Predicates.allTypes("ui", "fieldCodeSelectorWizard")).output(Outputs.literal("package ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.ui.displays.templates;\n\nimport io.intino.alexandria.ui.displays.components.Grid;\nimport io.intino.alexandria.ui.displays.events.collection.CellClickEvent;\nimport io.intino.alexandria.ui.model.datasource.grid.GridColumn;\nimport io.intino.alexandria.ui.model.datasource.grid.GridItem;\nimport io.intino.goros.egeasy.box.ui.datasources.CodeGridDatasource;\nimport io.intino.goros.egeasy.box.ui.model.CodeItem;\nimport io.intino.goros.egeasy.m3.entity.resource.TGResource;\nimport ")).output(Outputs.placeholder("package", new String[0])).output(Outputs.literal(".")).output(Outputs.placeholder("boxName", "lowerCase")).output(Outputs.literal(".box.")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box;\n\nimport java.util.List;\nimport java.util.function.Consumer;\n\npublic class FieldCodeSelectorWizard extends AbstractFieldCodeSelectorWizard<")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box> {\n    private TGResource container;\n    private int drc;\n    private Integer rowIndex;\n    private Consumer<CodeItem> selectListener;\n\n    public FieldCodeSelectorWizard(")).output(Outputs.placeholder("boxName", "firstUpperCase")).output(Outputs.literal("Box box) {\n        super(box);\n    }\n\n    public void container(TGResource container) {\n        this.container = container;\n    }\n\n    public void field(int drc) {\n        field(drc, null);\n    }\n\n    public void field(int drc, Integer rowIndex) {\n        this.drc = drc;\n        this.rowIndex = rowIndex;\n    }\n\n    public void readonly(boolean readonly) {\n        dialogTrigger.readonly(readonly);\n    }\n\n    public void onSelect(Consumer<CodeItem> listener) {\n        this.selectListener = listener;\n    }\n\n    @Override\n    public void init() {\n        super.init();\n        fieldCodeSelectorGrid.itemResolver(itemResolver());\n        fieldCodeSelectorGrid.onClickCell(this::select);\n        fieldCodeSelectorDialog.onOpen(e -> prepareGrid());\n    }\n\n    private Grid.ItemResolver<CodeItem> itemResolver() {\n        return new Grid.ItemResolver<>() {\n            @Override\n            public GridItem build(CodeItem option) {\n                GridItem result = new GridItem();\n                result.add(option.getCode());\n                result.add(option.getSticker());\n                return result;\n            }\n\n            @Override\n            public String address(GridColumn<CodeItem> column, CodeItem entity) {\n                return null;\n            }\n        };\n    }\n\n    private void select(CellClickEvent event) {\n        fieldCodeSelectorDialog.close();\n        selectListener.accept(event.item());\n    }\n\n    private void prepareGrid() {\n        CodeGridDatasource source = new CodeGridDatasource(box().provider(session()), session(), container, drc, rowIndex);\n        fieldCodeSelectorGrid.columns(List.of(columnOf(\"C\u00f3digo\"), columnOf(\"Descripci\u00f3n\")));\n        fieldCodeSelectorGrid.source(source);\n    }\n\n    private io.intino.alexandria.ui.model.datasource.grid.GridColumn<CodeItem> columnOf(String column) {\n        return new GridColumn<CodeItem>().name(column).label(column).type(GridColumn.Type.Text);\n    }\n\n}")));
        return rules;
    }

    public String render(Object object) {
        return new Engine(this).render(object);
    }

    public String render(Object object, Map<String, Formatter> formatters) {
        return new Engine(this).addAll(formatters).render(object);
    }
}

