/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.formatters;

import io.intino.itrules.Formatter;
import io.intino.itrules.formatters.spelling.EnglishNumberSpelling;
import io.intino.itrules.formatters.spelling.SpanishNumberSpelling;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NumberFormatters {
    public static Map<String, Formatter> get(Locale locale) {
        HashMap<String, Formatter> map = NumberFormatters.map();
        map.put("Words", NumberFormatters.numberSpellingFormatter(locale));
        map.put("Separators", NumberFormatters.separators(locale));
        map.put("TwoDecimals", NumberFormatters.twoDecimals(locale));
        return map;
    }

    private static HashMap<String, Formatter> map() {
        return new HashMap<String, Formatter>(){

            @Override
            public Formatter put(String key, Formatter value) {
                return super.put(key.toLowerCase(), value);
            }
        };
    }

    private static Formatter separators(Locale locale) {
        return value -> {
            if (!NumberFormatters.isNumber(value)) {
                return value;
            }
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            df.setGroupingUsed(true);
            df.setGroupingSize(3);
            return df.format(value);
        };
    }

    private static Formatter twoDecimals(Locale locale) {
        return value -> {
            if (!NumberFormatters.isNumber(value)) {
                return value;
            }
            double n = ((Number)value).doubleValue();
            return String.format(locale, "%.2f", n);
        };
    }

    private static Formatter numberSpellingFormatter(Locale locale) {
        NumberSpelling spelling = locale.getLanguage().equals("es") ? new SpanishNumberSpelling() : new EnglishNumberSpelling();
        return value -> NumberFormatters.isNumber(value) ? spelling.spell((Integer)value) : value;
    }

    private static boolean isNumber(Object value) {
        return Number.class.isAssignableFrom(value.getClass());
    }

    public static interface NumberSpelling {
        public String spell(int var1);
    }
}

